/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.request;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public final class Argument
implements Serializable {
    private static final long serialVersionUID = 2913180218704512683L;
    public static final Pattern ARGUMENTS_PATTERN = Pattern.compile("\\[(\\w+):([^\\]]+)\\]");
    @NonNull
    private final String name;
    private final Object value;

    public Class<?> getType() {
        return this.value.getClass();
    }

    public static Set<Argument> getArgumentsFromString(String argsString) throws UnsupportedEncodingException {
        HashSet<Argument> arguments = new HashSet<Argument>();
        if (!StringUtils.isEmpty((CharSequence)argsString)) {
            Matcher matcher = ARGUMENTS_PATTERN.matcher(argsString);
            while (matcher.find()) {
                arguments.add(Argument.builder().name(matcher.group(1)).value(URLDecoder.decode(matcher.group(2), StandardCharsets.UTF_8.name())).build());
            }
        }
        return arguments;
    }

    public static Map<String, Argument> getArgumentMapFromArgumentSet(Set<Argument> arguments) {
        return arguments.stream().collect(Collectors.toMap(Argument::getName, Function.identity()));
    }

    public static Map<String, Argument> getArgumentMapFromString(String argsString) throws UnsupportedEncodingException {
        return Argument.getArgumentMapFromArgumentSet(Argument.getArgumentsFromString(argsString));
    }

    @Generated
    Argument(@NonNull String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        this.value = value;
    }

    @Generated
    public static ArgumentBuilder builder() {
        return new ArgumentBuilder();
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Argument)) {
            return false;
        }
        Argument other = (Argument)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Argument(name=" + this.getName() + ", value=" + this.getValue() + ")";
    }

    @Generated
    public static class ArgumentBuilder {
        @Generated
        private String name;
        @Generated
        private Object value;

        @Generated
        ArgumentBuilder() {
        }

        @Generated
        public ArgumentBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public ArgumentBuilder value(Object value) {
            this.value = value;
            return this;
        }

        @Generated
        public Argument build() {
            return new Argument(this.name, this.value);
        }

        @Generated
        public String toString() {
            return "Argument.ArgumentBuilder(name=" + this.name + ", value=" + this.value + ")";
        }
    }
}

