/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter;

import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.exceptions.InvalidOperatorNegationException;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Operator {
    IN("in", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.in(fieldPath, values, requestScope);
        }
    }
    ,
    IN_INSENSITIVE("ini", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.in(fieldPath, values, requestScope, FOLD_CASE);
        }
    }
    ,
    NOT("not", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return entity -> !Operator.in(fieldPath, values, requestScope).test(entity);
        }
    }
    ,
    NOT_INSENSITIVE("noti", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return entity -> !Operator.in(fieldPath, values, requestScope, FOLD_CASE).test(entity);
        }
    }
    ,
    PREFIX_CASE_INSENSITIVE("prefixi", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.prefix(fieldPath, values, requestScope, s -> s.toLowerCase(Locale.ENGLISH));
        }
    }
    ,
    NOT_PREFIX_CASE_INSENSITIVE("notprefixi", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.notprefix(fieldPath, values, requestScope, s -> s.toLowerCase(Locale.ENGLISH));
        }
    }
    ,
    PREFIX("prefix", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.prefix(fieldPath, values, requestScope, UnaryOperator.identity());
        }
    }
    ,
    NOT_PREFIX("notprefix", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.notprefix(fieldPath, values, requestScope, UnaryOperator.identity());
        }
    }
    ,
    POSTFIX("postfix", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.postfix(fieldPath, values, requestScope, UnaryOperator.identity());
        }
    }
    ,
    NOT_POSTFIX("notpostfix", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.notpostfix(fieldPath, values, requestScope, UnaryOperator.identity());
        }
    }
    ,
    POSTFIX_CASE_INSENSITIVE("postfixi", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.postfix(fieldPath, values, requestScope, FOLD_CASE);
        }
    }
    ,
    NOT_POSTFIX_CASE_INSENSITIVE("notpostfixi", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.notpostfix(fieldPath, values, requestScope, FOLD_CASE);
        }
    }
    ,
    INFIX("infix", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.infix(fieldPath, values, requestScope, UnaryOperator.identity());
        }
    }
    ,
    NOT_INFIX("notinfix", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.notinfix(fieldPath, values, requestScope, UnaryOperator.identity());
        }
    }
    ,
    INFIX_CASE_INSENSITIVE("infixi", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.infix(fieldPath, values, requestScope, FOLD_CASE);
        }
    }
    ,
    NOT_INFIX_CASE_INSENSITIVE("notinfixi", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.notinfix(fieldPath, values, requestScope, FOLD_CASE);
        }
    }
    ,
    ISNULL("isnull", false){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.isNull(fieldPath, requestScope);
        }
    }
    ,
    NOTNULL("notnull", false){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return val -> !Operator.isNull(fieldPath, requestScope).test(val);
        }
    }
    ,
    LT("lt", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.lt(fieldPath, values, requestScope);
        }
    }
    ,
    LE("le", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.le(fieldPath, values, requestScope);
        }
    }
    ,
    GT("gt", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.gt(fieldPath, values, requestScope);
        }
    }
    ,
    GE("ge", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.ge(fieldPath, values, requestScope);
        }
    }
    ,
    TRUE("true", false){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.isTrue();
        }
    }
    ,
    FALSE("false", false){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.isFalse();
        }
    }
    ,
    ISEMPTY("isempty", false){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.isEmpty(fieldPath, requestScope);
        }
    }
    ,
    NOTEMPTY("notempty", false){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return entity -> !Operator.isEmpty(fieldPath, requestScope).test(entity);
        }
    }
    ,
    HASMEMBER("hasmember", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.hasMember(fieldPath, values, requestScope);
        }
    }
    ,
    HASNOMEMBER("hasnomember", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return entity -> !Operator.hasMember(fieldPath, values, requestScope).test(entity);
        }
    }
    ,
    SUBSETOF("subsetof", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.subsetOf(fieldPath, values, requestScope);
        }
    }
    ,
    NOTSUBSETOF("notsubsetof", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return entity -> !Operator.subsetOf(fieldPath, values, requestScope).test(entity);
        }
    }
    ,
    SUPERSETOF("supersetof", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return Operator.supersetOf(fieldPath, values, requestScope);
        }
    }
    ,
    NOTSUPERSETOF("notsupersetof", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return entity -> !Operator.supersetOf(fieldPath, values, requestScope).test(entity);
        }
    }
    ,
    BETWEEN("between", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return entity -> Operator.between(fieldPath, values, requestScope).test(entity);
        }
    }
    ,
    NOTBETWEEN("notbetween", true){

        @Override
        public <T> Predicate<T> contextualize(Path fieldPath, List<Object> values, RequestScope requestScope) {
            return entity -> !Operator.between(fieldPath, values, requestScope).test(entity);
        }
    };

    public static final UnaryOperator<String> FOLD_CASE;
    private final String notation;
    private final boolean parameterized;
    private Operator negated;

    public static Operator fromString(String string) {
        for (Operator operator : Operator.values()) {
            if (!operator.getNotation().equals(string)) continue;
            return operator;
        }
        throw new BadRequestException("Unknown operator in filter: " + string);
    }

    public abstract <T> Predicate<T> contextualize(Path var1, List<Object> var2, RequestScope var3);

    private static <T> Predicate<T> in(Path fieldPath, List<Object> values, RequestScope requestScope) {
        return entity -> {
            BiPredicate<Object, Object> predicate = (a, b) -> a.equals(b);
            return Operator.evaluate(entity, fieldPath, values, predicate, requestScope);
        };
    }

    private static <T> Predicate<T> in(Path fieldPath, List<Object> values, RequestScope requestScope, UnaryOperator<String> transform) {
        return entity -> {
            BiPredicate<Object, Object> predicate = (a, b) -> {
                if (!a.getClass().isAssignableFrom(String.class)) {
                    throw new IllegalStateException("Cannot case insensitive compare non-string values");
                }
                String lhs = (String)transform.apply((String)a);
                String rhs = (String)transform.apply(CoerceUtil.coerce(b, String.class));
                return lhs.equals(rhs);
            };
            return Operator.evaluate(entity, fieldPath, values, predicate, requestScope);
        };
    }

    private static <T> Predicate<T> prefix(Path fieldPath, List<Object> values, RequestScope requestScope, UnaryOperator<String> transform) {
        return entity -> {
            if (values.size() != 1) {
                throw new BadRequestException("PREFIX can only take one argument");
            }
            BiPredicate<Object, Object> predicate = (a, b) -> {
                String lhs = (String)transform.apply(CoerceUtil.coerce(a, String.class));
                String rhs = (String)transform.apply(CoerceUtil.coerce(b, String.class));
                return lhs != null && rhs != null && lhs.startsWith(rhs);
            };
            return Operator.evaluate(entity, fieldPath, values, predicate, requestScope);
        };
    }

    private static <T> Predicate<T> notprefix(Path fieldPath, List<Object> values, RequestScope requestScope, UnaryOperator<String> transform) {
        return entity -> {
            if (values.size() != 1) {
                throw new BadRequestException("NOTPREFIX can only take one argument");
            }
            BiPredicate<Object, Object> predicate = (a, b) -> {
                String lhs = (String)transform.apply(CoerceUtil.coerce(a, String.class));
                String rhs = (String)transform.apply(CoerceUtil.coerce(b, String.class));
                return lhs != null && rhs != null && !lhs.startsWith(rhs);
            };
            return Operator.evaluate(entity, fieldPath, values, predicate, requestScope);
        };
    }

    private static <T> Predicate<T> postfix(Path fieldPath, List<Object> values, RequestScope requestScope, UnaryOperator<String> transform) {
        return entity -> {
            if (values.size() != 1) {
                throw new BadRequestException("POSTFIX can only take one argument");
            }
            BiPredicate<Object, Object> predicate = (a, b) -> {
                String lhs = (String)transform.apply(CoerceUtil.coerce(a, String.class));
                String rhs = (String)transform.apply(CoerceUtil.coerce(b, String.class));
                return lhs != null && rhs != null && lhs.endsWith(rhs);
            };
            return Operator.evaluate(entity, fieldPath, values, predicate, requestScope);
        };
    }

    private static <T> Predicate<T> notpostfix(Path fieldPath, List<Object> values, RequestScope requestScope, UnaryOperator<String> transform) {
        return entity -> {
            if (values.size() != 1) {
                throw new BadRequestException("NOTPOSTFIX can only take one argument");
            }
            BiPredicate<Object, Object> predicate = (a, b) -> {
                String lhs = (String)transform.apply(CoerceUtil.coerce(a, String.class));
                String rhs = (String)transform.apply(CoerceUtil.coerce(b, String.class));
                return lhs != null && rhs != null && !lhs.endsWith(rhs);
            };
            return Operator.evaluate(entity, fieldPath, values, predicate, requestScope);
        };
    }

    private static <T> Predicate<T> infix(Path fieldPath, List<Object> values, RequestScope requestScope, UnaryOperator<String> transform) {
        return entity -> {
            if (values.size() != 1) {
                throw new BadRequestException("INFIX can only take one argument");
            }
            BiPredicate<Object, Object> predicate = (a, b) -> {
                String lhs = (String)transform.apply(CoerceUtil.coerce(a, String.class));
                String rhs = (String)transform.apply(CoerceUtil.coerce(b, String.class));
                return lhs != null && rhs != null && lhs.contains(rhs);
            };
            return Operator.evaluate(entity, fieldPath, values, predicate, requestScope);
        };
    }

    private static <T> Predicate<T> notinfix(Path fieldPath, List<Object> values, RequestScope requestScope, UnaryOperator<String> transform) {
        return entity -> {
            if (values.size() != 1) {
                throw new BadRequestException("NOTINFIX can only take one argument");
            }
            BiPredicate<Object, Object> predicate = (a, b) -> {
                String lhs = (String)transform.apply(CoerceUtil.coerce(a, String.class));
                String rhs = (String)transform.apply(CoerceUtil.coerce(b, String.class));
                return lhs != null && rhs != null && !lhs.contains(rhs);
            };
            return Operator.evaluate(entity, fieldPath, values, predicate, requestScope);
        };
    }

    private static <T> Predicate<T> isNull(Path fieldPath, RequestScope requestScope) {
        return entity -> Operator.getFieldValue(entity, fieldPath, requestScope) == null;
    }

    private static <T> Predicate<T> lt(Path fieldPath, List<Object> values, RequestScope requestScope) {
        return Operator.getComparator(fieldPath, values, requestScope, compareResult -> compareResult < 0);
    }

    private static <T> Predicate<T> le(Path fieldPath, List<Object> values, RequestScope requestScope) {
        return Operator.getComparator(fieldPath, values, requestScope, compareResult -> compareResult <= 0);
    }

    private static <T> Predicate<T> gt(Path fieldPath, List<Object> values, RequestScope requestScope) {
        return Operator.getComparator(fieldPath, values, requestScope, compareResult -> compareResult > 0);
    }

    private static <T> Predicate<T> ge(Path fieldPath, List<Object> values, RequestScope requestScope) {
        return Operator.getComparator(fieldPath, values, requestScope, compareResult -> compareResult >= 0);
    }

    private static <T> Predicate<T> between(Path fieldPath, List<Object> values, RequestScope requestScope) {
        return entity -> {
            if (values.size() != 2) {
                throw new BadRequestException("Between operator expects exactly 2 values");
            }
            Object fieldVal = Operator.getFieldValue(entity, fieldPath, requestScope);
            if (fieldVal instanceof Collection) {
                return false;
            }
            return fieldVal != null && Operator.compare(fieldVal, values.get(0)) >= 0 && Operator.compare(fieldVal, values.get(1)) <= 0;
        };
    }

    private static <T> Predicate<T> isTrue() {
        return entity -> true;
    }

    private static <T> Predicate<T> isFalse() {
        return entity -> false;
    }

    private static <T> Predicate<T> isEmpty(Path fieldPath, RequestScope requestScope) {
        return entity -> {
            Object val = Operator.getFieldValue(entity, fieldPath, requestScope);
            if (val instanceof Collection) {
                Collection collection = (Collection)val;
                return collection.isEmpty();
            }
            if (val instanceof Map) {
                Map map = (Map)val;
                return map.isEmpty();
            }
            return false;
        };
    }

    private static <T> Predicate<T> hasMember(Path fieldPath, List<Object> values, RequestScope requestScope) {
        return entity -> {
            if (values.size() != 1) {
                throw new BadRequestException("HasMember can only take one argument");
            }
            Object val = Operator.getFieldValue(entity, fieldPath, requestScope, true);
            Object filterStr = fieldPath.lastElement().map(last -> CoerceUtil.coerce(values.get(0), last.getFieldType())).orElseGet(() -> CoerceUtil.coerce(values.get(0), String.class));
            if (val instanceof Collection) {
                Collection collection = (Collection)val;
                if ("null".equals(filterStr) && collection.contains(null)) {
                    return true;
                }
                return collection.contains(filterStr);
            }
            if (val instanceof Map) {
                Map map = (Map)val;
                if ("null".equals(filterStr) && map.containsKey(null)) {
                    return true;
                }
                return map.containsKey(filterStr);
            }
            return false;
        };
    }

    private static <T> Predicate<T> subsetOf(Path fieldPath, List<Object> values, RequestScope requestScope) {
        return entity -> {
            Type valueClass = fieldPath.lastElement().get().getFieldType();
            Object leftHandSide = Operator.getFieldValue(entity, fieldPath, requestScope);
            BiPredicate<Object, Object> predicate = (a, b) -> a.equals(b);
            List<Object> rightHandSide = values.stream().map(value -> CoerceUtil.coerce(value, valueClass)).toList();
            if (leftHandSide instanceof Collection) {
                Collection collection = (Collection)leftHandSide;
                if (!valueClass.isAssignableFrom(ClassType.COLLECTION_TYPE)) {
                    for (Object left : collection) {
                        if (rightHandSide.stream().anyMatch(object -> predicate.test(left, object))) continue;
                        return false;
                    }
                    return true;
                }
            }
            return true;
        };
    }

    private static <T> Predicate<T> supersetOf(Path fieldPath, List<Object> values, RequestScope requestScope) {
        return entity -> {
            Type valueClass = fieldPath.lastElement().get().getFieldType();
            Object leftHandSide = Operator.getFieldValue(entity, fieldPath, requestScope);
            BiPredicate<Object, Object> predicate = (a, b) -> a.equals(b);
            List<Object> rightHandSide = values.stream().map(value -> CoerceUtil.coerce(value, valueClass)).toList();
            if (leftHandSide instanceof Collection) {
                Collection collection = (Collection)leftHandSide;
                if (!valueClass.isAssignableFrom(ClassType.COLLECTION_TYPE)) {
                    Object right;
                    Iterator<Object> iterator = rightHandSide.iterator();
                    do {
                        if (!iterator.hasNext()) return true;
                        right = iterator.next();
                    } while (collection.stream().anyMatch(object -> predicate.test(right, object)));
                    return false;
                }
            }
            if (rightHandSide.isEmpty()) return true;
            return false;
        };
    }

    private static <T> Object getFieldValue(T entity, Path fieldPath, RequestScope requestScope) {
        return Operator.getFieldValue(entity, fieldPath, requestScope, false);
    }

    private static <T> Object getFieldValue(T entity, Path fieldPath, RequestScope requestScope, boolean nullable) {
        Object val = entity;
        for (Path.PathElement field : fieldPath.getPathElements()) {
            if ("this".equals(field.getFieldName())) continue;
            if (val == null) break;
            if (val instanceof Collection) {
                Collection collection = (Collection)val;
                val = collection.stream().filter(Objects::nonNull).map(target -> PersistentResource.getValue(target, field.getFieldName(), requestScope)).filter(test -> Objects.nonNull(test) || nullable).flatMap(result -> {
                    if (result instanceof Collection) {
                        Collection resultCollection = (Collection)result;
                        return resultCollection.stream();
                    }
                    return Stream.of(result);
                }).collect(Collectors.toSet());
                continue;
            }
            val = PersistentResource.getValue(val, field.getFieldName(), requestScope);
        }
        return val;
    }

    private static <T> Predicate<T> getComparator(Path fieldPath, List<Object> values, RequestScope requestScope, IntPredicate condition) {
        return entity -> {
            if (CollectionUtils.isEmpty((Collection)values)) {
                throw new BadRequestException("No value to compare");
            }
            Object fieldVal = Operator.getFieldValue(entity, fieldPath, requestScope);
            if (fieldVal instanceof Collection) {
                Collection collection = (Collection)fieldVal;
                return collection.stream().anyMatch(fieldValueElement -> fieldValueElement != null && values.stream().anyMatch(testVal -> condition.test(Operator.compare(fieldValueElement, testVal))));
            }
            return fieldVal != null && values.stream().anyMatch(testVal -> condition.test(Operator.compare(fieldVal, testVal)));
        };
    }

    private static int compare(Object fieldValue, Object rawTestValue) {
        Object testValue = CoerceUtil.coerce(rawTestValue, fieldValue.getClass());
        Comparable testComp = CoerceUtil.coerce(testValue, Comparable.class);
        Comparable fieldComp = CoerceUtil.coerce(fieldValue, Comparable.class);
        return fieldComp.compareTo(testComp);
    }

    private static boolean evaluate(Object entity, Path fieldPath, List<Object> values, BiPredicate<Object, Object> predicate, RequestScope requestScope) {
        Type valueClass = fieldPath.lastElement().get().getFieldType();
        Object leftHandSide = Operator.getFieldValue(entity, fieldPath, requestScope);
        if (leftHandSide instanceof Collection) {
            Collection collection = (Collection)leftHandSide;
            if (!valueClass.isAssignableFrom(ClassType.COLLECTION_TYPE)) {
                return collection.stream().anyMatch(leftHandSideElement -> values.stream().map(value -> CoerceUtil.coerce(value, valueClass)).anyMatch(value -> predicate.test(leftHandSideElement, value)));
            }
        }
        return leftHandSide != null && values.stream().map(value -> valueClass == null ? value : CoerceUtil.coerce(value, valueClass)).anyMatch(value -> predicate.test(leftHandSide, value));
    }

    public Operator negate() {
        if (this.negated == null) {
            throw new InvalidOperatorNegationException();
        }
        return this.negated;
    }

    @Generated
    private Operator(String notation, boolean parameterized) {
        this.notation = notation;
        this.parameterized = parameterized;
    }

    @Generated
    public String getNotation() {
        return this.notation;
    }

    @Generated
    public boolean isParameterized() {
        return this.parameterized;
    }

    static {
        FOLD_CASE = s -> s.toLowerCase(Locale.ENGLISH);
        Map operators = Map.ofEntries(Map.entry(GE, LT), Map.entry(GT, LE), Map.entry(IN, NOT), Map.entry(IN_INSENSITIVE, NOT_INSENSITIVE), Map.entry(TRUE, FALSE), Map.entry(ISNULL, NOTNULL), Map.entry(ISEMPTY, NOTEMPTY), Map.entry(HASMEMBER, HASNOMEMBER), Map.entry(BETWEEN, NOTBETWEEN), Map.entry(PREFIX, NOT_PREFIX), Map.entry(PREFIX_CASE_INSENSITIVE, NOT_PREFIX_CASE_INSENSITIVE), Map.entry(INFIX, NOT_INFIX), Map.entry(INFIX_CASE_INSENSITIVE, NOT_INFIX_CASE_INSENSITIVE), Map.entry(POSTFIX, NOT_POSTFIX), Map.entry(POSTFIX_CASE_INSENSITIVE, NOT_POSTFIX_CASE_INSENSITIVE));
        for (Map.Entry entry : operators.entrySet()) {
            Operator negated;
            Operator operator = (Operator)((Object)entry.getKey());
            operator.negated = negated = (Operator)((Object)entry.getValue());
            negated.negated = operator;
        }
    }
}

