/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.exceptions;

import com.yahoo.elide.ElideErrorResponse;
import com.yahoo.elide.ElideErrors;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.ClassType;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpStatusException
extends RuntimeException {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpStatusException.class);
    private static final long serialVersionUID = 1L;
    protected final int status;
    private final Optional<Supplier<String>> verboseMessageSupplier;

    protected HttpStatusException(int status, String message) {
        this(status, message, null, null);
    }

    protected HttpStatusException(int status, String message, Throwable cause, Supplier<String> verboseMessageSupplier) {
        super(message, cause, true, log.isTraceEnabled());
        this.status = status;
        this.verboseMessageSupplier = Optional.ofNullable(verboseMessageSupplier);
    }

    protected static String formatExceptionCause(Throwable e) {
        Throwable error = e.getCause() == null ? e : e.getCause();
        return error != null ? (String)StringUtils.defaultIfBlank((CharSequence)error.getMessage(), (CharSequence)error.toString()) : null;
    }

    public ElideErrorResponse<? extends Object> getErrorResponse() {
        return this.buildResponse(this.getMessage());
    }

    public ElideErrorResponse<? extends Object> getVerboseErrorResponse() {
        return this.buildResponse(this.getVerboseMessage());
    }

    private ElideErrorResponse<ElideErrors> buildResponse(String message) {
        return ElideErrorResponse.status(this.getStatus()).errors(errors -> errors.error(error -> error.message(message)));
    }

    public String getVerboseMessage() {
        String verboseMessage = this.verboseMessageSupplier.map(Supplier::get).orElse(null);
        if (verboseMessage != null) {
            if (verboseMessage.equals(this.getMessage())) {
                return verboseMessage;
            }
            return this.getMessage() + "\n" + verboseMessage;
        }
        return this.getMessage();
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public String toString() {
        Object message = this.getMessage();
        String className = EntityDictionary.getSimpleName(ClassType.of(this.getClass()));
        message = message == null ? className : className + ": " + (String)message;
        return message;
    }
}

