/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.datastore;

import com.yahoo.elide.core.datastore.DataStoreIterable;
import java.util.ArrayList;

public class DataStoreIterableBuilder<T> {
    private boolean filterInMemory = false;
    private boolean sortInMemory = false;
    private boolean paginateInMemory = false;
    private final Iterable<T> wrapped;

    public DataStoreIterableBuilder() {
        this.wrapped = new ArrayList<T>();
    }

    public DataStoreIterableBuilder(Iterable<T> wrapped) {
        this.wrapped = wrapped == null ? new ArrayList<T>() : wrapped;
    }

    public DataStoreIterableBuilder filterInMemory(boolean filterInMemory) {
        this.filterInMemory = filterInMemory;
        return this;
    }

    public DataStoreIterableBuilder sortInMemory(boolean sortInMemory) {
        this.sortInMemory = sortInMemory;
        return this;
    }

    public DataStoreIterableBuilder paginateInMemory(boolean paginateInMemory) {
        this.paginateInMemory = paginateInMemory;
        return this;
    }

    public DataStoreIterableBuilder allInMemory() {
        this.filterInMemory = true;
        this.sortInMemory = true;
        this.paginateInMemory = true;
        return this;
    }

    public DataStoreIterable<T> build() {
        return new DataStoreIterable<T>(){

            @Override
            public Iterable<T> getWrappedIterable() {
                return DataStoreIterableBuilder.this.wrapped;
            }

            @Override
            public boolean needsInMemoryFilter() {
                return DataStoreIterableBuilder.this.filterInMemory;
            }

            @Override
            public boolean needsInMemorySort() {
                return DataStoreIterableBuilder.this.sortInMemory;
            }

            @Override
            public boolean needsInMemoryPagination() {
                return DataStoreIterableBuilder.this.paginateInMemory;
            }
        };
    }
}

