/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.audit;

import com.yahoo.elide.annotation.Audit;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.ResourceLineage;
import com.yahoo.elide.core.audit.InvalidSyntaxException;
import com.yahoo.elide.core.audit.LogMessage;
import com.yahoo.elide.core.security.ChangeSpec;
import com.yahoo.elide.core.security.User;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.StandardELContext;
import jakarta.el.ValueExpression;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class LogMessageImpl
implements LogMessage {
    private static final ExpressionFactory EXPRESSION_FACTORY = ExpressionFactory.newInstance();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final String template;
    private final String[] expressions;
    private final int operationCode;
    private final Optional<ChangeSpec> changeSpec;
    private final User user;
    private final com.yahoo.elide.core.security.PersistentResource persistentResource;

    public LogMessageImpl(String template, int code) {
        this(template, null, EMPTY_STRING_ARRAY, code, Optional.empty());
    }

    public LogMessageImpl(Audit audit, com.yahoo.elide.core.security.PersistentResource record, Optional<ChangeSpec> changeSpec) throws InvalidSyntaxException {
        this(audit.logStatement(), record, audit.logExpressions(), audit.operation(), changeSpec);
    }

    public LogMessageImpl(String template, com.yahoo.elide.core.security.PersistentResource record, String[] expressions, int code, Optional<ChangeSpec> changeSpec) throws InvalidSyntaxException {
        this.template = template;
        this.persistentResource = record;
        this.expressions = expressions;
        this.operationCode = code;
        this.changeSpec = changeSpec;
        this.user = record == null ? null : record.getRequestScope().getUser();
    }

    @Override
    public String getMessage() {
        StandardELContext ctx = new StandardELContext(EXPRESSION_FACTORY);
        StandardELContext singleElementContext = new StandardELContext(EXPRESSION_FACTORY);
        if (this.persistentResource != null) {
            PersistentResource internalResource = (PersistentResource)this.persistentResource;
            ResourceLineage lineage = new ResourceLineage(internalResource.getLineage(), internalResource, null);
            for (String name : lineage.getKeys()) {
                ValueExpression singleElementExpression;
                ValueExpression expression;
                List<PersistentResource> values = lineage.getRecord(name);
                if (values.size() == 1) {
                    singleElementExpression = expression = EXPRESSION_FACTORY.createValueExpression(values.get(0).getObject(), Object.class);
                } else {
                    List objects = values.stream().map(com.yahoo.elide.core.security.PersistentResource::getObject).collect(Collectors.toList());
                    expression = EXPRESSION_FACTORY.createValueExpression(objects, List.class);
                    singleElementExpression = EXPRESSION_FACTORY.createValueExpression(values.get(values.size() - 1).getObject(), Object.class);
                }
                ctx.getVariableMapper().setVariable(name, expression);
                singleElementContext.getVariableMapper().setVariable(name, singleElementExpression);
            }
            Object user = this.getUser().getPrincipal();
            if (user != null) {
                ValueExpression opaqueUserValueExpression = EXPRESSION_FACTORY.createValueExpression(user, Object.class);
                ctx.getVariableMapper().setVariable("opaqueUser", opaqueUserValueExpression);
                singleElementContext.getVariableMapper().setVariable("opaqueUser", opaqueUserValueExpression);
            }
        }
        Object[] results = new Object[this.expressions.length];
        for (int idx = 0; idx < results.length; ++idx) {
            Object result;
            ValueExpression singleElementExpression;
            ValueExpression expression;
            String expressionText = this.expressions[idx];
            try {
                expression = EXPRESSION_FACTORY.createValueExpression((ELContext)ctx, expressionText, Object.class);
                singleElementExpression = EXPRESSION_FACTORY.createValueExpression((ELContext)singleElementContext, expressionText, Object.class);
            }
            catch (ELException e) {
                throw new InvalidSyntaxException((Exception)((Object)e));
            }
            try {
                result = singleElementExpression.getValue((ELContext)singleElementContext);
            }
            catch (PropertyNotFoundException e) {
                result = expression.getValue((ELContext)ctx);
            }
            results[idx] = result;
        }
        try {
            return MessageFormat.format(this.template, results);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSyntaxException(e);
        }
    }

    @Generated
    public String toString() {
        return "LogMessageImpl(template=" + this.template + ", expressions=" + Arrays.deepToString(this.expressions) + ", operationCode=" + this.getOperationCode() + ", changeSpec=" + this.getChangeSpec() + ", user=" + this.getUser() + ", persistentResource=" + this.getPersistentResource() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogMessageImpl)) {
            return false;
        }
        LogMessageImpl other = (LogMessageImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOperationCode() != other.getOperationCode()) {
            return false;
        }
        String this$template = this.template;
        String other$template = other.template;
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        if (!Arrays.deepEquals(this.expressions, other.expressions)) {
            return false;
        }
        Optional<ChangeSpec> this$changeSpec = this.getChangeSpec();
        Optional<ChangeSpec> other$changeSpec = other.getChangeSpec();
        if (this$changeSpec == null ? other$changeSpec != null : !((Object)this$changeSpec).equals(other$changeSpec)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        com.yahoo.elide.core.security.PersistentResource this$persistentResource = this.getPersistentResource();
        com.yahoo.elide.core.security.PersistentResource other$persistentResource = other.getPersistentResource();
        return !(this$persistentResource == null ? other$persistentResource != null : !this$persistentResource.equals(other$persistentResource));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LogMessageImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOperationCode();
        String $template = this.template;
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.expressions);
        Optional<ChangeSpec> $changeSpec = this.getChangeSpec();
        result = result * 59 + ($changeSpec == null ? 43 : ((Object)$changeSpec).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        com.yahoo.elide.core.security.PersistentResource $persistentResource = this.getPersistentResource();
        result = result * 59 + ($persistentResource == null ? 43 : $persistentResource.hashCode());
        return result;
    }

    @Override
    @Generated
    public int getOperationCode() {
        return this.operationCode;
    }

    @Override
    @Generated
    public Optional<ChangeSpec> getChangeSpec() {
        return this.changeSpec;
    }

    @Override
    @Generated
    public User getUser() {
        return this.user;
    }

    @Override
    @Generated
    public com.yahoo.elide.core.security.PersistentResource getPersistentResource() {
        return this.persistentResource;
    }
}

