/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.audit;

import com.yahoo.elide.core.audit.LogMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AuditLogger {
    protected static final ThreadLocal<List<LogMessage>> MESSAGES = ThreadLocal.withInitial(ArrayList::new);

    public void log(LogMessage message) {
        MESSAGES.get().add(message);
    }

    public abstract void commit() throws IOException;

    public void clear() {
        List<LogMessage> remainingMessages = MESSAGES.get();
        if (remainingMessages != null) {
            remainingMessages.clear();
        }
    }
}

