/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.yahoo.elide.core.PersistentResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ResourceLineage {
    private final LinkedMap<String, List<PersistentResource>> resourceMap;
    private final List<LineagePath> resourcePath;

    public ResourceLineage() {
        this.resourceMap = new LinkedMap();
        this.resourcePath = new LinkedList<LineagePath>();
    }

    public ResourceLineage(ResourceLineage sharedLineage, PersistentResource next, String relationship) {
        this.resourceMap = new LinkedMap(sharedLineage.resourceMap);
        this.resourcePath = new LinkedList<LineagePath>(sharedLineage.resourcePath);
        this.addRecord(next, relationship);
    }

    public List<PersistentResource> getRecord(String name) {
        List list = (List)this.resourceMap.get((Object)name);
        return list == null ? Collections.emptyList() : list;
    }

    public PersistentResource getParent() {
        if (this.resourcePath.isEmpty()) {
            return null;
        }
        return this.resourcePath.get((int)(this.resourcePath.size() - 1)).resource;
    }

    public List<String> getKeys() {
        return this.resourceMap.asList();
    }

    public List<LineagePath> getResourcePath() {
        return this.resourcePath;
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 123).append(this.getKeys()).append((Object)this.resourceMap.asList()).toHashCode();
    }

    public boolean equals(Object input) {
        if (!(input instanceof ResourceLineage)) {
            return false;
        }
        ResourceLineage other = (ResourceLineage)input;
        if (other.getKeys().size() != this.getKeys().size()) {
            return false;
        }
        for (String key : other.getKeys()) {
            if (other.getRecord(key).equals(this.getRecord(key))) continue;
            return false;
        }
        return other.resourcePath.equals(this.resourcePath);
    }

    private void addRecord(PersistentResource latest, String relationship) {
        List<PersistentResource> resources;
        String alias = latest.getTypeName();
        if (this.resourceMap.containsKey((Object)alias)) {
            resources = (List)this.resourceMap.get((Object)alias);
        } else {
            resources = new ArrayList();
            this.resourceMap.put((Object)alias, resources);
        }
        resources.add(latest);
        this.resourcePath.add(new LineagePath(latest, relationship));
    }

    public static final class LineagePath {
        private final PersistentResource resource;
        private final String relationship;

        @Generated
        public LineagePath(PersistentResource resource, String relationship) {
            this.resource = resource;
            this.relationship = relationship;
        }

        @Generated
        public PersistentResource getResource() {
            return this.resource;
        }

        @Generated
        public String getRelationship() {
            return this.relationship;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LineagePath)) {
                return false;
            }
            LineagePath other = (LineagePath)o;
            PersistentResource this$resource = this.getResource();
            PersistentResource other$resource = other.getResource();
            if (this$resource == null ? other$resource != null : !((Object)this$resource).equals(other$resource)) {
                return false;
            }
            String this$relationship = this.getRelationship();
            String other$relationship = other.getRelationship();
            return !(this$relationship == null ? other$relationship != null : !this$relationship.equals(other$relationship));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PersistentResource $resource = this.getResource();
            result = result * 59 + ($resource == null ? 43 : ((Object)$resource).hashCode());
            String $relationship = this.getRelationship();
            result = result * 59 + ($relationship == null ? 43 : $relationship.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ResourceLineage.LineagePath(resource=" + this.getResource() + ", relationship=" + this.getRelationship() + ")";
        }
    }
}

