/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide;

import com.yahoo.elide.core.utils.coerce.converters.EpochToDateConverter;
import com.yahoo.elide.core.utils.coerce.converters.ISO8601DateSerde;
import com.yahoo.elide.core.utils.coerce.converters.InstantSerde;
import com.yahoo.elide.core.utils.coerce.converters.OffsetDateTimeSerde;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import com.yahoo.elide.core.utils.coerce.converters.TimeZoneSerde;
import com.yahoo.elide.core.utils.coerce.converters.URLSerde;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;

public class Serdes
extends LinkedHashMap<Class, Serde> {
    private static final long serialVersionUID = 1L;

    public static SerdesBuilder builder() {
        return new SerdesBuilder();
    }

    public SerdesBuilder mutate() {
        return (SerdesBuilder)Serdes.builder().entries(entries -> this.entrySet().stream().forEach((? super T entry) -> entries.put((Class)entry.getKey(), (Serde)entry.getValue())));
    }

    public static class SerdesBuilder
    extends SerdesBuilderSupport<SerdesBuilder> {
        public Serdes build() {
            Serdes serdes = new Serdes();
            serdes.putAll(this.entries);
            return serdes;
        }

        @Override
        public SerdesBuilder self() {
            return this;
        }
    }

    public static abstract class SerdesBuilderSupport<S> {
        protected Map<Class<?>, Serde<?, ?>> entries = new LinkedHashMap();

        public abstract S self();

        public S entries(Consumer<Map<Class<?>, Serde<?, ?>>> entries) {
            entries.accept(this.entries);
            return this.self();
        }

        public S entry(Class<?> key, Serde<?, ?> value) {
            this.entries.put(key, value);
            return this.self();
        }

        public S clear() {
            this.entries.clear();
            return this.self();
        }

        public S withISO8601Dates(String dateFormat, TimeZone tz) {
            this.entries.put(java.util.Date.class, new ISO8601DateSerde(dateFormat, tz));
            this.entries.put(Date.class, new ISO8601DateSerde(dateFormat, tz, Date.class));
            this.entries.put(Time.class, new ISO8601DateSerde(dateFormat, tz, Time.class));
            this.entries.put(Timestamp.class, new ISO8601DateSerde(dateFormat, tz, Timestamp.class));
            return this.self();
        }

        public S withEpochDates() {
            this.entries.put(java.util.Date.class, new EpochToDateConverter<java.util.Date>(java.util.Date.class));
            this.entries.put(Date.class, new EpochToDateConverter<Date>(Date.class));
            this.entries.put(Time.class, new EpochToDateConverter<Time>(Time.class));
            this.entries.put(Timestamp.class, new EpochToDateConverter<Timestamp>(Timestamp.class));
            return this.self();
        }

        public S withDefaults() {
            this.entries.put(Instant.class, new InstantSerde());
            this.entries.put(OffsetDateTime.class, new OffsetDateTimeSerde());
            this.entries.put(TimeZone.class, new TimeZoneSerde());
            this.entries.put(URL.class, new URLSerde());
            return this.self();
        }
    }
}

