/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide;

import com.yahoo.elide.ElideErrors;
import com.yahoo.elide.ElideResponse;
import java.util.function.Consumer;

public class ElideErrorResponse<T>
extends ElideResponse<T> {
    public ElideErrorResponse(int status, T body) {
        super(status, body);
    }

    public static ElideErrorResponseBuilder status(int status) {
        return new ElideErrorResponseBuilder(status);
    }

    public static ElideErrorResponseBuilder ok() {
        return ElideErrorResponse.status(200);
    }

    public static <T> ElideErrorResponse<T> ok(T body) {
        return ElideErrorResponse.ok().body((Object)body);
    }

    public static ElideErrorResponseBuilder badRequest() {
        return ElideErrorResponse.status(400);
    }

    public static <T> ElideErrorResponse<T> badRequest(T body) {
        return ElideErrorResponse.badRequest().body((Object)body);
    }

    public static class ElideErrorResponseBuilder
    extends ElideResponse.ElideResponseBuilder {
        public ElideErrorResponseBuilder(int status) {
            super(status);
        }

        public <T> ElideErrorResponse<T> body(T body) {
            return new ElideErrorResponse<T>(this.status, body);
        }

        public <T> ElideErrorResponse<T> build() {
            return new ElideErrorResponse<Object>(this.status, null);
        }

        public ElideErrorResponse<ElideErrors> errors(Consumer<ElideErrors.ElideErrorsBuilder> errors) {
            ElideErrors.ElideErrorsBuilder builder = ElideErrors.builder();
            errors.accept(builder);
            return this.body(builder.build());
        }
    }
}

