/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.utils;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.stream.Collectors;

public class ClassScanner {
    public static Set<Class<?>> getAnnotatedClasses(Package toScan, Class<? extends Annotation> annotation) {
        return ClassScanner.getAnnotatedClasses(toScan.getName(), annotation);
    }

    public static Set<Class<?>> getAnnotatedClasses(String packageName, Class<? extends Annotation> annotation) {
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().whitelistPackages(new String[]{packageName}).scan();){
            Set<Class<?>> set = scanResult.getClassesWithAnnotation(annotation.getCanonicalName()).stream().map(ClassInfo::loadClass).collect(Collectors.toSet());
            return set;
        }
    }

    public static Set<Class<?>> getAnnotatedClasses(Class<? extends Annotation> annotation) {
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().scan();){
            Set<Class<?>> set = scanResult.getClassesWithAnnotation(annotation.getCanonicalName()).stream().map(ClassInfo::loadClass).collect(Collectors.toSet());
            return set;
        }
    }

    public static Set<Class<?>> getAllClasses(String packageName) {
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().whitelistPackages(new String[]{packageName}).scan();){
            Set<Class<?>> set = scanResult.getAllClasses().stream().map(ClassInfo::loadClass).collect(Collectors.toSet());
            return set;
        }
    }
}

