/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.security.permissions.expressions;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.security.ChangeSpec;
import com.yahoo.elide.security.PersistentResource;
import com.yahoo.elide.security.RequestScope;
import com.yahoo.elide.security.checks.Check;
import com.yahoo.elide.security.checks.InlineCheck;
import com.yahoo.elide.security.checks.UserCheck;
import com.yahoo.elide.security.permissions.ExpressionResult;
import com.yahoo.elide.security.permissions.ExpressionResultCache;
import com.yahoo.elide.security.permissions.expressions.Expression;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckExpression
implements Expression {
    private static final Logger log = LoggerFactory.getLogger(CheckExpression.class);
    protected final Check check;
    protected final PersistentResource resource;
    protected final RequestScope requestScope;
    protected final ExpressionResultCache cache;
    protected ExpressionResult result;
    private final Optional<ChangeSpec> changeSpec;

    public CheckExpression(Check check, PersistentResource resource, RequestScope requestScope, ChangeSpec changeSpec, ExpressionResultCache cache) {
        this.check = check;
        this.requestScope = requestScope;
        this.changeSpec = Optional.ofNullable(changeSpec);
        this.cache = cache;
        this.result = ExpressionResult.UNEVALUATED;
        this.resource = check instanceof UserCheck ? null : resource;
    }

    @Override
    public ExpressionResult evaluate(Expression.EvaluationMode mode) {
        log.trace("Evaluating check: {} in mode {}", (Object)this.check, (Object)mode);
        if (this.result == ExpressionResult.PASS || this.result == ExpressionResult.FAIL) {
            return this.result;
        }
        if (mode == Expression.EvaluationMode.USER_CHECKS_ONLY && !(this.check instanceof UserCheck)) {
            this.result = ExpressionResult.DEFERRED;
            return this.result;
        }
        if (mode == Expression.EvaluationMode.INLINE_CHECKS_ONLY && !(this.check instanceof InlineCheck)) {
            this.result = ExpressionResult.DEFERRED;
            return this.result;
        }
        if (this.changeSpec.isPresent()) {
            log.trace("-- Check has changespec: {}", this.changeSpec);
            this.result = this.computeCheck();
            log.trace("-- Check returned with result: {}", (Object)this.result);
            return this.result;
        }
        log.trace("-- Check does NOT have changespec");
        Class<?> checkClass = this.check.getClass();
        if (this.cache.hasStoredResultFor(checkClass, this.resource)) {
            this.result = this.cache.getResultFor(checkClass, this.resource);
        } else {
            this.result = this.computeCheck();
            this.cache.putResultFor(checkClass, this.resource, this.result);
            log.trace("-- Check computed result: {}", (Object)this.result);
        }
        log.trace("-- Check returned with result: {}", (Object)this.result);
        return this.result;
    }

    private ExpressionResult computeCheck() {
        Object entity = this.resource == null ? null : this.resource.getObject();
        this.result = this.check.ok(entity, this.requestScope, this.changeSpec) ? ExpressionResult.PASS : ExpressionResult.FAIL;
        return this.result;
    }

    public String toString() {
        EntityDictionary dictionary = ((com.yahoo.elide.core.RequestScope)this.requestScope).getDictionary();
        return String.format("(%s %s)", new Object[]{dictionary.getCheckIdentifier(this.check.getClass()), this.result});
    }
}

