/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.security.permissions.expressions;

import com.yahoo.elide.security.permissions.ExpressionResult;
import com.yahoo.elide.security.permissions.PermissionCondition;
import com.yahoo.elide.security.permissions.expressions.Expression;
import com.yahoo.elide.security.permissions.expressions.OrExpression;

public class AnyFieldExpression
implements Expression {
    private final Expression entityExpression;
    private final Expression fieldExpression;
    private final PermissionCondition condition;

    public AnyFieldExpression(PermissionCondition condition, Expression entityExpression, OrExpression fieldExpression) {
        this.condition = condition;
        this.entityExpression = entityExpression;
        this.fieldExpression = fieldExpression;
    }

    @Override
    public ExpressionResult evaluate(Expression.EvaluationMode mode) {
        ExpressionResult fieldResult = this.fieldExpression.evaluate(mode);
        if (fieldResult != ExpressionResult.FAIL) {
            return fieldResult;
        }
        ExpressionResult entityResult = this.entityExpression == null ? ExpressionResult.PASS : this.entityExpression.evaluate(mode);
        return entityResult;
    }

    public String toString() {
        return String.format("%s FOR EXPRESSION [(FIELDS(%s)) OR (ENTITY(%s))]", this.condition, this.fieldExpression, this.entityExpression);
    }
}

