/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.security.permissions;

import com.google.common.collect.ImmutableMap;
import com.yahoo.elide.annotation.CreatePermission;
import com.yahoo.elide.annotation.DeletePermission;
import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.annotation.SharePermission;
import com.yahoo.elide.annotation.UpdatePermission;
import com.yahoo.elide.security.ChangeSpec;
import com.yahoo.elide.security.PersistentResource;
import java.lang.annotation.Annotation;
import java.util.Optional;

public class PermissionCondition {
    final Class<? extends Annotation> permission;
    final Class<?> entityClass;
    final Optional<PersistentResource> resource;
    final Optional<ChangeSpec> changes;
    final Optional<String> field;
    private static final ImmutableMap<Class<? extends Annotation>, String> PERMISSION_TO_NAME = ImmutableMap.builder().put(ReadPermission.class, (Object)"READ").put(UpdatePermission.class, (Object)"UPDATE").put(DeletePermission.class, (Object)"DELETE").put(CreatePermission.class, (Object)"CREATE").put(SharePermission.class, (Object)"SHARE").build();

    public static PermissionCondition create(Class<? extends Annotation> permission, PersistentResource resource, String field, ChangeSpec changes) {
        if (resource != null) {
            if (changes != null) {
                if (field != null && changes.getFieldName() == null) {
                    return new PermissionCondition(permission, resource, field);
                }
                return new PermissionCondition(permission, resource, changes);
            }
            if (field == null) {
                return new PermissionCondition(permission, resource);
            }
            return new PermissionCondition(permission, resource, field);
        }
        throw new IllegalArgumentException("Resource cannot be null");
    }

    PermissionCondition(Class<? extends Annotation> permission, PersistentResource resource) {
        this.permission = permission;
        this.resource = Optional.of(resource);
        this.entityClass = resource.getResourceClass();
        this.changes = Optional.empty();
        this.field = Optional.empty();
    }

    PermissionCondition(Class<? extends Annotation> permission, PersistentResource resource, ChangeSpec changes) {
        this.permission = permission;
        this.resource = Optional.of(resource);
        this.entityClass = resource.getResourceClass();
        this.changes = Optional.of(changes);
        this.field = Optional.ofNullable(changes.getFieldName());
    }

    PermissionCondition(Class<? extends Annotation> permission, Class<?> entityClass) {
        this.permission = permission;
        this.resource = Optional.empty();
        this.entityClass = entityClass;
        this.changes = Optional.empty();
        this.field = Optional.empty();
    }

    PermissionCondition(Class<? extends Annotation> permission, PersistentResource resource, String field) {
        this.permission = permission;
        this.resource = Optional.of(resource);
        this.entityClass = resource.getResourceClass();
        this.changes = Optional.empty();
        this.field = Optional.of(field);
    }

    public String toString() {
        PersistentResource entity = this.resource.isPresent() ? this.resource.get() : this.entityClass;
        String withChanges = this.changes.isPresent() ? String.format("WITH CHANGES %s", this.changes.get()) : "";
        String withField = this.field.isPresent() ? String.format("WITH FIELD %s", this.field.get()) : "";
        String withClause = withChanges.isEmpty() ? withField : withChanges;
        return String.format("%s PERMISSION WAS INVOKED ON %s %s", PERMISSION_TO_NAME.get(this.permission), entity, withClause);
    }

    public Class<? extends Annotation> getPermission() {
        return this.permission;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public Optional<PersistentResource> getResource() {
        return this.resource;
    }

    public Optional<ChangeSpec> getChanges() {
        return this.changes;
    }

    public Optional<String> getField() {
        return this.field;
    }
}

