/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.parsers.expression;

import com.yahoo.elide.core.CheckInstantiator;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.generated.parsers.ExpressionBaseVisitor;
import com.yahoo.elide.generated.parsers.ExpressionParser;
import com.yahoo.elide.security.checks.Check;
import com.yahoo.elide.security.permissions.expressions.AndExpression;
import com.yahoo.elide.security.permissions.expressions.Expression;
import com.yahoo.elide.security.permissions.expressions.NotExpression;
import com.yahoo.elide.security.permissions.expressions.OrExpression;
import java.util.function.Function;
import org.antlr.v4.runtime.tree.ParseTree;

public class PermissionExpressionVisitor
extends ExpressionBaseVisitor<Expression>
implements CheckInstantiator {
    private final EntityDictionary dictionary;
    private final Function<Check, Expression> expressionGenerator;

    public PermissionExpressionVisitor(EntityDictionary dictionary, Function<Check, Expression> expressionGenerator) {
        this.dictionary = dictionary;
        this.expressionGenerator = expressionGenerator;
    }

    @Override
    public Expression visitNOT(ExpressionParser.NOTContext ctx) {
        return new NotExpression((Expression)this.visit((ParseTree)ctx.expression()));
    }

    @Override
    public Expression visitOR(ExpressionParser.ORContext ctx) {
        return new OrExpression((Expression)this.visit((ParseTree)ctx.left), (Expression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public Expression visitAND(ExpressionParser.ANDContext ctx) {
        Expression left = (Expression)this.visit((ParseTree)ctx.left);
        Expression right = (Expression)this.visit((ParseTree)ctx.right);
        return new AndExpression(left, right);
    }

    @Override
    public Expression visitPAREN(ExpressionParser.PARENContext ctx) {
        return (Expression)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public Expression visitPermissionClass(ExpressionParser.PermissionClassContext ctx) {
        Check check = this.getCheck(this.dictionary, ctx.getText());
        return this.expressionGenerator.apply(check);
    }
}

