/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.Resource;
import java.io.IOException;
import java.util.ArrayList;

public class DataDeserializer
extends JsonDeserializer<Data<Resource>> {
    private static final ObjectMapper MAPPER = new MappingJsonFactory().getCodec();

    public Data<Resource> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (node.isArray()) {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (JsonNode n : node) {
                Resource r = (Resource)MAPPER.convertValue((Object)n, Resource.class);
                resources.add(r);
            }
            return new Data<Resource>(resources);
        }
        Resource resource = (Resource)MAPPER.convertValue((Object)node, Resource.class);
        return new Data<Resource>(resource);
    }
}

