/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.models;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.InvalidObjectIdentifierException;
import com.yahoo.elide.core.exceptions.UnknownEntityException;
import com.yahoo.elide.jsonapi.models.Meta;
import com.yahoo.elide.jsonapi.models.Relationship;
import com.yahoo.elide.jsonapi.models.ResourceIdentifier;
import com.yahoo.elide.jsonapi.serialization.KeySerializer;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Resource {
    private String type;
    private String id;
    private Map<String, Object> attributes;
    private Map<String, Relationship> relationships;
    private Map<String, String> links;
    private Map<String, Meta> meta;

    public Resource(String type, String id) {
        this.type = type;
        this.id = id;
        if (id == null) {
            throw new InvalidObjectIdentifierException(id, type);
        }
    }

    public Resource(@JsonProperty(value="type") String type, @JsonProperty(value="id") String id, @JsonProperty(value="attributes") Map<String, Object> attributes, @JsonProperty(value="relationships") Map<String, Relationship> relationships, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="meta") Map<String, Meta> meta) {
        this.type = type;
        this.id = id;
        this.attributes = attributes;
        this.relationships = relationships;
        this.links = links;
        this.meta = meta;
    }

    public String getId() {
        return this.id;
    }

    public void setRelationships(Map<String, Relationship> relationships) {
        this.relationships = relationships;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, Relationship> getRelationships() {
        return MapUtils.isEmpty(this.relationships) ? null : this.relationships;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(keyUsing=KeySerializer.class)
    public Map<String, Object> getAttributes() {
        return MapUtils.isEmpty(this.attributes) ? null : this.attributes;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAttributes(Map<String, Object> obj) {
        this.attributes = obj;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, Meta> getMeta() {
        return this.meta;
    }

    public void setMeta(Map<String, Meta> meta) {
        this.meta = meta;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, String> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, String> links) {
        this.links = links;
    }

    public ResourceIdentifier toResourceIdentifier() {
        return new ResourceIdentifier(this.type, this.id);
    }

    public int hashCode() {
        return new HashCodeBuilder(37, 17).append((Object)this.type).append((Object)this.id).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Resource) {
            Resource that = (Resource)obj;
            return Objects.equals(this.id, that.id) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.type, that.type) && Objects.equals(this.relationships, that.relationships);
        }
        return false;
    }

    public PersistentResource<?> toPersistentResource(RequestScope requestScope) throws ForbiddenAccessException, InvalidObjectIdentifierException {
        Class<?> cls = requestScope.getDictionary().getEntityClass(this.type);
        if (cls == null) {
            throw new UnknownEntityException(this.type);
        }
        if (this.id == null) {
            throw new InvalidObjectIdentifierException(this.id, this.type);
        }
        return PersistentResource.loadRecord(cls, this.id, requestScope);
    }

    public String toString() {
        return "Resource(type=" + this.getType() + ", id=" + this.getId() + ", attributes=" + this.getAttributes() + ", relationships=" + this.getRelationships() + ", links=" + this.getLinks() + ", meta=" + this.getMeta() + ")";
    }
}

