/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter.expression;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.parsers.expression.FilterExpressionNormalizationVisitor;

public class FilterPredicatePushdownExtractor
implements FilterExpressionVisitor<FilterExpression> {
    private EntityDictionary dictionary;

    public FilterPredicatePushdownExtractor(EntityDictionary dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    public FilterExpression visitPredicate(FilterPredicate filterPredicate) {
        boolean filterInMemory = false;
        for (Path.PathElement pathElement : filterPredicate.getPath().getPathElements()) {
            String fieldName;
            Class entityClass = pathElement.getType();
            if (!this.dictionary.isComputed(entityClass, fieldName = pathElement.getFieldName())) continue;
            filterInMemory = true;
        }
        return filterInMemory ? null : filterPredicate;
    }

    @Override
    public FilterExpression visitAndExpression(AndFilterExpression expression) {
        FilterExpression left = expression.getLeft().accept(this);
        FilterExpression right = expression.getRight().accept(this);
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return expression;
    }

    @Override
    public FilterExpression visitOrExpression(OrFilterExpression expression) {
        FilterExpression left = expression.getLeft().accept(this);
        FilterExpression right = expression.getRight().accept(this);
        if (left == null || right == null) {
            return null;
        }
        return expression;
    }

    @Override
    public FilterExpression visitNotExpression(NotFilterExpression expression) {
        FilterExpression inner = expression.getNegated().accept(this);
        if (inner == null) {
            return null;
        }
        return expression;
    }

    public static FilterExpression extractPushDownPredicate(EntityDictionary dictionary, FilterExpression expression) {
        FilterExpressionNormalizationVisitor normalizationVisitor = new FilterExpressionNormalizationVisitor();
        FilterExpression normalizedExpression = expression.accept(normalizationVisitor);
        FilterPredicatePushdownExtractor verifier = new FilterPredicatePushdownExtractor(dictionary);
        return normalizedExpression.accept(verifier);
    }
}

