/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter.dialect;

import com.yahoo.elide.core.filter.Operator;

public interface CaseSensitivityStrategy {
    public Operator mapOperator(Operator var1);

    public static class UseColumnCollation
    implements CaseSensitivityStrategy {
        @Override
        public Operator mapOperator(Operator operator) {
            return operator;
        }
    }

    public static class FIQLCompliant
    implements CaseSensitivityStrategy {
        @Override
        public Operator mapOperator(Operator operator) {
            switch (operator) {
                case IN: {
                    return Operator.IN_INSENSITIVE;
                }
                case NOT: {
                    return Operator.NOT_INSENSITIVE;
                }
                case INFIX: {
                    return Operator.INFIX_CASE_INSENSITIVE;
                }
                case PREFIX: {
                    return Operator.PREFIX_CASE_INSENSITIVE;
                }
                case POSTFIX: {
                    return Operator.POSTFIX_CASE_INSENSITIVE;
                }
            }
            return operator;
        }
    }
}

