/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter;

import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.InvalidOperatorNegationException;
import com.yahoo.elide.core.exceptions.InvalidPredicateException;
import com.yahoo.elide.utils.coerce.CoerceUtil;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public enum Operator {
    IN("in", true){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return Operator.in(field, values, requestScope);
        }
    }
    ,
    IN_INSENSITIVE("ini", true){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return Operator.in(field, values, requestScope, 2.FOLD_CASE);
        }
    }
    ,
    NOT("not", true){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return entity -> !Operator.in(field, values, requestScope).test(entity);
        }
    }
    ,
    NOT_INSENSITIVE("noti", true){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return entity -> !Operator.in(field, values, requestScope, 4.FOLD_CASE).test(entity);
        }
    }
    ,
    PREFIX_CASE_INSENSITIVE("prefixi", true){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return Operator.prefix(field, values, requestScope, s -> s.toLowerCase(Locale.ENGLISH));
        }
    }
    ,
    PREFIX("prefix", true){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return Operator.prefix(field, values, requestScope, Function.identity());
        }
    }
    ,
    POSTFIX("postfix", true){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return Operator.postfix(field, values, requestScope, Function.identity());
        }
    }
    ,
    POSTFIX_CASE_INSENSITIVE("postfixi", true){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return Operator.postfix(field, values, requestScope, 8.FOLD_CASE);
        }
    }
    ,
    INFIX("infix", true){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return Operator.infix(field, values, requestScope, Function.identity());
        }
    }
    ,
    INFIX_CASE_INSENSITIVE("infixi", true){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return Operator.infix(field, values, requestScope, 10.FOLD_CASE);
        }
    }
    ,
    ISNULL("isnull", false){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return Operator.isNull(field, requestScope);
        }
    }
    ,
    NOTNULL("notnull", false){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return val -> !Operator.isNull(field, requestScope).test(val);
        }
    }
    ,
    LT("lt", true){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return Operator.lt(field, values, requestScope);
        }
    }
    ,
    LE("le", true){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return Operator.le(field, values, requestScope);
        }
    }
    ,
    GT("gt", true){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return Operator.gt(field, values, requestScope);
        }
    }
    ,
    GE("ge", true){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return Operator.ge(field, values, requestScope);
        }
    }
    ,
    TRUE("true", false){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return Operator.isTrue();
        }
    }
    ,
    FALSE("false", false){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return Operator.isFalse();
        }
    }
    ,
    ISEMPTY("isempty", false){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return Operator.isEmpty(field, requestScope);
        }
    }
    ,
    NOTEMPTY("notempty", false){

        @Override
        public <T> Predicate<T> contextualize(String field, List<Object> values, RequestScope requestScope) {
            return entity -> !Operator.isEmpty(field, requestScope).test(entity);
        }
    };

    public static final Function<String, String> FOLD_CASE;
    private final String notation;
    private final boolean parameterized;
    private Operator negated;

    public static Operator fromString(String string) {
        for (Operator operator : Operator.values()) {
            if (!operator.getNotation().equals(string)) continue;
            return operator;
        }
        throw new InvalidPredicateException("Unknown operator in filter: " + string);
    }

    public abstract <T> Predicate<T> contextualize(String var1, List<Object> var2, RequestScope var3);

    private static <T> Predicate<T> in(String field, List<Object> values, RequestScope requestScope) {
        return entity -> {
            Object val = Operator.getFieldValue(entity, field, requestScope);
            if (val == null) return false;
            if (!values.stream().map(v -> CoerceUtil.coerce(v, val.getClass())).anyMatch(val::equals)) return false;
            return true;
        };
    }

    private static <T> Predicate<T> in(String field, List<Object> values, RequestScope requestScope, Function<String, String> transform) {
        return entity -> {
            Object fieldValue = Operator.getFieldValue(entity, field, requestScope);
            if (fieldValue == null) {
                return false;
            }
            if (!fieldValue.getClass().isAssignableFrom(String.class)) {
                throw new IllegalStateException("Cannot case insensitive compare non-string values");
            }
            String val = (String)transform.apply((String)fieldValue);
            if (val == null) return false;
            if (!values.stream().map(v -> (String)transform.apply(CoerceUtil.coerce(v, String.class))).anyMatch(val::equals)) return false;
            return true;
        };
    }

    private static <T> Predicate<T> prefix(String field, List<Object> values, RequestScope requestScope, Function<String, String> transform) {
        return entity -> {
            if (values.size() != 1) {
                throw new InvalidPredicateException("PREFIX can only take one argument");
            }
            Object val = Operator.getFieldValue(entity, field, requestScope);
            String valStr = CoerceUtil.coerce(val, String.class);
            String filterStr = CoerceUtil.coerce(values.get(0), String.class);
            return valStr != null && filterStr != null && ((String)transform.apply(valStr)).startsWith((String)transform.apply(filterStr));
        };
    }

    private static <T> Predicate<T> postfix(String field, List<Object> values, RequestScope requestScope, Function<String, String> transform) {
        return entity -> {
            if (values.size() != 1) {
                throw new InvalidPredicateException("POSTFIX can only take one argument");
            }
            Object val = Operator.getFieldValue(entity, field, requestScope);
            String valStr = CoerceUtil.coerce(val, String.class);
            String filterStr = CoerceUtil.coerce(values.get(0), String.class);
            return valStr != null && filterStr != null && ((String)transform.apply(valStr)).endsWith((String)transform.apply(filterStr));
        };
    }

    private static <T> Predicate<T> infix(String field, List<Object> values, RequestScope requestScope, Function<String, String> transform) {
        return entity -> {
            if (values.size() != 1) {
                throw new InvalidPredicateException("INFIX can only take one argument");
            }
            Object val = Operator.getFieldValue(entity, field, requestScope);
            String valStr = CoerceUtil.coerce(val, String.class);
            String filterStr = CoerceUtil.coerce(values.get(0), String.class);
            return valStr != null && filterStr != null && ((String)transform.apply(valStr)).contains((CharSequence)transform.apply(filterStr));
        };
    }

    private static <T> Predicate<T> isNull(String field, RequestScope requestScope) {
        return entity -> Operator.getFieldValue(entity, field, requestScope) == null;
    }

    private static <T> Predicate<T> lt(String field, List<Object> values, RequestScope requestScope) {
        return Operator.getComparator(field, values, requestScope, compareResult -> compareResult < 0);
    }

    private static <T> Predicate<T> le(String field, List<Object> values, RequestScope requestScope) {
        return Operator.getComparator(field, values, requestScope, compareResult -> compareResult <= 0);
    }

    private static <T> Predicate<T> gt(String field, List<Object> values, RequestScope requestScope) {
        return Operator.getComparator(field, values, requestScope, compareResult -> compareResult > 0);
    }

    private static <T> Predicate<T> ge(String field, List<Object> values, RequestScope requestScope) {
        return Operator.getComparator(field, values, requestScope, compareResult -> compareResult >= 0);
    }

    private static <T> Predicate<T> isTrue() {
        return entity -> true;
    }

    private static <T> Predicate<T> isFalse() {
        return entity -> false;
    }

    private static <T> Predicate<T> isEmpty(String field, RequestScope requestScope) {
        return entity -> {
            Object val = Operator.getFieldValue(entity, field, requestScope);
            if (val == null) {
                return false;
            }
            if (val instanceof Collection) {
                return ((Collection)val).isEmpty();
            }
            if (val instanceof Map) {
                return ((Map)val).isEmpty();
            }
            return false;
        };
    }

    private static <T> Object getFieldValue(T entity, String fieldPath, RequestScope requestScope) {
        Object val = entity;
        for (String field : fieldPath.split("\\.")) {
            if ("this".equals(field)) continue;
            if (val == null) break;
            val = PersistentResource.getValue(val, field, requestScope);
        }
        return val;
    }

    private static <T> Predicate<T> getComparator(String field, List<Object> values, RequestScope requestScope, Predicate<Integer> condition) {
        return entity -> {
            if (values.size() == 0) {
                throw new InvalidPredicateException("No value to compare");
            }
            Object fieldVal = Operator.getFieldValue(entity, field, requestScope);
            return fieldVal != null && values.stream().anyMatch(testVal -> condition.test(Operator.compare(fieldVal, testVal)));
        };
    }

    private static int compare(Object fieldValue, Object rawTestValue) {
        Object testValue = CoerceUtil.coerce(rawTestValue, fieldValue.getClass());
        Comparable testComp = CoerceUtil.coerce(testValue, Comparable.class);
        Comparable fieldComp = CoerceUtil.coerce(fieldValue, Comparable.class);
        return fieldComp.compareTo(testComp);
    }

    public Operator negate() {
        if (this.negated == null) {
            throw new InvalidOperatorNegationException();
        }
        return this.negated;
    }

    private Operator(String notation, boolean parameterized) {
        this.notation = notation;
        this.parameterized = parameterized;
    }

    public String getNotation() {
        return this.notation;
    }

    public boolean isParameterized() {
        return this.parameterized;
    }

    static {
        FOLD_CASE = s -> s.toLowerCase(Locale.ENGLISH);
        Operator.GE.negated = LT;
        Operator.GT.negated = LE;
        Operator.LE.negated = GT;
        Operator.LT.negated = GE;
        Operator.IN.negated = NOT;
        Operator.IN_INSENSITIVE.negated = NOT_INSENSITIVE;
        Operator.NOT.negated = IN;
        Operator.NOT_INSENSITIVE.negated = IN_INSENSITIVE;
        Operator.TRUE.negated = FALSE;
        Operator.FALSE.negated = TRUE;
        Operator.ISNULL.negated = NOTNULL;
        Operator.NOTNULL.negated = ISNULL;
        Operator.ISEMPTY.negated = NOTEMPTY;
        Operator.NOTEMPTY.negated = ISEMPTY;
    }
}

