/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.RelationshipType;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class FilterPredicate
implements FilterExpression,
Function<RequestScope, Predicate> {
    private static final String UNDERSCORE = "_";
    private static final String PERIOD = ".";
    private static final Path.PathElement[] ELEMENT_ARRAY = new Path.PathElement[0];
    @NonNull
    private Path path;
    @NonNull
    private Operator operator;
    @NonNull
    private List<Object> values;
    @NonNull
    private String field;
    @NonNull
    private String fieldPath;

    public static boolean toManyInPath(EntityDictionary dictionary, Path path) {
        return path.getPathElements().stream().map(element -> dictionary.getRelationshipType(element.getType(), element.getFieldName())).anyMatch(RelationshipType::isToMany);
    }

    public static boolean toManyInPathExceptLastPathElement(EntityDictionary dictionary, Path path) {
        int pathLength = path.getPathElements().size();
        return path.getPathElements().stream().limit(pathLength - 1).map(element -> dictionary.getRelationshipType(element.getType(), element.getFieldName())).anyMatch(RelationshipType::isToMany);
    }

    public FilterPredicate(Path.PathElement pathElement, Operator op, List<Object> values) {
        this(new Path(Collections.singletonList(pathElement)), op, values);
    }

    public FilterPredicate(FilterPredicate copy) {
        this(copy.path, copy.operator, copy.values);
    }

    public FilterPredicate(Path path, Operator op, List<Object> values) {
        this.operator = op;
        this.path = new Path(path);
        this.values = ImmutableList.copyOf(values);
        this.field = path.lastElement().map(Path.PathElement::getFieldName).orElse(null);
        this.fieldPath = path.getPathElements().stream().map(Path.PathElement::getFieldName).collect(Collectors.joining(PERIOD));
    }

    public List<FilterParameter> getParameters() {
        String baseName = String.format("%s_%s_", this.getFieldPath().replace(PERIOD, UNDERSCORE), Integer.toHexString(this.hashCode()));
        return IntStream.range(0, this.values.size()).mapToObj(idx -> new FilterParameter(String.format("%s%d", baseName, idx), this.values.get(idx))).collect(Collectors.toList());
    }

    public FilterPredicate scopedBy(Path.PathElement scope) {
        List pathElements = Lists.asList((Object)scope, (Object[])this.path.getPathElements().toArray(ELEMENT_ARRAY));
        return new FilterPredicate(new Path(pathElements), this.operator, this.values);
    }

    public String getAlias() {
        List<Path.PathElement> elements = this.path.getPathElements();
        Path.PathElement last = elements.get(elements.size() - 1);
        if (elements.size() == 1) {
            return FilterPredicate.getTypeAlias(last.getType());
        }
        Path.PathElement previous = elements.get(elements.size() - 2);
        return FilterPredicate.getTypeAlias(previous.getType()) + UNDERSCORE + previous.getFieldName();
    }

    public static String getTypeAlias(Class<?> type) {
        return type.getCanonicalName().replace(PERIOD, UNDERSCORE);
    }

    public Class getEntityType() {
        List<Path.PathElement> elements = this.path.getPathElements();
        Path.PathElement first = elements.get(0);
        return first.getType();
    }

    @Override
    public <T> T accept(FilterExpressionVisitor<T> visitor) {
        return visitor.visitPredicate(this);
    }

    @Override
    public Predicate apply(RequestScope dictionary) {
        return this.operator.contextualize(this.getFieldPath(), this.values, dictionary);
    }

    public boolean isMatchingOperator() {
        return this.operator == Operator.INFIX || this.operator == Operator.INFIX_CASE_INSENSITIVE || this.operator == Operator.PREFIX || this.operator == Operator.PREFIX_CASE_INSENSITIVE || this.operator == Operator.POSTFIX || this.operator == Operator.POSTFIX_CASE_INSENSITIVE;
    }

    public String toString() {
        List<Path.PathElement> elements = this.path.getPathElements();
        StringBuilder formattedPath = new StringBuilder();
        if (!elements.isEmpty()) {
            formattedPath.append(StringUtils.uncapitalize((String)EntityDictionary.getSimpleName(elements.get(0).getType())));
        }
        for (Path.PathElement element : elements) {
            formattedPath.append(PERIOD).append(element.getFieldName());
        }
        return formattedPath.append(' ').append((Object)this.operator).append(' ').append(this.values).toString();
    }

    public FilterPredicate negate() {
        Operator newOp = this.operator.negate();
        return new FilterPredicate(this.path, newOp, this.values);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterPredicate)) {
            return false;
        }
        FilterPredicate other = (FilterPredicate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Path this$path = this.getPath();
        Path other$path = other.getPath();
        if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
            return false;
        }
        Operator this$operator = this.getOperator();
        Operator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
            return false;
        }
        List<Object> this$values = this.getValues();
        List<Object> other$values = other.getValues();
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$fieldPath = this.getFieldPath();
        String other$fieldPath = other.getFieldPath();
        return !(this$fieldPath == null ? other$fieldPath != null : !this$fieldPath.equals(other$fieldPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FilterPredicate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        Operator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
        List<Object> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $fieldPath = this.getFieldPath();
        result = result * 59 + ($fieldPath == null ? 43 : $fieldPath.hashCode());
        return result;
    }

    @NonNull
    public Path getPath() {
        return this.path;
    }

    @NonNull
    public Operator getOperator() {
        return this.operator;
    }

    @NonNull
    public List<Object> getValues() {
        return this.values;
    }

    @NonNull
    public String getField() {
        return this.field;
    }

    @NonNull
    public String getFieldPath() {
        return this.fieldPath;
    }

    public static class FilterParameter {
        private String name;
        private Object value;

        public String getPlaceholder() {
            return ":" + this.name;
        }

        public String escapeMatching() {
            return this.value.toString().replace("%", "\\%");
        }

        public FilterParameter(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

