/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.PersistentResourceSet;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VerifyFieldAccessFilterExpressionVisitor
implements FilterExpressionVisitor<Boolean> {
    private PersistentResource<?> resource;

    public VerifyFieldAccessFilterExpressionVisitor(PersistentResource<?> resource) {
        this.resource = resource;
    }

    @Override
    public Boolean visitPredicate(FilterPredicate filterPredicate) {
        RequestScope requestScope = this.resource.getRequestScope();
        Set<PersistentResource<Object>> val = Collections.singleton(this.resource);
        for (Path.PathElement pathElement : filterPredicate.getPath().getPathElements()) {
            String fieldName = pathElement.getFieldName();
            if ("this".equals(fieldName)) continue;
            try {
                val = val.stream().filter(Objects::nonNull).flatMap(x -> this.getValueChecked((PersistentResource<?>)x, fieldName, requestScope)).filter(Objects::nonNull).collect(Collectors.toSet());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (ForbiddenAccessException e) {
                return false;
            }
        }
        return true;
    }

    private Stream<PersistentResource> getValueChecked(PersistentResource<?> resource, String fieldName, RequestScope requestScope) {
        PersistentResourceSet<Object> persistentResourceSet;
        requestScope.getPermissionExecutor().checkSpecificFieldPermissions(resource, null, ReadPermission.class, fieldName);
        Object obj = PersistentResource.getValue(resource.getObject(), fieldName, requestScope);
        if (obj instanceof Iterable) {
            persistentResourceSet = new PersistentResourceSet(resource, (Iterable)obj, requestScope);
        } else if (obj != null) {
            persistentResourceSet = new PersistentResourceSet<Object>(resource, Collections.singleton(obj), requestScope);
        } else {
            return Stream.empty();
        }
        return persistentResourceSet.stream();
    }

    @Override
    public Boolean visitAndExpression(AndFilterExpression expression) {
        FilterExpression left = expression.getLeft();
        FilterExpression right = expression.getRight();
        return left.accept(this) != false && right.accept(this) != false;
    }

    @Override
    public Boolean visitOrExpression(OrFilterExpression expression) {
        FilterExpression left = expression.getLeft();
        FilterExpression right = expression.getRight();
        return left.accept(this) != false && right.accept(this) != false;
    }

    @Override
    public Boolean visitNotExpression(NotFilterExpression expression) {
        return expression.getNegated().accept(this);
    }
}

