/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.annotation.OnCreatePostCommit;
import com.yahoo.elide.annotation.OnCreatePreCommit;
import com.yahoo.elide.annotation.OnCreatePreSecurity;
import com.yahoo.elide.annotation.OnDeletePostCommit;
import com.yahoo.elide.annotation.OnDeletePreCommit;
import com.yahoo.elide.annotation.OnDeletePreSecurity;
import com.yahoo.elide.annotation.OnReadPostCommit;
import com.yahoo.elide.annotation.OnReadPreCommit;
import com.yahoo.elide.annotation.OnReadPreSecurity;
import com.yahoo.elide.annotation.OnUpdatePostCommit;
import com.yahoo.elide.annotation.OnUpdatePreCommit;
import com.yahoo.elide.annotation.OnUpdatePreSecurity;
import com.yahoo.elide.audit.AuditLogger;
import com.yahoo.elide.core.CRUDEvent;
import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.LifecycleHookInvoker;
import com.yahoo.elide.core.ObjectEntityCache;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.exceptions.InvalidAttributeException;
import com.yahoo.elide.core.exceptions.InvalidOperationException;
import com.yahoo.elide.core.exceptions.InvalidPredicateException;
import com.yahoo.elide.core.filter.dialect.MultipleFilterDialect;
import com.yahoo.elide.core.filter.dialect.ParseException;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.core.sort.Sorting;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.security.ChangeSpec;
import com.yahoo.elide.security.PermissionExecutor;
import com.yahoo.elide.security.User;
import com.yahoo.elide.security.executors.ActivePermissionExecutor;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.ReplaySubject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

public class RequestScope
implements com.yahoo.elide.security.RequestScope {
    private final JsonApiDocument jsonApiDocument;
    private final DataStoreTransaction transaction;
    private final User user;
    private final EntityDictionary dictionary;
    private final JsonApiMapper mapper;
    private final AuditLogger auditLogger;
    private final Optional<MultivaluedMap<String, String>> queryParams;
    private final Map<String, Set<String>> sparseFields;
    private final Pagination pagination;
    private final Sorting sorting;
    private final PermissionExecutor permissionExecutor;
    private final ObjectEntityCache objectEntityCache;
    private final Set<PersistentResource> newPersistentResources;
    private final LinkedHashSet<PersistentResource> dirtyResources;
    private final LinkedHashSet<PersistentResource> deletedResources;
    private final String path;
    private final ElideSettings elideSettings;
    private final boolean useFilterExpressions;
    private final int updateStatusCode;
    private final MultipleFilterDialect filterDialect;
    private final Map<String, FilterExpression> expressionsByType;
    private PublishSubject<CRUDEvent> lifecycleEvents;
    private Observable<CRUDEvent> distinctLifecycleEvents;
    private ReplaySubject<CRUDEvent> queuedLifecycleEvents;
    private FilterExpression globalFilterExpression;

    public RequestScope(String path, JsonApiDocument jsonApiDocument, DataStoreTransaction transaction, User user, MultivaluedMap<String, String> queryParams, ElideSettings elideSettings) {
        this.lifecycleEvents = PublishSubject.create();
        this.distinctLifecycleEvents = this.lifecycleEvents.distinct();
        this.queuedLifecycleEvents = ReplaySubject.create();
        this.distinctLifecycleEvents.subscribe(this.queuedLifecycleEvents);
        this.path = path;
        this.jsonApiDocument = jsonApiDocument;
        this.transaction = transaction;
        this.user = user;
        this.dictionary = elideSettings.getDictionary();
        this.mapper = elideSettings.getMapper();
        this.auditLogger = elideSettings.getAuditLogger();
        this.filterDialect = new MultipleFilterDialect(elideSettings.getJoinFilterDialects(), elideSettings.getSubqueryFilterDialects());
        this.elideSettings = elideSettings;
        this.useFilterExpressions = elideSettings.isUseFilterExpressions();
        this.updateStatusCode = elideSettings.getUpdateStatusCode();
        this.globalFilterExpression = null;
        this.expressionsByType = new HashMap<String, FilterExpression>();
        this.objectEntityCache = new ObjectEntityCache();
        this.newPersistentResources = new LinkedHashSet<PersistentResource>();
        this.dirtyResources = new LinkedHashSet();
        this.deletedResources = new LinkedHashSet();
        Function<RequestScope, PermissionExecutor> permissionExecutorGenerator = elideSettings.getPermissionExecutor();
        this.permissionExecutor = permissionExecutorGenerator == null ? new ActivePermissionExecutor(this) : permissionExecutorGenerator.apply(this);
        this.queryParams = queryParams == null || queryParams.size() == 0 ? Optional.empty() : Optional.of(queryParams);
        this.registerPreSecurityObservers();
        if (this.queryParams.isPresent()) {
            block10: {
                MultivaluedMap<String, String> filterParams = RequestScope.getFilterParams(queryParams);
                String errorMessage = "";
                if (!filterParams.isEmpty()) {
                    try {
                        this.globalFilterExpression = this.filterDialect.parseGlobalExpression(path, filterParams);
                    }
                    catch (ParseException e) {
                        errorMessage = e.getMessage();
                    }
                    try {
                        this.expressionsByType.putAll(this.filterDialect.parseTypedExpression(path, filterParams));
                    }
                    catch (ParseException e) {
                        if (this.globalFilterExpression != null) break block10;
                        if (errorMessage.isEmpty()) {
                            errorMessage = e.getMessage();
                        } else if (!errorMessage.equals(e.getMessage())) {
                            errorMessage = errorMessage + "\n" + e.getMessage();
                        }
                        throw new InvalidPredicateException(errorMessage);
                    }
                }
            }
            this.sparseFields = RequestScope.parseSparseFields(queryParams);
            this.sorting = Sorting.parseQueryParams(queryParams);
            this.pagination = Pagination.parseQueryParams(queryParams, this.getElideSettings());
        } else {
            this.sparseFields = Collections.emptyMap();
            this.sorting = Sorting.getDefaultEmptyInstance();
            this.pagination = Pagination.getDefaultPagination(this.getElideSettings());
        }
    }

    protected RequestScope(String path, JsonApiDocument jsonApiDocument, RequestScope outerRequestScope) {
        this.jsonApiDocument = jsonApiDocument;
        this.path = path;
        this.transaction = outerRequestScope.transaction;
        this.user = outerRequestScope.user;
        this.dictionary = outerRequestScope.dictionary;
        this.mapper = outerRequestScope.mapper;
        this.auditLogger = outerRequestScope.auditLogger;
        this.queryParams = Optional.empty();
        this.sparseFields = Collections.emptyMap();
        this.sorting = Sorting.getDefaultEmptyInstance();
        this.pagination = Pagination.getDefaultPagination(outerRequestScope.getElideSettings());
        this.objectEntityCache = outerRequestScope.objectEntityCache;
        this.newPersistentResources = outerRequestScope.newPersistentResources;
        this.permissionExecutor = outerRequestScope.getPermissionExecutor();
        this.dirtyResources = outerRequestScope.dirtyResources;
        this.deletedResources = outerRequestScope.deletedResources;
        this.filterDialect = outerRequestScope.filterDialect;
        this.expressionsByType = outerRequestScope.expressionsByType;
        this.elideSettings = outerRequestScope.elideSettings;
        this.useFilterExpressions = outerRequestScope.useFilterExpressions;
        this.updateStatusCode = outerRequestScope.updateStatusCode;
        this.lifecycleEvents = outerRequestScope.lifecycleEvents;
        this.distinctLifecycleEvents = outerRequestScope.distinctLifecycleEvents;
        this.queuedLifecycleEvents = outerRequestScope.queuedLifecycleEvents;
    }

    public Set<com.yahoo.elide.security.PersistentResource> getNewResources() {
        return this.newPersistentResources;
    }

    public boolean isNewResource(Object entity) {
        return this.newPersistentResources.stream().filter(r -> r.getObject() == entity).findAny().isPresent();
    }

    private static Map<String, Set<String>> parseSparseFields(MultivaluedMap<String, String> queryParams) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Map.Entry kv : queryParams.entrySet()) {
            String key = (String)kv.getKey();
            if (!key.startsWith("fields[") || !key.endsWith("]")) continue;
            String type = key.substring(7, key.length() - 1);
            LinkedHashSet filters = new LinkedHashSet();
            for (String filterParams : (List)kv.getValue()) {
                Collections.addAll(filters, filterParams.split(","));
            }
            if (filters.isEmpty()) continue;
            result.put(type, filters);
        }
        return result;
    }

    public Optional<FilterExpression> getFilterExpressionByType(String type) {
        return Optional.ofNullable(this.expressionsByType.get(type));
    }

    public Optional<FilterExpression> getLoadFilterExpression(Class<?> loadClass) {
        Optional<FilterExpression> filterExpression;
        if (this.globalFilterExpression == null) {
            String typeName = this.dictionary.getJsonAliasFor(loadClass);
            filterExpression = this.getFilterExpressionByType(typeName);
        } else {
            filterExpression = Optional.of(this.globalFilterExpression);
        }
        return filterExpression;
    }

    public Optional<FilterExpression> getExpressionForRelation(PersistentResource parent, String relationName) {
        Class<?> entityClass = this.dictionary.getParameterizedType(parent.getObject(), relationName);
        if (entityClass == null) {
            throw new InvalidAttributeException(relationName, parent.getType());
        }
        if (this.dictionary.isMappedInterface(entityClass) && this.interfaceHasFilterExpression(entityClass)) {
            throw new InvalidOperationException("Cannot apply filters to polymorphic relations mapped with MappedInterface");
        }
        String valType = this.dictionary.getJsonAliasFor(entityClass);
        return this.getFilterExpressionByType(valType);
    }

    private boolean interfaceHasFilterExpression(Class<?> entityInterface) {
        for (String filterType : this.expressionsByType.keySet()) {
            Class<?> polyMorphicClass = this.dictionary.getEntityClass(filterType);
            if (!entityInterface.isAssignableFrom(polyMorphicClass)) continue;
            return true;
        }
        return false;
    }

    private static MultivaluedMap<String, String> getFilterParams(MultivaluedMap<String, String> queryParams) {
        MultivaluedHashMap returnMap = new MultivaluedHashMap();
        queryParams.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("filter")).forEach(arg_0 -> RequestScope.lambda$getFilterParams$2((MultivaluedMap)returnMap, arg_0));
        return returnMap;
    }

    public void runQueuedPreSecurityTriggers() {
        ((LifecycleHookInvoker)this.queuedLifecycleEvents.filter(CRUDEvent::isCreateEvent).subscribeWith((Observer)new LifecycleHookInvoker(this.dictionary, OnCreatePreSecurity.class, false))).throwOnError();
    }

    public void runQueuedPreCommitTriggers() {
        ((LifecycleHookInvoker)this.queuedLifecycleEvents.filter(CRUDEvent::isCreateEvent).subscribeWith((Observer)new LifecycleHookInvoker(this.dictionary, OnCreatePreCommit.class, false))).throwOnError();
        ((LifecycleHookInvoker)this.queuedLifecycleEvents.filter(CRUDEvent::isUpdateEvent).subscribeWith((Observer)new LifecycleHookInvoker(this.dictionary, OnUpdatePreCommit.class, false))).throwOnError();
        ((LifecycleHookInvoker)this.queuedLifecycleEvents.filter(CRUDEvent::isDeleteEvent).subscribeWith((Observer)new LifecycleHookInvoker(this.dictionary, OnDeletePreCommit.class, false))).throwOnError();
        ((LifecycleHookInvoker)this.queuedLifecycleEvents.filter(CRUDEvent::isReadEvent).subscribeWith((Observer)new LifecycleHookInvoker(this.dictionary, OnReadPreCommit.class, false))).throwOnError();
    }

    public void runQueuedPostCommitTriggers() {
        ((LifecycleHookInvoker)this.queuedLifecycleEvents.filter(CRUDEvent::isCreateEvent).subscribeWith((Observer)new LifecycleHookInvoker(this.dictionary, OnCreatePostCommit.class, false))).throwOnError();
        ((LifecycleHookInvoker)this.queuedLifecycleEvents.filter(CRUDEvent::isUpdateEvent).subscribeWith((Observer)new LifecycleHookInvoker(this.dictionary, OnUpdatePostCommit.class, false))).throwOnError();
        ((LifecycleHookInvoker)this.queuedLifecycleEvents.filter(CRUDEvent::isDeleteEvent).subscribeWith((Observer)new LifecycleHookInvoker(this.dictionary, OnDeletePostCommit.class, false))).throwOnError();
        ((LifecycleHookInvoker)this.queuedLifecycleEvents.filter(CRUDEvent::isReadEvent).subscribeWith((Observer)new LifecycleHookInvoker(this.dictionary, OnReadPostCommit.class, false))).throwOnError();
    }

    protected void publishLifecycleEvent(PersistentResource<?> resource, CRUDEvent.CRUDAction crudAction) {
        this.lifecycleEvents.onNext((Object)new CRUDEvent(crudAction, resource, "", Optional.empty()));
    }

    protected void publishLifecycleEvent(PersistentResource<?> resource, String fieldName, CRUDEvent.CRUDAction crudAction, Optional<ChangeSpec> changeSpec) {
        this.lifecycleEvents.onNext((Object)new CRUDEvent(crudAction, resource, fieldName, changeSpec));
    }

    public void saveOrCreateObjects() {
        this.dirtyResources.removeAll(this.newPersistentResources);
        this.dirtyResources.removeAll(this.deletedResources);
        this.newPersistentResources.stream().map(PersistentResource::getObject).forEach(s -> this.transaction.createObject(s, this));
        this.dirtyResources.stream().map(PersistentResource::getObject).forEach(obj -> this.transaction.save(obj, this));
    }

    public String getUUIDFor(Object o) {
        return this.objectEntityCache.getUUID(o);
    }

    public Object getObjectById(String type, String id) {
        Object result = this.objectEntityCache.get(type, id);
        Iterator<String> it = this.dictionary.getSubclassingEntityNames(type).iterator();
        while (result == null && it.hasNext()) {
            String newType = this.getInheritanceKey(it.next(), type);
            result = this.objectEntityCache.get(newType, id);
        }
        return result;
    }

    public void setUUIDForObject(String type, String id, Object object) {
        this.objectEntityCache.put(type, id, object);
        this.dictionary.getSuperClassEntityNames(type).stream().map(i -> this.getInheritanceKey(type, (String)i)).forEach(newType -> this.objectEntityCache.put((String)newType, id, object));
    }

    private String getInheritanceKey(String subClass, String superClass) {
        return subClass + "!" + superClass;
    }

    private void registerPreSecurityObservers() {
        this.distinctLifecycleEvents.filter(CRUDEvent::isReadEvent).subscribeWith((Observer)new LifecycleHookInvoker(this.dictionary, OnReadPreSecurity.class, true));
        this.distinctLifecycleEvents.filter(CRUDEvent::isUpdateEvent).subscribeWith((Observer)new LifecycleHookInvoker(this.dictionary, OnUpdatePreSecurity.class, true));
        this.distinctLifecycleEvents.filter(CRUDEvent::isDeleteEvent).subscribeWith((Observer)new LifecycleHookInvoker(this.dictionary, OnDeletePreSecurity.class, true));
    }

    public JsonApiDocument getJsonApiDocument() {
        return this.jsonApiDocument;
    }

    public DataStoreTransaction getTransaction() {
        return this.transaction;
    }

    public User getUser() {
        return this.user;
    }

    public EntityDictionary getDictionary() {
        return this.dictionary;
    }

    public JsonApiMapper getMapper() {
        return this.mapper;
    }

    public AuditLogger getAuditLogger() {
        return this.auditLogger;
    }

    public Optional<MultivaluedMap<String, String>> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, Set<String>> getSparseFields() {
        return this.sparseFields;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public Sorting getSorting() {
        return this.sorting;
    }

    public PermissionExecutor getPermissionExecutor() {
        return this.permissionExecutor;
    }

    public ObjectEntityCache getObjectEntityCache() {
        return this.objectEntityCache;
    }

    public Set<PersistentResource> getNewPersistentResources() {
        return this.newPersistentResources;
    }

    public LinkedHashSet<PersistentResource> getDirtyResources() {
        return this.dirtyResources;
    }

    public LinkedHashSet<PersistentResource> getDeletedResources() {
        return this.deletedResources;
    }

    public String getPath() {
        return this.path;
    }

    public ElideSettings getElideSettings() {
        return this.elideSettings;
    }

    public boolean isUseFilterExpressions() {
        return this.useFilterExpressions;
    }

    public int getUpdateStatusCode() {
        return this.updateStatusCode;
    }

    public MultipleFilterDialect getFilterDialect() {
        return this.filterDialect;
    }

    private static /* synthetic */ void lambda$getFilterParams$2(MultivaluedMap returnMap, Map.Entry entry) {
        returnMap.put(entry.getKey(), entry.getValue());
    }
}

