/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.filter.InPredicate;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.core.sort.Sorting;
import com.yahoo.elide.security.User;
import java.io.Closeable;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;

public interface DataStoreTransaction
extends Closeable {
    default public User accessUser(Object opaqueUser) {
        return new User(opaqueUser);
    }

    public void save(Object var1, RequestScope var2);

    public void delete(Object var1, RequestScope var2);

    public void flush(RequestScope var1);

    public void commit(RequestScope var1);

    default public void preCommit() {
    }

    public void createObject(Object var1, RequestScope var2);

    default public <T> T createNewObject(Class<T> entityClass) {
        T obj;
        try {
            obj = entityClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            obj = null;
        }
        return obj;
    }

    default public Object loadObject(Class<?> entityClass, Serializable id, Optional<FilterExpression> filterExpression, RequestScope scope) {
        Iterator<Object> it;
        EntityDictionary dictionary = scope.getDictionary();
        Class<?> idType = dictionary.getIdType(entityClass);
        String idField = dictionary.getIdFieldName(entityClass);
        InPredicate idFilter = new InPredicate(new Path.PathElement(entityClass, idType, idField), id);
        FilterExpression joinedFilterExpression = filterExpression.map(fe -> new AndFilterExpression(idFilter, (FilterExpression)fe)).orElse(idFilter);
        Iterable<Object> results = this.loadObjects(entityClass, Optional.of(joinedFilterExpression), Optional.empty(), Optional.empty(), scope);
        Iterator<Object> iterator = it = results == null ? null : results.iterator();
        if (it != null && it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public Iterable<Object> loadObjects(Class<?> var1, Optional<FilterExpression> var2, Optional<Sorting> var3, Optional<Pagination> var4, RequestScope var5);

    default public Object getRelation(DataStoreTransaction relationTx, Object entity, String relationName, Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination, RequestScope scope) {
        return PersistentResource.getValue(entity, relationName, scope);
    }

    default public void updateToManyRelation(DataStoreTransaction relationTx, Object entity, String relationName, Set<Object> newRelationships, Set<Object> deletedRelationships, RequestScope scope) {
    }

    default public void updateToOneRelation(DataStoreTransaction relationTx, Object entity, String relationName, Object relationshipValue, RequestScope scope) {
    }

    default public Object getAttribute(Object entity, String attributeName, RequestScope scope) {
        return PersistentResource.getValue(entity, attributeName, scope);
    }

    default public void setAttribute(Object entity, String attributeName, Object attributeValue, RequestScope scope) {
    }

    default public FeatureSupport supportsFiltering(Class<?> entityClass, FilterExpression expression) {
        return FeatureSupport.FULL;
    }

    default public boolean supportsSorting(Class<?> entityClass, Sorting sorting) {
        return true;
    }

    default public boolean supportsPagination(Class<?> entityClass) {
        return true;
    }

    public static enum FeatureSupport {
        FULL,
        PARTIAL,
        NONE;

    }
}

