/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.audit.AuditLogger;
import com.yahoo.elide.core.DataStore;
import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.ErrorObjects;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.inmemory.InMemoryDataStore;
import com.yahoo.elide.core.exceptions.CustomErrorException;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.core.exceptions.InternalServerErrorException;
import com.yahoo.elide.core.exceptions.InvalidConstraintException;
import com.yahoo.elide.core.exceptions.InvalidURLException;
import com.yahoo.elide.core.exceptions.JsonPatchExtensionException;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.core.exceptions.UnableToAddSerdeException;
import com.yahoo.elide.extensions.JsonApiPatch;
import com.yahoo.elide.extensions.PatchRequestScope;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.parsers.BaseVisitor;
import com.yahoo.elide.parsers.DeleteVisitor;
import com.yahoo.elide.parsers.GetVisitor;
import com.yahoo.elide.parsers.JsonApiParser;
import com.yahoo.elide.parsers.PatchVisitor;
import com.yahoo.elide.parsers.PostVisitor;
import com.yahoo.elide.security.User;
import com.yahoo.elide.utils.ClassScanner;
import com.yahoo.elide.utils.coerce.CoerceUtil;
import com.yahoo.elide.utils.coerce.converters.ElideTypeConverter;
import com.yahoo.elide.utils.coerce.converters.Serde;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Elide {
    private static final Logger log = LoggerFactory.getLogger(Elide.class);
    public static final String JSONAPI_CONTENT_TYPE = "application/vnd.api+json";
    public static final String JSONAPI_CONTENT_TYPE_WITH_JSON_PATCH_EXTENSION = "application/vnd.api+json; ext=jsonpatch";
    private final ElideSettings elideSettings;
    private final AuditLogger auditLogger;
    private final DataStore dataStore;
    private final JsonApiMapper mapper;

    public Elide(ElideSettings elideSettings) {
        this.elideSettings = elideSettings;
        this.auditLogger = elideSettings.getAuditLogger();
        this.dataStore = new InMemoryDataStore(elideSettings.getDataStore());
        this.dataStore.populateEntityDictionary(elideSettings.getDictionary());
        this.mapper = elideSettings.getMapper();
        elideSettings.getSerdes().forEach((targetType, serde) -> CoerceUtil.register(targetType, serde));
        this.registerCustomSerde();
    }

    private void registerCustomSerde() {
        Set<Class<?>> classes = ClassScanner.getAnnotatedClasses(ElideTypeConverter.class);
        for (Class<?> clazz : classes) {
            Serde serde;
            if (!Serde.class.isAssignableFrom(clazz)) {
                log.warn("Skipping Serde registration (not a Serde!): {}", clazz);
                continue;
            }
            try {
                serde = (Serde)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                String errorMsg = String.format("Error while registering custom Serde: %s", e.getLocalizedMessage());
                log.error(errorMsg);
                throw new UnableToAddSerdeException(errorMsg);
            }
            ElideTypeConverter converter = clazz.getAnnotation(ElideTypeConverter.class);
            Class<?> baseType = converter.type();
            this.registerCustomSerde(baseType, serde, converter.name());
            for (Class<?> type : converter.subTypes()) {
                if (!baseType.isAssignableFrom(type)) {
                    throw new IllegalArgumentException("Mentioned type " + type + " not subtype of " + baseType);
                }
                this.registerCustomSerde(type, serde, converter.name());
            }
        }
    }

    private void registerCustomSerde(Class<?> type, Serde serde, String name) {
        log.info("Registering serde for type : {}", type);
        CoerceUtil.register(type, serde);
        this.registerCustomSerdeInObjectMapper(type, serde, name);
    }

    private void registerCustomSerdeInObjectMapper(Class<?> type, final Serde serde, String name) {
        ObjectMapper objectMapper = this.mapper.getObjectMapper();
        objectMapper.registerModule((Module)new SimpleModule(name).addSerializer(type, (JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
                jsonGenerator.writeObject(serde.serialize(obj));
            }
        }));
    }

    public ElideResponse get(String path, MultivaluedMap<String, String> queryParams, Object opaqueUser) {
        return this.handleRequest(true, opaqueUser, this.dataStore::beginReadTransaction, (tx, user) -> {
            JsonApiDocument jsonApiDoc = new JsonApiDocument();
            RequestScope requestScope = new RequestScope(path, jsonApiDoc, (DataStoreTransaction)tx, (User)user, queryParams, this.elideSettings);
            GetVisitor visitor = new GetVisitor(requestScope);
            return this.visit(path, requestScope, visitor);
        });
    }

    public ElideResponse post(String path, String jsonApiDocument, Object opaqueUser) {
        return this.handleRequest(false, opaqueUser, this.dataStore::beginTransaction, (tx, user) -> {
            JsonApiDocument jsonApiDoc = this.mapper.readJsonApiDocument(jsonApiDocument);
            RequestScope requestScope = new RequestScope(path, jsonApiDoc, (DataStoreTransaction)tx, (User)user, null, this.elideSettings);
            PostVisitor visitor = new PostVisitor(requestScope);
            return this.visit(path, requestScope, visitor);
        });
    }

    public ElideResponse patch(String contentType, String accept, String path, String jsonApiDocument, Object opaqueUser) {
        Handler<DataStoreTransaction, User, HandlerResult> handler = JsonApiPatch.isPatchExtension(contentType) && JsonApiPatch.isPatchExtension(accept) ? (tx, user) -> {
            PatchRequestScope requestScope = new PatchRequestScope(path, (DataStoreTransaction)tx, (User)user, this.elideSettings);
            try {
                Supplier<Pair<Integer, JsonNode>> responder = JsonApiPatch.processJsonPatch(this.dataStore, path, jsonApiDocument, requestScope);
                return new HandlerResult((RequestScope)requestScope, responder);
            }
            catch (RuntimeException e) {
                return new HandlerResult((RequestScope)requestScope, e);
            }
        } : (tx, user) -> {
            JsonApiDocument jsonApiDoc = this.mapper.readJsonApiDocument(jsonApiDocument);
            RequestScope requestScope = new RequestScope(path, jsonApiDoc, (DataStoreTransaction)tx, (User)user, null, this.elideSettings);
            PatchVisitor visitor = new PatchVisitor(requestScope);
            return this.visit(path, requestScope, visitor);
        };
        return this.handleRequest(false, opaqueUser, this.dataStore::beginTransaction, handler);
    }

    public ElideResponse delete(String path, String jsonApiDocument, Object opaqueUser) {
        return this.handleRequest(false, opaqueUser, this.dataStore::beginTransaction, (tx, user) -> {
            JsonApiDocument jsonApiDoc = StringUtils.isEmpty((CharSequence)jsonApiDocument) ? new JsonApiDocument() : this.mapper.readJsonApiDocument(jsonApiDocument);
            RequestScope requestScope = new RequestScope(path, jsonApiDoc, (DataStoreTransaction)tx, (User)user, null, this.elideSettings);
            DeleteVisitor visitor = new DeleteVisitor(requestScope);
            return this.visit(path, requestScope, visitor);
        });
    }

    public HandlerResult visit(String path, RequestScope requestScope, BaseVisitor visitor) {
        try {
            Supplier responder = (Supplier)visitor.visit(JsonApiParser.parse(path));
            return new HandlerResult(requestScope, responder);
        }
        catch (RuntimeException e) {
            return new HandlerResult(requestScope, e);
        }
    }

    /*
     * Loose catch block
     */
    protected ElideResponse handleRequest(boolean isReadOnly, Object opaqueUser, Supplier<DataStoreTransaction> transaction, Handler<DataStoreTransaction, User, HandlerResult> handler) {
        boolean isVerbose = false;
        try {
            ElideResponse elideResponse;
            Object object;
            DataStoreTransaction tx;
            block34: {
                block35: {
                    tx = transaction.get();
                    object = null;
                    User user = tx.accessUser(opaqueUser);
                    HandlerResult result = handler.handle(tx, user);
                    RequestScope requestScope = result.getRequestScope();
                    isVerbose = requestScope.getPermissionExecutor().isVerbose();
                    Supplier<Pair<Integer, JsonNode>> responder = result.getResponder();
                    tx.preCommit();
                    requestScope.runQueuedPreSecurityTriggers();
                    requestScope.getPermissionExecutor().executeCommitChecks();
                    if (!isReadOnly) {
                        requestScope.saveOrCreateObjects();
                    }
                    tx.flush(requestScope);
                    requestScope.runQueuedPreCommitTriggers();
                    ElideResponse response = this.buildResponse(responder.get());
                    this.auditLogger.commit(requestScope);
                    tx.commit(requestScope);
                    requestScope.runQueuedPostCommitTriggers();
                    if (log.isTraceEnabled()) {
                        requestScope.getPermissionExecutor().printCheckStats();
                    }
                    elideResponse = response;
                    if (tx == null) break block34;
                    if (object == null) break block35;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    break block34;
                }
                tx.close();
            }
            return elideResponse;
            catch (Throwable throwable) {
                try {
                    try {
                        object = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (tx != null) {
                            if (object != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                tx.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (WebApplicationException e) {
                    throw e;
                }
                catch (ForbiddenAccessException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("{}", (Object)e.getLoggedMessage());
                    }
                    object = this.buildErrorResponse(e, isVerbose);
                    return object;
                }
                catch (JsonPatchExtensionException e) {
                    log.debug("JSON patch extension exception caught", (Throwable)e);
                    object = this.buildErrorResponse(e, isVerbose);
                    return object;
                }
                catch (HttpStatusException e) {
                    log.debug("Caught HTTP status exception", (Throwable)e);
                    object = this.buildErrorResponse(e, isVerbose);
                    return object;
                }
                catch (IOException e) {
                    log.error("IO Exception uncaught by Elide", (Throwable)e);
                    object = this.buildErrorResponse(new TransactionException(e), isVerbose);
                    return object;
                }
                catch (ParseCancellationException e) {
                    log.debug("Parse cancellation exception uncaught by Elide (i.e. invalid URL)", (Throwable)e);
                    object = this.buildErrorResponse(new InvalidURLException((Exception)((Object)e)), isVerbose);
                    return object;
                }
                catch (ConstraintViolationException e) {
                    log.debug("Constraint violation exception caught", (Throwable)e);
                    String message = "Constraint violation";
                    if (CollectionUtils.isNotEmpty((Collection)e.getConstraintViolations())) {
                        message = ((ConstraintViolation)IterableUtils.first((Iterable)e.getConstraintViolations())).getMessage();
                    }
                    ElideResponse elideResponse2 = this.buildErrorResponse(new InvalidConstraintException(message), isVerbose);
                    return elideResponse2;
                }
                catch (Error | Exception e) {
                    log.error("Error or exception uncaught by Elide", e);
                    throw e;
                }
            }
        }
        finally {
            this.auditLogger.clear();
        }
    }

    protected ElideResponse buildErrorResponse(HttpStatusException error, boolean isVerbose) {
        if (error instanceof InternalServerErrorException) {
            log.error("Internal Server Error", (Throwable)error);
        }
        boolean encodeErrorResponse = this.elideSettings.isEncodeErrorResponses();
        if (!(error instanceof CustomErrorException) && this.elideSettings.isReturnErrorObjects()) {
            String errorDetail;
            String string = errorDetail = isVerbose ? error.getVerboseMessage() : error.toString();
            if (encodeErrorResponse) {
                errorDetail = Encode.forHtml((String)errorDetail);
            }
            ErrorObjects errors = ErrorObjects.builder().addError().withDetail(errorDetail).build();
            JsonNode responseBody = (JsonNode)this.mapper.getObjectMapper().convertValue((Object)errors, JsonNode.class);
            return this.buildResponse((Pair<Integer, JsonNode>)Pair.of((Object)error.getStatus(), (Object)responseBody));
        }
        return this.buildResponse(isVerbose ? error.getVerboseErrorResponse(encodeErrorResponse) : error.getErrorResponse(encodeErrorResponse));
    }

    protected ElideResponse buildResponse(Pair<Integer, JsonNode> response) {
        try {
            JsonNode responseNode = (JsonNode)response.getRight();
            Integer responseCode = (Integer)response.getLeft();
            String body = responseNode == null ? null : this.mapper.writeJsonApiDocument(responseNode);
            return new ElideResponse(responseCode, body);
        }
        catch (JsonProcessingException e) {
            return new ElideResponse(500, e.toString());
        }
    }

    public ElideSettings getElideSettings() {
        return this.elideSettings;
    }

    public AuditLogger getAuditLogger() {
        return this.auditLogger;
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    public JsonApiMapper getMapper() {
        return this.mapper;
    }

    protected static class HandlerResult {
        protected RequestScope requestScope;
        protected Supplier<Pair<Integer, JsonNode>> result;
        protected RuntimeException cause;

        protected HandlerResult(RequestScope requestScope, Supplier<Pair<Integer, JsonNode>> result) {
            this.requestScope = requestScope;
            this.result = result;
        }

        public HandlerResult(RequestScope requestScope, RuntimeException cause) {
            this.requestScope = requestScope;
            this.cause = cause;
        }

        public Supplier<Pair<Integer, JsonNode>> getResponder() {
            if (this.cause != null) {
                throw this.cause;
            }
            return this.result;
        }

        public RequestScope getRequestScope() {
            return this.requestScope;
        }
    }

    @FunctionalInterface
    public static interface Handler<DataStoreTransaction, User, HandlerResult> {
        public HandlerResult handle(DataStoreTransaction var1, User var2) throws IOException;
    }
}

