/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.security.permissions.expressions;

import com.yahoo.elide.security.permissions.ExpressionResult;
import com.yahoo.elide.security.permissions.expressions.Expression;

public class AndExpression
implements Expression {
    private final Expression left;
    private final Expression right;

    public AndExpression(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public ExpressionResult evaluate(Expression.EvaluationMode mode) {
        ExpressionResult rightStatus;
        ExpressionResult leftStatus = this.left.evaluate(mode);
        if (leftStatus == ExpressionResult.FAIL) {
            return leftStatus;
        }
        ExpressionResult expressionResult = rightStatus = this.right == null ? ExpressionResult.PASS : this.right.evaluate(mode);
        if (rightStatus == ExpressionResult.FAIL) {
            return rightStatus;
        }
        if (leftStatus == ExpressionResult.PASS && rightStatus == ExpressionResult.PASS) {
            return ExpressionResult.PASS;
        }
        return ExpressionResult.DEFERRED;
    }

    public String toString() {
        if (this.right == null) {
            return String.format("%s", this.left);
        }
        return String.format("(%s) AND (%s)", this.left, this.right);
    }
}

