/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.parsers.state;

import com.google.common.base.Preconditions;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RelationshipType;
import com.yahoo.elide.core.exceptions.InvalidAttributeException;
import com.yahoo.elide.core.exceptions.InvalidCollectionException;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.generated.parsers.CoreParser;
import com.yahoo.elide.jsonapi.models.SingleElementSet;
import com.yahoo.elide.parsers.state.BaseState;
import com.yahoo.elide.parsers.state.CollectionTerminalState;
import com.yahoo.elide.parsers.state.RecordTerminalState;
import com.yahoo.elide.parsers.state.RelationshipTerminalState;
import com.yahoo.elide.parsers.state.StateContext;
import java.util.Optional;
import java.util.Set;

public class RecordState
extends BaseState {
    private final PersistentResource resource;

    public RecordState(PersistentResource resource) {
        Preconditions.checkNotNull((Object)resource);
        this.resource = resource;
    }

    @Override
    public void handle(StateContext state, CoreParser.SubCollectionReadCollectionContext ctx) {
        String subCollection = ctx.term().getText();
        EntityDictionary dictionary = state.getRequestScope().getDictionary();
        try {
            BaseState nextState;
            Class<?> entityClass;
            String entityName;
            RelationshipType type = dictionary.getRelationshipType(this.resource.getObject(), subCollection);
            if (type == RelationshipType.NONE) {
                throw new InvalidCollectionException(subCollection);
            }
            Class<?> paramType = dictionary.getParameterizedType(this.resource.getObject(), subCollection);
            if (dictionary.isMappedInterface(paramType)) {
                entityName = EntityDictionary.getSimpleName(paramType);
                entityClass = paramType;
            } else {
                entityName = dictionary.getJsonAliasFor(paramType);
                entityClass = dictionary.getEntityClass(entityName);
            }
            if (entityClass == null) {
                throw new IllegalArgumentException("Unknown type " + entityName);
            }
            CollectionTerminalState collectionTerminalState = new CollectionTerminalState(entityClass, Optional.of(this.resource), Optional.of(subCollection));
            Set<PersistentResource> collection = null;
            if (type.isToOne()) {
                Optional<FilterExpression> filterExpression = state.getRequestScope().getExpressionForRelation(this.resource, subCollection);
                collection = this.resource.getRelationCheckedFiltered(subCollection, filterExpression, Optional.empty(), Optional.empty());
            }
            if (collection instanceof SingleElementSet) {
                PersistentResource record = (PersistentResource)((SingleElementSet)collection).getValue();
                nextState = new RecordTerminalState(record, collectionTerminalState);
            } else {
                nextState = collectionTerminalState;
            }
            state.setState(nextState);
        }
        catch (InvalidAttributeException e) {
            throw new InvalidCollectionException(subCollection);
        }
    }

    @Override
    public void handle(StateContext state, CoreParser.SubCollectionReadEntityContext ctx) {
        String id = ctx.entity().id().getText();
        String subCollection = ctx.entity().term().getText();
        try {
            PersistentResource nextRecord = this.resource.getRelation(subCollection, id);
            state.setState(new RecordTerminalState(nextRecord));
        }
        catch (InvalidAttributeException e) {
            throw new InvalidCollectionException(subCollection);
        }
    }

    @Override
    public void handle(StateContext state, CoreParser.SubCollectionSubCollectionContext ctx) {
        String id = ctx.entity().id().getText();
        String subCollection = ctx.entity().term().getText();
        try {
            state.setState(new RecordState(this.resource.getRelation(subCollection, id)));
        }
        catch (InvalidAttributeException e) {
            throw new InvalidCollectionException(subCollection);
        }
    }

    @Override
    public void handle(StateContext state, CoreParser.SubCollectionRelationshipContext ctx) {
        PersistentResource childRecord;
        String id = ctx.entity().id().getText();
        String subCollection = ctx.entity().term().getText();
        try {
            childRecord = this.resource.getRelation(subCollection, id);
        }
        catch (InvalidAttributeException e) {
            throw new InvalidCollectionException(subCollection);
        }
        String relationName = ctx.relationship().term().getText();
        try {
            Optional<FilterExpression> filterExpression = state.getRequestScope().getExpressionForRelation(this.resource, subCollection);
            childRecord.getRelationCheckedFiltered(relationName, filterExpression, Optional.empty(), Optional.empty());
        }
        catch (InvalidAttributeException e) {
            throw new InvalidCollectionException(relationName);
        }
        state.setState(new RelationshipTerminalState(childRecord, relationName));
    }
}

