/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.jsonapi.JsonApiSerializer;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.models.Patch;
import com.yahoo.elide.utils.coerce.CoerceUtil;
import com.yahoo.elide.utils.coerce.converters.Serde;
import java.io.IOException;
import java.util.Date;
import java.util.List;

public class JsonApiMapper {
    private final ObjectMapper mapper;

    public JsonApiMapper() {
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new SimpleModule("isoDate", Version.unknownVersion()).addSerializer(Date.class, (JsonSerializer)new JsonSerializer<Date>(){

            public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
                Serde serde = CoerceUtil.lookup(Date.class);
                jsonGenerator.writeObject(serde.serialize(date));
            }
        }));
        this.mapper.registerModule(JsonApiSerializer.getModule());
    }

    public JsonApiMapper(ObjectMapper mapper) {
        this.mapper = mapper;
        mapper.registerModule(JsonApiSerializer.getModule());
    }

    @Deprecated
    public JsonApiMapper(EntityDictionary dictionary) {
        this();
    }

    @Deprecated
    public JsonApiMapper(EntityDictionary dictionary, ObjectMapper mapper) {
        this(mapper);
    }

    public String writeJsonApiDocument(JsonApiDocument jsonApiDocument) throws JsonProcessingException {
        return this.mapper.writeValueAsString((Object)jsonApiDocument);
    }

    public JsonNode toJsonObject(JsonApiDocument jsonApiDocument) {
        return (JsonNode)this.mapper.convertValue((Object)jsonApiDocument, JsonNode.class);
    }

    public String writeJsonApiDocument(JsonNode node) throws JsonProcessingException {
        return this.mapper.writeValueAsString((Object)node);
    }

    public JsonApiDocument readJsonApiDocument(String doc) throws IOException {
        JsonNode node = this.mapper.readTree(doc);
        return this.readJsonApiDocument(node);
    }

    public JsonApiDocument readJsonApiDocument(JsonNode node) throws IOException {
        return (JsonApiDocument)this.mapper.treeToValue((TreeNode)node, JsonApiDocument.class);
    }

    public JsonApiDocument readJsonApiPatchExtValue(JsonNode value) throws JsonProcessingException {
        JsonNode data = JsonNodeFactory.instance.objectNode().set("data", value);
        return (JsonApiDocument)this.mapper.treeToValue((TreeNode)data, JsonApiDocument.class);
    }

    public List<Patch> readJsonApiPatchExtDoc(String doc) throws IOException {
        return (List)this.mapper.readValue(doc, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, Patch.class));
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }
}

