/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.google.common.collect.UnmodifiableIterator;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import java.util.AbstractSet;
import java.util.Iterator;

public class PersistentResourceSet<T>
extends AbstractSet<PersistentResource<T>> {
    private final PersistentResource<?> parent;
    private final Iterable<T> list;
    private final RequestScope requestScope;

    public PersistentResourceSet(PersistentResource<?> parent, Iterable<T> list, RequestScope requestScope) {
        this.parent = parent;
        this.list = list;
        this.requestScope = requestScope;
    }

    public PersistentResourceSet(Iterable<T> list, RequestScope requestScope) {
        this(null, list, requestScope);
    }

    @Override
    public Iterator<PersistentResource<T>> iterator() {
        final Iterator<T> iterator = this.list.iterator();
        return new UnmodifiableIterator<PersistentResource<T>>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public PersistentResource<T> next() {
                Object obj = iterator.next();
                return new PersistentResource(obj, PersistentResourceSet.this.parent, PersistentResourceSet.this.requestScope.getUUIDFor(obj), PersistentResourceSet.this.requestScope);
            }
        };
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }
}

