/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.DefaultMemoryRequestServer;
import com.yahoo.memory.MemoryRequestServer;
import com.yahoo.memory.Prim;
import com.yahoo.memory.StepBoolean;
import com.yahoo.memory.UnsafeUtil;
import com.yahoo.memory.Util;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicLong;

final class ResourceState {
    private static final ByteOrder nativeOrder_ = ByteOrder.nativeOrder();
    static final AtomicLong currentDirectMemoryAllocations_ = new AtomicLong();
    static final AtomicLong currentDirectMemoryAllocated_ = new AtomicLong();
    static final AtomicLong currentDirectMemoryMapAllocations_ = new AtomicLong();
    static final AtomicLong currentDirectMemoryMapAllocated_ = new AtomicLong();
    private long nativeBaseOffset_;
    private Object unsafeObj_;
    private long regionOffset_;
    private long cumBaseOffset_;
    private long capacity_;
    private MemoryRequestServer memReqSvr_ = new DefaultMemoryRequestServer();
    private final boolean resourceIsReadOnly_;
    private StepBoolean valid_;
    private ByteBuffer byteBuf_;
    private ByteOrder resourceOrder_ = nativeOrder_;

    ResourceState(boolean resourceReadOnly) {
        this.resourceIsReadOnly_ = resourceReadOnly;
        this.valid_ = new StepBoolean(true);
    }

    ResourceState(Object obj, Prim prim, long arrLen) {
        this(false);
        Util.nullCheck(obj, "Array Object");
        Util.negativeCheck(arrLen, "Capacity");
        this.unsafeObj_ = obj;
        this.capacity_ = arrLen << (int)prim.shift();
        this.compute();
    }

    private ResourceState(ResourceState src) {
        this.nativeBaseOffset_ = src.nativeBaseOffset_;
        this.unsafeObj_ = src.unsafeObj_;
        this.capacity_ = src.capacity_;
        this.memReqSvr_ = src.memReqSvr_;
        this.resourceIsReadOnly_ = src.resourceIsReadOnly_;
        this.valid_ = src.valid_;
        this.regionOffset_ = src.regionOffset_;
        this.byteBuf_ = src.byteBuf_;
        this.resourceOrder_ = src.resourceOrder_;
        this.compute();
    }

    ResourceState copy() {
        return new ResourceState(this);
    }

    private void compute() {
        this.cumBaseOffset_ = this.regionOffset_ + (this.unsafeObj_ == null ? this.nativeBaseOffset_ : (long)UnsafeUtil.unsafe.arrayBaseOffset(this.unsafeObj_.getClass()));
    }

    long getNativeBaseOffset() {
        return this.nativeBaseOffset_;
    }

    void putNativeBaseOffset(long nativeBaseOffset) {
        Util.negativeCheck(nativeBaseOffset, "nativeBaseOffset");
        this.nativeBaseOffset_ = nativeBaseOffset;
        this.compute();
    }

    Object getUnsafeObject() {
        return this.unsafeObj_;
    }

    void putUnsafeObject(Object unsafeObj) {
        Util.nullCheck(unsafeObj, "Array Object");
        this.unsafeObj_ = unsafeObj;
        this.compute();
    }

    long getCapacity() {
        return this.capacity_;
    }

    void putCapacity(long capacity) {
        Util.negativeCheck(capacity, "Capacity");
        this.capacity_ = capacity;
    }

    long getCumBaseOffset() {
        return this.cumBaseOffset_;
    }

    MemoryRequestServer getMemoryRequestServer() {
        return this.memReqSvr_;
    }

    void putMemoryRequestServer(MemoryRequestServer memReqSvr) {
        this.memReqSvr_ = memReqSvr;
    }

    boolean isResourceReadOnly() {
        return this.resourceIsReadOnly_;
    }

    boolean isDirect() {
        return this.nativeBaseOffset_ > 0L;
    }

    boolean isSameResource(ResourceState that) {
        if (this == that) {
            return true;
        }
        return this.getCumBaseOffset() == that.getCumBaseOffset() && this.getCapacity() == that.getCapacity() && this.getUnsafeObject() == that.getUnsafeObject() && this.getByteBuffer() == that.getByteBuffer();
    }

    boolean isValid() {
        return this.valid_.get();
    }

    StepBoolean getValid() {
        return this.valid_;
    }

    void setInvalid() {
        this.valid_.change();
    }

    final void checkValid() {
        if (!this.valid_.get()) {
            throw new IllegalStateException("Memory not valid.");
        }
    }

    long getRegionOffset() {
        return this.regionOffset_;
    }

    void putRegionOffset(long regionOffset) {
        Util.negativeCheck(regionOffset, "Region Offset");
        this.regionOffset_ = regionOffset;
        this.compute();
    }

    ByteBuffer getByteBuffer() {
        return this.byteBuf_;
    }

    void putByteBuffer(ByteBuffer byteBuf) {
        Util.nullCheck(byteBuf, "ByteBuffer");
        this.byteBuf_ = byteBuf;
        this.resourceOrder_ = this.byteBuf_.order();
    }

    ByteOrder getResourceOrder() {
        return this.resourceOrder_;
    }

    void putResourceOrder(ByteOrder resourceOrder) {
        Util.nullCheck(resourceOrder, "ByteOrder");
        this.resourceOrder_ = resourceOrder;
    }

    boolean isSwapBytes() {
        return this.resourceOrder_ != nativeOrder_;
    }
}

