/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.ResourceState;
import com.yahoo.memory.UnsafeUtil;
import com.yahoo.memory.Utf8CodingException;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.CharBuffer;

final class Utf8 {
    Utf8() {
    }

    static final void getCharsFromUtf8(long offsetBytes, int utf8LengthBytes, Appendable dst, ResourceState state) throws IOException, Utf8CodingException {
        byte b;
        int i;
        assert (state.isValid());
        UnsafeUtil.checkBounds(offsetBytes, utf8LengthBytes, state.getCapacity());
        long cumBaseOffset = state.getCumBaseOffset();
        long address = cumBaseOffset + offsetBytes;
        Object unsafeObj = state.getUnsafeObject();
        if (dst instanceof CharBuffer && ((CharBuffer)dst).hasArray()) {
            Utf8.getCharsFromUtf8CharBuffer(offsetBytes, (CharBuffer)dst, utf8LengthBytes, cumBaseOffset, state);
            return;
        }
        for (i = 0; i < utf8LengthBytes && DecodeUtil.isOneByte(b = UnsafeUtil.unsafe.getByte(unsafeObj, address + (long)i)); ++i) {
            dst.append((char)b);
        }
        if (i == utf8LengthBytes) {
            return;
        }
        Utf8.getCharsFromUtf8NonAscii(dst, address + (long)i, address + (long)utf8LengthBytes, unsafeObj, cumBaseOffset);
    }

    private static void getCharsFromUtf8CharBuffer(long offsetBytes, CharBuffer cbuf, int utf8LengthBytes, long cumBaseOffset, ResourceState state) {
        byte b;
        int i;
        char[] carr = cbuf.array();
        int cpos = cbuf.position() + cbuf.arrayOffset();
        int clim = cbuf.arrayOffset() + cbuf.limit();
        long address = state.getCumBaseOffset() + offsetBytes;
        Object unsafeObj = state.getUnsafeObject();
        int cbufNoCheckLimit = Math.min(utf8LengthBytes, clim - cpos);
        for (i = 0; i < cbufNoCheckLimit && DecodeUtil.isOneByte(b = UnsafeUtil.unsafe.getByte(unsafeObj, address + (long)i)); ++i) {
            carr[cpos++] = (char)b;
        }
        while (i < utf8LengthBytes && DecodeUtil.isOneByte(b = UnsafeUtil.unsafe.getByte(unsafeObj, address + (long)i))) {
            Utf8.checkCharBufferPos(cbuf, cpos, clim);
            carr[cpos++] = (char)b;
            ++i;
        }
        if (i == utf8LengthBytes) {
            cbuf.position(cpos - cbuf.arrayOffset());
            return;
        }
        Utf8.getCharsFromUtf8NonAsciiCharBuffer(cbuf, carr, cpos, clim, address + (long)i, address + (long)utf8LengthBytes, unsafeObj, cumBaseOffset);
    }

    private static void checkCharBufferPos(CharBuffer cbuf, int cpos, int clim) {
        if (cpos == clim) {
            cbuf.position(cpos - cbuf.arrayOffset());
            throw new BufferOverflowException();
        }
    }

    private static void getCharsFromUtf8NonAscii(Appendable dst, long address, long addressLimit, Object unsafeObj, long cumBaseOffset) throws IOException {
        while (address < addressLimit) {
            byte byte1;
            if (DecodeUtil.isOneByte(byte1 = UnsafeUtil.unsafe.getByte(unsafeObj, address++))) {
                byte b;
                dst.append((char)byte1);
                while (address < addressLimit && DecodeUtil.isOneByte(b = UnsafeUtil.unsafe.getByte(unsafeObj, address))) {
                    ++address;
                    dst.append((char)b);
                }
                continue;
            }
            if (DecodeUtil.isTwoBytes(byte1)) {
                if (address >= addressLimit) {
                    long off = address - cumBaseOffset;
                    long limit = addressLimit - cumBaseOffset;
                    throw Utf8CodingException.shortUtf8DecodeByteSequence(byte1, off, limit, 2);
                }
                DecodeUtil.handleTwoBytes(byte1, UnsafeUtil.unsafe.getByte(unsafeObj, address++), dst);
                continue;
            }
            if (DecodeUtil.isThreeBytes(byte1)) {
                if (address >= addressLimit - 1L) {
                    long off = address - cumBaseOffset;
                    long limit = addressLimit - cumBaseOffset;
                    throw Utf8CodingException.shortUtf8DecodeByteSequence(byte1, off, limit, 3);
                }
                DecodeUtil.handleThreeBytes(byte1, UnsafeUtil.unsafe.getByte(unsafeObj, address++), UnsafeUtil.unsafe.getByte(unsafeObj, address++), dst);
                continue;
            }
            if (address >= addressLimit - 2L) {
                long off = address - cumBaseOffset;
                long limit = addressLimit - cumBaseOffset;
                throw Utf8CodingException.shortUtf8DecodeByteSequence(byte1, off, limit, 4);
            }
            DecodeUtil.handleFourBytes(byte1, UnsafeUtil.unsafe.getByte(unsafeObj, address++), UnsafeUtil.unsafe.getByte(unsafeObj, address++), UnsafeUtil.unsafe.getByte(unsafeObj, address++), dst);
        }
    }

    private static void getCharsFromUtf8NonAsciiCharBuffer(CharBuffer cbuf, char[] carr, int cpos, int clim, long address, long addressLimit, Object unsafeObj, long cumBaseOffset) {
        while (address < addressLimit) {
            byte byte1;
            if (DecodeUtil.isOneByte(byte1 = UnsafeUtil.unsafe.getByte(unsafeObj, address++))) {
                byte b;
                Utf8.checkCharBufferPos(cbuf, cpos, clim);
                carr[cpos++] = (char)byte1;
                while (address < addressLimit && DecodeUtil.isOneByte(b = UnsafeUtil.unsafe.getByte(unsafeObj, address))) {
                    ++address;
                    Utf8.checkCharBufferPos(cbuf, cpos, clim);
                    carr[cpos++] = (char)b;
                }
                continue;
            }
            if (DecodeUtil.isTwoBytes(byte1)) {
                if (address >= addressLimit) {
                    cbuf.position(cpos - cbuf.arrayOffset());
                    long off = address - cumBaseOffset;
                    long limit = addressLimit - cumBaseOffset;
                    throw Utf8CodingException.shortUtf8DecodeByteSequence(byte1, off, limit, 2);
                }
                Utf8.checkCharBufferPos(cbuf, cpos, clim);
                DecodeUtil.handleTwoBytesCharBuffer(byte1, UnsafeUtil.unsafe.getByte(unsafeObj, address++), cbuf, carr, cpos);
                ++cpos;
                continue;
            }
            if (DecodeUtil.isThreeBytes(byte1)) {
                if (address >= addressLimit - 1L) {
                    cbuf.position(cpos - cbuf.arrayOffset());
                    long off = address - cumBaseOffset;
                    long limit = addressLimit - cumBaseOffset;
                    throw Utf8CodingException.shortUtf8DecodeByteSequence(byte1, off, limit, 3);
                }
                Utf8.checkCharBufferPos(cbuf, cpos, clim);
                DecodeUtil.handleThreeBytesCharBuffer(byte1, UnsafeUtil.unsafe.getByte(unsafeObj, address++), UnsafeUtil.unsafe.getByte(unsafeObj, address++), cbuf, carr, cpos);
                ++cpos;
                continue;
            }
            if (address >= addressLimit - 2L) {
                cbuf.position(cpos - cbuf.arrayOffset());
                long off = address - cumBaseOffset;
                long limit = addressLimit - cumBaseOffset;
                throw Utf8CodingException.shortUtf8DecodeByteSequence(byte1, off, limit, 4);
            }
            if (cpos >= clim - 1) {
                cbuf.position(cpos - cbuf.arrayOffset());
                throw new BufferOverflowException();
            }
            DecodeUtil.handleFourBytesCharBuffer(byte1, UnsafeUtil.unsafe.getByte(unsafeObj, address++), UnsafeUtil.unsafe.getByte(unsafeObj, address++), UnsafeUtil.unsafe.getByte(unsafeObj, address++), cbuf, carr, cpos);
            cpos += 2;
        }
        cbuf.position(cpos - cbuf.arrayOffset());
    }

    static long putCharsToUtf8(long offsetBytes, CharSequence src, ResourceState state) {
        char c;
        int i;
        assert (state.isValid());
        Object unsafeObj = state.getUnsafeObject();
        long cumBaseOffset = state.getCumBaseOffset();
        long j = cumBaseOffset + offsetBytes;
        long byteLimit = cumBaseOffset + state.getCapacity();
        int utf16Length = src.length();
        for (i = 0; i < utf16Length && (long)i + j < byteLimit && (c = src.charAt(i)) < '\u0080'; ++i) {
            UnsafeUtil.unsafe.putByte(unsafeObj, j + (long)i, (byte)c);
        }
        if (i == utf16Length) {
            return j + (long)utf16Length - cumBaseOffset;
        }
        j += (long)i;
        while (i < utf16Length) {
            char low;
            c = src.charAt(i);
            if (c < '\u0080' && j < byteLimit) {
                UnsafeUtil.unsafe.putByte(unsafeObj, j++, (byte)c);
            } else if (c < '\u0800' && j < byteLimit - 1L) {
                UnsafeUtil.unsafe.putByte(unsafeObj, j++, (byte)(0x3C0 | c >>> 6));
                UnsafeUtil.unsafe.putByte(unsafeObj, j++, (byte)(0x80 | 0x3F & c));
            } else if (!Character.isSurrogate(c) && j < byteLimit - 2L) {
                UnsafeUtil.unsafe.putByte(unsafeObj, j++, (byte)(0x1E0 | c >>> 12));
                UnsafeUtil.unsafe.putByte(unsafeObj, j++, (byte)(0x80 | 0x3F & c >>> 6));
                UnsafeUtil.unsafe.putByte(unsafeObj, j++, (byte)(0x80 | 0x3F & c));
            } else if (i <= utf16Length - 2 && j <= byteLimit - 4L && Character.isSurrogatePair(c, low = src.charAt(i + 1))) {
                ++i;
                int codePoint = Character.toCodePoint(c, low);
                UnsafeUtil.unsafe.putByte(unsafeObj, j++, (byte)(0xF0 | codePoint >>> 18));
                UnsafeUtil.unsafe.putByte(unsafeObj, j++, (byte)(0x80 | 0x3F & codePoint >>> 12));
                UnsafeUtil.unsafe.putByte(unsafeObj, j++, (byte)(0x80 | 0x3F & codePoint >>> 6));
                UnsafeUtil.unsafe.putByte(unsafeObj, j++, (byte)(0x80 | 0x3F & codePoint));
            } else {
                if (c < '\u0080' && j >= byteLimit || c < '\u0800' && j >= byteLimit - 1L || c < '\uffff' && j >= byteLimit - 2L) {
                    throw Utf8CodingException.outOfMemory();
                }
                if (i > utf16Length - 2) {
                    throw Utf8CodingException.unpairedSurrogate(c);
                }
                if (j > byteLimit - 4L) {
                    int remaining = (int)(j - byteLimit + 4L);
                    throw Utf8CodingException.shortUtf8EncodeByteLength(remaining);
                }
                if (!Character.isSurrogatePair(c, src.charAt(i + 1))) {
                    throw Utf8CodingException.illegalSurrogatePair(c, src.charAt(i + 1));
                }
                throw new IllegalArgumentException("Unknown Utf8 encoding exception");
            }
            ++i;
        }
        long localOffsetBytes = j - cumBaseOffset;
        return localOffsetBytes;
    }

    private static class DecodeUtil {
        private DecodeUtil() {
        }

        private static boolean isOneByte(byte b) {
            return b >= 0;
        }

        private static boolean isTwoBytes(byte b) {
            return b < -32;
        }

        private static boolean isThreeBytes(byte b) {
            return b < -16;
        }

        private static void handleTwoBytes(byte byte1, byte byte2, Appendable dst) throws IOException, Utf8CodingException {
            if (byte1 < -62 || DecodeUtil.isNotTrailingByte(byte2)) {
                byte[] out = new byte[]{byte1, byte2};
                throw Utf8CodingException.illegalUtf8DecodeByteSequence(out);
            }
            dst.append((char)((byte1 & 0x1F) << 6 | DecodeUtil.trailingByteValue(byte2)));
        }

        private static void handleTwoBytesCharBuffer(byte byte1, byte byte2, CharBuffer cb, char[] ca, int cp) throws Utf8CodingException {
            if (byte1 < -62 || DecodeUtil.isNotTrailingByte(byte2)) {
                byte[] out = new byte[]{byte1, byte2};
                cb.position(cp - cb.arrayOffset());
                throw Utf8CodingException.illegalUtf8DecodeByteSequence(out);
            }
            ca[cp] = (char)((byte1 & 0x1F) << 6 | DecodeUtil.trailingByteValue(byte2));
        }

        private static void handleThreeBytes(byte byte1, byte byte2, byte byte3, Appendable dst) throws IOException, Utf8CodingException {
            if (DecodeUtil.isNotTrailingByte(byte2) || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || DecodeUtil.isNotTrailingByte(byte3)) {
                byte[] out = new byte[]{byte1, byte2, byte3};
                throw Utf8CodingException.illegalUtf8DecodeByteSequence(out);
            }
            dst.append((char)((byte1 & 0xF) << 12 | DecodeUtil.trailingByteValue(byte2) << 6 | DecodeUtil.trailingByteValue(byte3)));
        }

        private static void handleThreeBytesCharBuffer(byte byte1, byte byte2, byte byte3, CharBuffer cb, char[] ca, int cp) throws Utf8CodingException {
            if (DecodeUtil.isNotTrailingByte(byte2) || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || DecodeUtil.isNotTrailingByte(byte3)) {
                cb.position(cp - cb.arrayOffset());
                byte[] out = new byte[]{byte1, byte2, byte3};
                throw Utf8CodingException.illegalUtf8DecodeByteSequence(out);
            }
            ca[cp] = (char)((byte1 & 0xF) << 12 | DecodeUtil.trailingByteValue(byte2) << 6 | DecodeUtil.trailingByteValue(byte3));
        }

        private static void handleFourBytes(byte byte1, byte byte2, byte byte3, byte byte4, Appendable dst) throws IOException, Utf8CodingException {
            if (DecodeUtil.isNotTrailingByte(byte2) || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || DecodeUtil.isNotTrailingByte(byte3) || DecodeUtil.isNotTrailingByte(byte4)) {
                byte[] out = new byte[]{byte1, byte2, byte3, byte4};
                throw Utf8CodingException.illegalUtf8DecodeByteSequence(out);
            }
            int codepoint = (byte1 & 7) << 18 | DecodeUtil.trailingByteValue(byte2) << 12 | DecodeUtil.trailingByteValue(byte3) << 6 | DecodeUtil.trailingByteValue(byte4);
            dst.append(DecodeUtil.highSurrogate(codepoint));
            dst.append(DecodeUtil.lowSurrogate(codepoint));
        }

        private static void handleFourBytesCharBuffer(byte byte1, byte byte2, byte byte3, byte byte4, CharBuffer cb, char[] ca, int cp) throws Utf8CodingException {
            if (DecodeUtil.isNotTrailingByte(byte2) || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || DecodeUtil.isNotTrailingByte(byte3) || DecodeUtil.isNotTrailingByte(byte4)) {
                cb.position(cp - cb.arrayOffset());
                byte[] out = new byte[]{byte1, byte2, byte3, byte4};
                throw Utf8CodingException.illegalUtf8DecodeByteSequence(out);
            }
            int codepoint = (byte1 & 7) << 18 | DecodeUtil.trailingByteValue(byte2) << 12 | DecodeUtil.trailingByteValue(byte3) << 6 | DecodeUtil.trailingByteValue(byte4);
            ca[cp] = DecodeUtil.highSurrogate(codepoint);
            ca[cp + 1] = DecodeUtil.lowSurrogate(codepoint);
        }

        private static boolean isNotTrailingByte(byte b) {
            return b > -65;
        }

        private static int trailingByteValue(byte b) {
            return b & 0x3F;
        }

        private static char highSurrogate(int codePoint) {
            return (char)(55232 + (codePoint >>> 10));
        }

        private static char lowSurrogate(int codePoint) {
            return (char)(56320 + (codePoint & 0x3FF));
        }
    }
}

