/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.Memory;
import com.yahoo.memory.UnsafeUtil;

final class Util {
    Util() {
    }

    public static long binarySearchLongs(Memory mem, long fromLongIndex, long toLongIndex, long key) {
        UnsafeUtil.assertBounds(fromLongIndex << 3, toLongIndex - fromLongIndex << 3, mem.getCapacity());
        long low = fromLongIndex;
        long high = toLongIndex - 1L;
        while (low <= high) {
            long mid = low + high >>> 1;
            long midVal = mem.getLong(mid << 3);
            if (midVal < key) {
                low = mid + 1L;
                continue;
            }
            if (midVal > key) {
                high = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(low + 1L);
    }

    public static final String zeroPad(String s, int fieldLength) {
        return Util.characterPad(s, fieldLength, '0', false);
    }

    public static final String characterPad(String s, int fieldLength, char padChar, boolean postpend) {
        char[] chArr = s.toCharArray();
        int sLen = chArr.length;
        if (sLen < fieldLength) {
            char[] out = new char[fieldLength];
            int blanks = fieldLength - sLen;
            if (postpend) {
                int i;
                for (i = 0; i < sLen; ++i) {
                    out[i] = chArr[i];
                }
                for (i = sLen; i < fieldLength; ++i) {
                    out[i] = padChar;
                }
            } else {
                int i;
                for (i = 0; i < blanks; ++i) {
                    out[i] = padChar;
                }
                for (i = blanks; i < fieldLength; ++i) {
                    out[i] = chArr[i - blanks];
                }
            }
            return String.valueOf(out);
        }
        return s;
    }

    public static final boolean isAllBitsClear(long value, long bitMask) {
        return ((value ^ 0xFFFFFFFFFFFFFFFFL) & bitMask) == bitMask;
    }

    public static final boolean isAllBitsSet(long value, long bitMask) {
        return (value & bitMask) == bitMask;
    }

    public static final boolean isAnyBitsClear(long value, long bitMask) {
        return ((value ^ 0xFFFFFFFFFFFFFFFFL) & bitMask) != 0L;
    }

    public static final boolean isAnyBitsSet(long value, long bitMask) {
        return (value & bitMask) != 0L;
    }
}

