/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.ResourceState;

class BaseBuffer {
    private final long cap;
    private long start = 0L;
    private long pos = 0L;
    private long end;

    BaseBuffer(ResourceState state) {
        this.end = this.cap = state.getCapacity();
        state.putBaseBuffer(this);
    }

    public final BaseBuffer setStartPositionEnd(long start, long position, long end) {
        BaseBuffer.assertInvariants(start, position, end, this.cap);
        this.start = start;
        this.end = end;
        this.pos = position;
        return this;
    }

    public long getStart() {
        return this.start;
    }

    public long getPosition() {
        return this.pos;
    }

    public long getEnd() {
        return this.end;
    }

    public BaseBuffer setPosition(long position) {
        BaseBuffer.assertInvariants(this.start, position, this.end, this.cap);
        this.pos = position;
        return this;
    }

    public BaseBuffer incrementPosition(long increment) {
        BaseBuffer.assertInvariants(this.start, this.pos + increment, this.end, this.cap);
        this.pos += increment;
        return this;
    }

    public BaseBuffer resetPosition() {
        this.pos = this.start;
        return this;
    }

    public long getRemaining() {
        return this.end - this.pos;
    }

    public boolean hasRemaining() {
        return this.end - this.pos > 0L;
    }

    static final void assertInvariants(long start, long pos, long end, long cap) {
        assert ((start | pos | end | cap | pos - start | end - pos | cap - end) >= 0L) : "Violation of Invariants: start: " + start + " <= pos: " + pos + " <= end: " + end + " <= cap: " + cap + "; (pos - start): " + (pos - start) + ", (end - pos): " + (end - pos) + ", (cap - end): " + (cap - end);
    }
}

