/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.Buffer;
import com.yahoo.memory.Memory;
import com.yahoo.memory.ResourceState;
import com.yahoo.memory.UnsafeUtil;
import com.yahoo.memory.WritableBuffer;
import com.yahoo.memory.WritableMemory;
import com.yahoo.memory.WritableMemoryImpl;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class WritableBufferImpl
extends WritableBuffer {
    final ResourceState state;
    final Object unsafeObj;
    final long unsafeObjHeader;
    final long capacity;
    final long cumBaseOffset;

    WritableBufferImpl(ResourceState state) {
        super(state);
        this.state = state;
        this.unsafeObj = state.getUnsafeObject();
        this.unsafeObjHeader = state.getUnsafeObjectHeader();
        this.capacity = state.getCapacity();
        this.cumBaseOffset = state.getCumBaseOffset();
    }

    @Override
    public Buffer duplicate() {
        return this.regOrDup(0L, this.capacity, true);
    }

    @Override
    public WritableBuffer writableDuplicate() {
        return this.regOrDup(0L, this.capacity, true);
    }

    @Override
    public Buffer region() {
        return this.regOrDup(this.getPosition(), this.getEnd() - this.getPosition(), false);
    }

    @Override
    public WritableBuffer writableRegion() {
        return this.regOrDup(this.getPosition(), this.getEnd() - this.getPosition(), false);
    }

    @Override
    public WritableBuffer writableRegion(long offsetBytes, long capacityBytes) {
        return this.regOrDup(offsetBytes, capacityBytes, false);
    }

    private WritableBuffer regOrDup(long offsetBytes, long capacityBytes, boolean dup) {
        this.checkValid();
        assert (offsetBytes + capacityBytes <= this.capacity) : "newOff + newCap: " + (offsetBytes + capacityBytes) + ", origCap: " + this.capacity;
        ResourceState newState = this.state.copy();
        newState.putRegionOffset(newState.getRegionOffset() + offsetBytes);
        newState.putCapacity(capacityBytes);
        if (!dup) {
            newState.putBaseBuffer(null);
        }
        return new WritableBufferImpl(newState);
    }

    @Override
    public Memory asMemory() {
        this.checkValid();
        return new WritableMemoryImpl(this.state.copy());
    }

    @Override
    public WritableMemory asWritableMemory() {
        this.checkValid();
        return new WritableMemoryImpl(this.state.copy());
    }

    @Override
    public boolean getBoolean() {
        this.checkValid();
        long pos = this.getPosition();
        UnsafeUtil.assertBounds(pos, UnsafeUtil.ARRAY_BOOLEAN_INDEX_SCALE, this.capacity);
        boolean ret = UnsafeUtil.unsafe.getBoolean(this.unsafeObj, this.cumBaseOffset + pos);
        this.incrementPosition(UnsafeUtil.ARRAY_BOOLEAN_INDEX_SCALE);
        return ret;
    }

    @Override
    public void getBooleanArray(boolean[] dstArray, int dstOffset, int length) {
        this.checkValid();
        long pos = this.getPosition();
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(pos, copyBytes, this.capacity);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.unsafeObj, this.cumBaseOffset + pos, dstArray, UnsafeUtil.ARRAY_BOOLEAN_BASE_OFFSET + (dstOffset << 0), copyBytes);
        this.incrementPosition(copyBytes);
    }

    @Override
    public byte getByte() {
        this.checkValid();
        long pos = this.getPosition();
        UnsafeUtil.assertBounds(pos, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacity);
        byte ret = UnsafeUtil.unsafe.getByte(this.unsafeObj, this.cumBaseOffset + pos);
        this.incrementPosition(UnsafeUtil.ARRAY_BYTE_INDEX_SCALE);
        return ret;
    }

    @Override
    public void getByteArray(byte[] dstArray, int dstOffset, int length) {
        this.checkValid();
        long pos = this.getPosition();
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(pos, copyBytes, this.capacity);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.unsafeObj, this.cumBaseOffset + pos, dstArray, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + (dstOffset << 0), copyBytes);
        this.incrementPosition(copyBytes);
    }

    @Override
    public char getChar() {
        this.checkValid();
        long pos = this.getPosition();
        UnsafeUtil.assertBounds(pos, UnsafeUtil.ARRAY_CHAR_INDEX_SCALE, this.capacity);
        char ret = UnsafeUtil.unsafe.getChar(this.unsafeObj, this.cumBaseOffset + pos);
        this.incrementPosition(UnsafeUtil.ARRAY_CHAR_INDEX_SCALE);
        return ret;
    }

    @Override
    public void getCharArray(char[] dstArray, int dstOffset, int length) {
        this.checkValid();
        long pos = this.getPosition();
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(pos, copyBytes, this.capacity);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.unsafeObj, this.cumBaseOffset + pos, dstArray, UnsafeUtil.ARRAY_CHAR_BASE_OFFSET + (dstOffset << 1), copyBytes);
        this.incrementPosition(copyBytes);
    }

    @Override
    public double getDouble() {
        this.checkValid();
        long pos = this.getPosition();
        UnsafeUtil.assertBounds(pos, UnsafeUtil.ARRAY_DOUBLE_INDEX_SCALE, this.capacity);
        double ret = UnsafeUtil.unsafe.getDouble(this.unsafeObj, this.cumBaseOffset + pos);
        this.incrementPosition(UnsafeUtil.ARRAY_DOUBLE_INDEX_SCALE);
        return ret;
    }

    @Override
    public void getDoubleArray(double[] dstArray, int dstOffset, int length) {
        this.checkValid();
        long pos = this.getPosition();
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(pos, copyBytes, this.capacity);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.unsafeObj, this.cumBaseOffset + pos, dstArray, UnsafeUtil.ARRAY_DOUBLE_BASE_OFFSET + (dstOffset << 3), copyBytes);
        this.incrementPosition(copyBytes);
    }

    @Override
    public float getFloat() {
        this.checkValid();
        long pos = this.getPosition();
        UnsafeUtil.assertBounds(pos, UnsafeUtil.ARRAY_FLOAT_INDEX_SCALE, this.capacity);
        float ret = UnsafeUtil.unsafe.getFloat(this.unsafeObj, this.cumBaseOffset + pos);
        this.incrementPosition(UnsafeUtil.ARRAY_FLOAT_INDEX_SCALE);
        return ret;
    }

    @Override
    public void getFloatArray(float[] dstArray, int dstOffset, int length) {
        this.checkValid();
        long pos = this.getPosition();
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(pos, copyBytes, this.capacity);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.unsafeObj, this.cumBaseOffset + pos, dstArray, UnsafeUtil.ARRAY_FLOAT_BASE_OFFSET + (dstOffset << 2), copyBytes);
        this.incrementPosition(copyBytes);
    }

    @Override
    public int getInt() {
        this.checkValid();
        long pos = this.getPosition();
        UnsafeUtil.assertBounds(pos, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacity);
        int ret = UnsafeUtil.unsafe.getInt(this.unsafeObj, this.cumBaseOffset + pos);
        this.incrementPosition(UnsafeUtil.ARRAY_INT_INDEX_SCALE);
        return ret;
    }

    @Override
    public void getIntArray(int[] dstArray, int dstOffset, int length) {
        this.checkValid();
        long pos = this.getPosition();
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(pos, copyBytes, this.capacity);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.unsafeObj, this.cumBaseOffset + pos, dstArray, UnsafeUtil.ARRAY_INT_BASE_OFFSET + (dstOffset << 2), copyBytes);
        this.incrementPosition(copyBytes);
    }

    @Override
    public long getLong() {
        this.checkValid();
        long pos = this.getPosition();
        UnsafeUtil.assertBounds(pos, UnsafeUtil.ARRAY_LONG_INDEX_SCALE, this.capacity);
        long ret = UnsafeUtil.unsafe.getLong(this.unsafeObj, this.cumBaseOffset + pos);
        this.incrementPosition(UnsafeUtil.ARRAY_LONG_INDEX_SCALE);
        return ret;
    }

    @Override
    public void getLongArray(long[] dstArray, int dstOffset, int length) {
        this.checkValid();
        long pos = this.getPosition();
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(pos, copyBytes, this.capacity);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.unsafeObj, this.cumBaseOffset + pos, dstArray, UnsafeUtil.ARRAY_LONG_BASE_OFFSET + (dstOffset << 3), copyBytes);
        this.incrementPosition(copyBytes);
    }

    @Override
    public short getShort() {
        this.checkValid();
        long pos = this.getPosition();
        UnsafeUtil.assertBounds(pos, UnsafeUtil.ARRAY_SHORT_INDEX_SCALE, this.capacity);
        short ret = UnsafeUtil.unsafe.getShort(this.unsafeObj, this.cumBaseOffset + pos);
        this.incrementPosition(UnsafeUtil.ARRAY_SHORT_INDEX_SCALE);
        return ret;
    }

    @Override
    public void getShortArray(short[] dstArray, int dstOffset, int length) {
        this.checkValid();
        long pos = this.getPosition();
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(pos, copyBytes, this.capacity);
        UnsafeUtil.assertBounds(dstOffset, length, dstArray.length);
        UnsafeUtil.unsafe.copyMemory(this.unsafeObj, this.cumBaseOffset + pos, dstArray, UnsafeUtil.ARRAY_SHORT_BASE_OFFSET + (dstOffset << 1), copyBytes);
        this.incrementPosition(copyBytes);
    }

    @Override
    public int compareTo(long thisOffsetBytes, long thisLengthBytes, Buffer that, long thatOffsetBytes, long thatLengthBytes) {
        this.checkValid();
        ((WritableBufferImpl)that).checkValid();
        UnsafeUtil.assertBounds(thisOffsetBytes, thisLengthBytes, this.capacity);
        UnsafeUtil.assertBounds(thatOffsetBytes, thatLengthBytes, that.getCapacity());
        long thisAdd = this.getCumulativeOffset() + thisOffsetBytes;
        long thatAdd = that.getCumulativeOffset() + thatOffsetBytes;
        Object thisObj = this.isDirect() ? null : this.unsafeObj;
        Object thatObj = that.isDirect() ? null : ((WritableBuffer)that).getArray();
        long lenBytes = Math.min(thisLengthBytes, thatLengthBytes);
        for (long i = 0L; i < lenBytes; ++i) {
            byte thatByte;
            byte thisByte = UnsafeUtil.unsafe.getByte(thisObj, thisAdd + i);
            if (thisByte < (thatByte = UnsafeUtil.unsafe.getByte(thatObj, thatAdd + i))) {
                return -1;
            }
            if (thisByte <= thatByte) continue;
            return 1;
        }
        if (thisLengthBytes < thatLengthBytes) {
            return -1;
        }
        if (thisLengthBytes > thatLengthBytes) {
            return 1;
        }
        return 0;
    }

    @Override
    public long getCapacity() {
        this.checkValid();
        return this.capacity;
    }

    @Override
    public long getCumulativeOffset() {
        this.checkValid();
        return this.cumBaseOffset;
    }

    @Override
    public ByteOrder getResourceOrder() {
        this.checkValid();
        return this.state.order();
    }

    @Override
    public boolean hasArray() {
        this.checkValid();
        return this.unsafeObj != null;
    }

    @Override
    public boolean hasByteBuffer() {
        this.checkValid();
        return this.state.getByteBuffer() != null;
    }

    @Override
    public boolean isDirect() {
        this.checkValid();
        return this.state.isDirect();
    }

    @Override
    public boolean isResourceReadOnly() {
        this.checkValid();
        return this.state.isResourceReadOnly();
    }

    @Override
    public boolean isValid() {
        return this.state.isValid();
    }

    @Override
    public boolean swapBytes() {
        return this.state.isSwapBytes();
    }

    @Override
    public String toHexString(String header, long offsetBytes, int lengthBytes) {
        this.checkValid();
        String klass = this.getClass().getSimpleName();
        String s1 = String.format("(..., %d, %d)", offsetBytes, lengthBytes);
        long hcode = (long)this.hashCode() & 0xFFFFFFFFL;
        String call = ".toHexString" + s1 + ", hashCode: " + hcode;
        StringBuilder sb = new StringBuilder();
        sb.append("### ").append(klass).append(" SUMMARY ###").append(UnsafeUtil.LS);
        sb.append("Header Comment      : ").append(header).append(UnsafeUtil.LS);
        sb.append("Call Parameters     : ").append(call);
        return Memory.toHex(sb.toString(), offsetBytes, lengthBytes, this.state);
    }

    @Override
    public void putBoolean(boolean value) {
        this.checkValid();
        long pos = this.getPosition();
        UnsafeUtil.assertBounds(pos, UnsafeUtil.ARRAY_BOOLEAN_INDEX_SCALE, this.capacity);
        UnsafeUtil.unsafe.putBoolean(this.unsafeObj, this.cumBaseOffset + pos, value);
        this.incrementPosition(UnsafeUtil.ARRAY_BOOLEAN_INDEX_SCALE);
    }

    @Override
    public void putBooleanArray(boolean[] srcArray, int srcOffset, int length) {
        this.checkValid();
        long pos = this.getPosition();
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(pos, copyBytes, this.capacity);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_BOOLEAN_BASE_OFFSET + (srcOffset << 0), this.unsafeObj, this.cumBaseOffset + pos, copyBytes);
        this.incrementPosition(copyBytes);
    }

    @Override
    public void putByte(byte value) {
        this.checkValid();
        long pos = this.getPosition();
        UnsafeUtil.assertBounds(pos, UnsafeUtil.ARRAY_BYTE_INDEX_SCALE, this.capacity);
        UnsafeUtil.unsafe.putByte(this.unsafeObj, this.cumBaseOffset + pos, value);
        this.incrementPosition(UnsafeUtil.ARRAY_BYTE_INDEX_SCALE);
    }

    @Override
    public void putByteArray(byte[] srcArray, int srcOffset, int length) {
        this.checkValid();
        long pos = this.getPosition();
        long copyBytes = length << 0;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(pos, copyBytes, this.capacity);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + (srcOffset << 0), this.unsafeObj, this.cumBaseOffset + pos, copyBytes);
        this.incrementPosition(copyBytes);
    }

    @Override
    public void putChar(char value) {
        this.checkValid();
        long pos = this.getPosition();
        UnsafeUtil.assertBounds(pos, UnsafeUtil.ARRAY_CHAR_INDEX_SCALE, this.capacity);
        UnsafeUtil.unsafe.putChar(this.unsafeObj, this.cumBaseOffset + pos, value);
        this.incrementPosition(UnsafeUtil.ARRAY_CHAR_INDEX_SCALE);
    }

    @Override
    public void putCharArray(char[] srcArray, int srcOffset, int length) {
        this.checkValid();
        long pos = this.getPosition();
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(pos, copyBytes, this.capacity);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_CHAR_BASE_OFFSET + (srcOffset << 1), this.unsafeObj, this.cumBaseOffset + pos, copyBytes);
        this.incrementPosition(copyBytes);
    }

    @Override
    public void putDouble(double value) {
        this.checkValid();
        long pos = this.getPosition();
        UnsafeUtil.assertBounds(pos, UnsafeUtil.ARRAY_DOUBLE_INDEX_SCALE, this.capacity);
        UnsafeUtil.unsafe.putDouble(this.unsafeObj, this.cumBaseOffset + pos, value);
        this.incrementPosition(UnsafeUtil.ARRAY_DOUBLE_INDEX_SCALE);
    }

    @Override
    public void putDoubleArray(double[] srcArray, int srcOffset, int length) {
        this.checkValid();
        long pos = this.getPosition();
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(pos, copyBytes, this.capacity);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_DOUBLE_BASE_OFFSET + (srcOffset << 3), this.unsafeObj, this.cumBaseOffset + pos, copyBytes);
        this.incrementPosition(copyBytes);
    }

    @Override
    public void putFloat(float value) {
        this.checkValid();
        long pos = this.getPosition();
        UnsafeUtil.assertBounds(pos, UnsafeUtil.ARRAY_FLOAT_INDEX_SCALE, this.capacity);
        UnsafeUtil.unsafe.putFloat(this.unsafeObj, this.cumBaseOffset + pos, value);
        this.incrementPosition(UnsafeUtil.ARRAY_FLOAT_INDEX_SCALE);
    }

    @Override
    public void putFloatArray(float[] srcArray, int srcOffset, int length) {
        this.checkValid();
        long pos = this.getPosition();
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(pos, copyBytes, this.capacity);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_FLOAT_BASE_OFFSET + (srcOffset << 2), this.unsafeObj, this.cumBaseOffset + pos, copyBytes);
        this.incrementPosition(copyBytes);
    }

    @Override
    public void putInt(int value) {
        this.checkValid();
        long pos = this.getPosition();
        UnsafeUtil.assertBounds(pos, UnsafeUtil.ARRAY_INT_INDEX_SCALE, this.capacity);
        UnsafeUtil.unsafe.putInt(this.unsafeObj, this.cumBaseOffset + pos, value);
        this.incrementPosition(UnsafeUtil.ARRAY_INT_INDEX_SCALE);
    }

    @Override
    public void putIntArray(int[] srcArray, int srcOffset, int length) {
        this.checkValid();
        long pos = this.getPosition();
        long copyBytes = length << 2;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(pos, copyBytes, this.capacity);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_INT_BASE_OFFSET + (srcOffset << 2), this.unsafeObj, this.cumBaseOffset + pos, copyBytes);
        this.incrementPosition(copyBytes);
    }

    @Override
    public void putLong(long value) {
        this.checkValid();
        long pos = this.getPosition();
        UnsafeUtil.assertBounds(pos, UnsafeUtil.ARRAY_LONG_INDEX_SCALE, this.capacity);
        UnsafeUtil.unsafe.putLong(this.unsafeObj, this.cumBaseOffset + pos, value);
        this.incrementPosition(UnsafeUtil.ARRAY_LONG_INDEX_SCALE);
    }

    @Override
    public void putLongArray(long[] srcArray, int srcOffset, int length) {
        this.checkValid();
        long pos = this.getPosition();
        long copyBytes = length << 3;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(pos, copyBytes, this.capacity);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_LONG_BASE_OFFSET + (srcOffset << 3), this.unsafeObj, this.cumBaseOffset + pos, copyBytes);
        this.incrementPosition(copyBytes);
    }

    @Override
    public void putShort(short value) {
        this.checkValid();
        long pos = this.getPosition();
        UnsafeUtil.assertBounds(pos, UnsafeUtil.ARRAY_SHORT_INDEX_SCALE, this.capacity);
        UnsafeUtil.unsafe.putShort(this.unsafeObj, this.cumBaseOffset + pos, value);
        this.incrementPosition(UnsafeUtil.ARRAY_SHORT_INDEX_SCALE);
    }

    @Override
    public void putShortArray(short[] srcArray, int srcOffset, int length) {
        this.checkValid();
        long pos = this.getPosition();
        long copyBytes = length << 1;
        UnsafeUtil.assertBounds(srcOffset, length, srcArray.length);
        UnsafeUtil.assertBounds(pos, copyBytes, this.capacity);
        UnsafeUtil.unsafe.copyMemory(srcArray, UnsafeUtil.ARRAY_SHORT_BASE_OFFSET + (srcOffset << 1), this.unsafeObj, this.cumBaseOffset + pos, copyBytes);
        this.incrementPosition(copyBytes);
    }

    @Override
    public Object getArray() {
        this.checkValid();
        return this.unsafeObj;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        this.checkValid();
        return this.state.getByteBuffer();
    }

    @Override
    public void clear() {
        this.fill((byte)0);
    }

    @Override
    public void fill(byte value) {
        this.checkValid();
        long pos = this.getPosition();
        long len = this.getEnd() - pos;
        UnsafeUtil.assertBounds(pos, len, this.capacity);
        UnsafeUtil.unsafe.setMemory(this.unsafeObj, this.cumBaseOffset + pos, len, value);
    }

    private final void checkValid() {
        assert (this.state.isValid()) : "Memory not valid.";
    }
}

