/*
 * Decompiled with CFR 0.152.
 */
package com.xwray.groupie;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListUpdateCallback;
import com.xwray.groupie.DiffCallback;
import com.xwray.groupie.Group;
import com.xwray.groupie.GroupUtils;
import com.xwray.groupie.NestedGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Section
extends NestedGroup {
    @Nullable
    private Group header;
    @Nullable
    private Group footer;
    @Nullable
    private Group placeholder;
    private final ArrayList<Group> children = new ArrayList();
    private boolean hideWhenEmpty = false;
    private boolean isHeaderAndFooterVisible = true;
    private boolean isPlaceholderVisible = false;
    private ListUpdateCallback listUpdateCallback = new ListUpdateCallback(){

        public void onInserted(int position, int count) {
            Section.this.notifyItemRangeInserted(Section.this.getHeaderItemCount() + position, count);
        }

        public void onRemoved(int position, int count) {
            Section.this.notifyItemRangeRemoved(Section.this.getHeaderItemCount() + position, count);
        }

        public void onMoved(int fromPosition, int toPosition) {
            int headerItemCount = Section.this.getHeaderItemCount();
            Section.this.notifyItemMoved(headerItemCount + fromPosition, headerItemCount + toPosition);
        }

        public void onChanged(int position, int count, Object payload) {
            Section.this.notifyItemRangeChanged(Section.this.getHeaderItemCount() + position, count, payload);
        }
    };

    public Section() {
        this(null, new ArrayList());
    }

    public Section(@Nullable Group header) {
        this(header, new ArrayList());
    }

    public Section(@NonNull Collection<? extends Group> children) {
        this(null, children);
    }

    public Section(@Nullable Group header, @NonNull Collection<? extends Group> children) {
        this.header = header;
        if (header != null) {
            header.registerGroupDataObserver(this);
        }
        this.addAll(children);
    }

    @Override
    public void add(int position, @NonNull Group group) {
        super.add(position, group);
        this.children.add(position, group);
        int notifyPosition = this.getHeaderItemCount() + GroupUtils.getItemCount(this.children.subList(0, position));
        this.notifyItemRangeInserted(notifyPosition, group.getItemCount());
        this.refreshEmptyState();
    }

    @Override
    public void addAll(@NonNull Collection<? extends Group> groups) {
        if (groups.isEmpty()) {
            return;
        }
        super.addAll(groups);
        int position = this.getItemCountWithoutFooter();
        this.children.addAll(groups);
        this.notifyItemRangeInserted(position, GroupUtils.getItemCount(groups));
        this.refreshEmptyState();
    }

    @Override
    public void addAll(int position, @NonNull Collection<? extends Group> groups) {
        if (groups.isEmpty()) {
            return;
        }
        super.addAll(position, groups);
        this.children.addAll(position, groups);
        int notifyPosition = this.getHeaderItemCount() + GroupUtils.getItemCount(this.children.subList(0, position));
        this.notifyItemRangeInserted(notifyPosition, GroupUtils.getItemCount(groups));
        this.refreshEmptyState();
    }

    @Override
    public void add(@NonNull Group group) {
        super.add(group);
        int position = this.getItemCountWithoutFooter();
        this.children.add(group);
        this.notifyItemRangeInserted(position, group.getItemCount());
        this.refreshEmptyState();
    }

    @Override
    public void remove(@NonNull Group group) {
        super.remove(group);
        int position = this.getItemCountBeforeGroup(group);
        this.children.remove(group);
        this.notifyItemRangeRemoved(position, group.getItemCount());
        this.refreshEmptyState();
    }

    @Override
    public void removeAll(@NonNull Collection<? extends Group> groups) {
        if (groups.isEmpty()) {
            return;
        }
        super.removeAll(groups);
        for (Group group : groups) {
            int position = this.getItemCountBeforeGroup(group);
            this.children.remove(group);
            this.notifyItemRangeRemoved(position, group.getItemCount());
        }
        this.refreshEmptyState();
    }

    public List<Group> getGroups() {
        return new ArrayList<Group>(this.children);
    }

    public void clear() {
        if (this.children.isEmpty()) {
            return;
        }
        this.removeAll(new ArrayList<Group>(this.children));
    }

    public void update(@NonNull Collection<? extends Group> newBodyGroups) {
        this.update(newBodyGroups, true);
    }

    public void update(@NonNull Collection<? extends Group> newBodyGroups, boolean detectMoves) {
        ArrayList<Group> oldBodyGroups = new ArrayList<Group>(this.children);
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new DiffCallback(oldBodyGroups, newBodyGroups), (boolean)detectMoves);
        this.update(newBodyGroups, diffResult);
    }

    public void update(@NonNull Collection<? extends Group> newBodyGroups, DiffUtil.DiffResult diffResult) {
        super.removeAll(this.children);
        this.children.clear();
        this.children.addAll(newBodyGroups);
        super.addAll(newBodyGroups);
        diffResult.dispatchUpdatesTo(this.listUpdateCallback);
        this.refreshEmptyState();
    }

    public void setPlaceholder(@NonNull Group placeholder) {
        if (placeholder == null) {
            throw new NullPointerException("Placeholder can't be null.  Please use removePlaceholder() instead!");
        }
        if (this.placeholder != null) {
            this.removePlaceholder();
        }
        this.placeholder = placeholder;
        this.refreshEmptyState();
    }

    public void removePlaceholder() {
        this.hidePlaceholder();
        this.placeholder = null;
    }

    private void showPlaceholder() {
        if (this.isPlaceholderVisible || this.placeholder == null) {
            return;
        }
        this.isPlaceholderVisible = true;
        this.notifyItemRangeInserted(this.getHeaderItemCount(), this.placeholder.getItemCount());
    }

    private void hidePlaceholder() {
        if (!this.isPlaceholderVisible || this.placeholder == null) {
            return;
        }
        this.isPlaceholderVisible = false;
        this.notifyItemRangeRemoved(this.getHeaderItemCount(), this.placeholder.getItemCount());
    }

    protected boolean isEmpty() {
        return this.children.isEmpty() || GroupUtils.getItemCount(this.children) == 0;
    }

    private void hideDecorations() {
        if (!this.isHeaderAndFooterVisible && !this.isPlaceholderVisible) {
            return;
        }
        int count = this.getHeaderItemCount() + this.getPlaceholderItemCount() + this.getFooterItemCount();
        this.isHeaderAndFooterVisible = false;
        this.isPlaceholderVisible = false;
        this.notifyItemRangeRemoved(0, count);
    }

    protected void refreshEmptyState() {
        boolean isEmpty = this.isEmpty();
        if (isEmpty) {
            if (this.hideWhenEmpty) {
                this.hideDecorations();
            } else {
                this.showPlaceholder();
                this.showHeadersAndFooters();
            }
        } else {
            this.hidePlaceholder();
            this.showHeadersAndFooters();
        }
    }

    private void showHeadersAndFooters() {
        if (this.isHeaderAndFooterVisible) {
            return;
        }
        this.isHeaderAndFooterVisible = true;
        this.notifyItemRangeInserted(0, this.getHeaderItemCount());
        this.notifyItemRangeInserted(this.getItemCountWithoutFooter(), this.getFooterItemCount());
    }

    private int getBodyItemCount() {
        return this.isPlaceholderVisible ? this.getPlaceholderItemCount() : GroupUtils.getItemCount(this.children);
    }

    private int getItemCountWithoutFooter() {
        return this.getBodyItemCount() + this.getHeaderItemCount();
    }

    private int getHeaderCount() {
        return this.header == null || !this.isHeaderAndFooterVisible ? 0 : 1;
    }

    private int getHeaderItemCount() {
        return this.getHeaderCount() == 0 ? 0 : this.header.getItemCount();
    }

    private int getFooterItemCount() {
        return this.getFooterCount() == 0 ? 0 : this.footer.getItemCount();
    }

    private int getFooterCount() {
        return this.footer == null || !this.isHeaderAndFooterVisible ? 0 : 1;
    }

    private int getPlaceholderCount() {
        return this.isPlaceholderVisible ? 1 : 0;
    }

    @Override
    @NonNull
    public Group getGroup(int position) {
        if (this.isHeaderShown() && position == 0) {
            return this.header;
        }
        if (this.isPlaceholderShown() && (position -= this.getHeaderCount()) == 0) {
            return this.placeholder;
        }
        if ((position -= this.getPlaceholderCount()) == this.children.size()) {
            if (this.isFooterShown()) {
                return this.footer;
            }
            throw new IndexOutOfBoundsException("Wanted group at position " + position + " but there are only " + this.getGroupCount() + " groups");
        }
        return this.children.get(position);
    }

    @Override
    public int getGroupCount() {
        return this.getHeaderCount() + this.getFooterCount() + this.getPlaceholderCount() + this.children.size();
    }

    @Override
    public int getPosition(@NonNull Group group) {
        int count = 0;
        if (this.isHeaderShown() && group == this.header) {
            return count;
        }
        count += this.getHeaderCount();
        if (this.isPlaceholderShown() && group == this.placeholder) {
            return count;
        }
        count += this.getPlaceholderCount();
        int index = this.children.indexOf(group);
        if (index >= 0) {
            return count + index;
        }
        count += this.children.size();
        if (this.isFooterShown() && this.footer == group) {
            return count;
        }
        return -1;
    }

    private boolean isHeaderShown() {
        return this.getHeaderCount() > 0;
    }

    private boolean isFooterShown() {
        return this.getFooterCount() > 0;
    }

    private boolean isPlaceholderShown() {
        return this.getPlaceholderCount() > 0;
    }

    public void setHeader(@NonNull Group header) {
        if (header == null) {
            throw new NullPointerException("Header can't be null.  Please use removeHeader() instead!");
        }
        if (this.header != null) {
            this.header.unregisterGroupDataObserver(this);
        }
        int previousHeaderItemCount = this.getHeaderItemCount();
        this.header = header;
        header.registerGroupDataObserver(this);
        this.notifyHeaderItemsChanged(previousHeaderItemCount);
    }

    public void removeHeader() {
        if (this.header == null) {
            return;
        }
        this.header.unregisterGroupDataObserver(this);
        int previousHeaderItemCount = this.getHeaderItemCount();
        this.header = null;
        this.notifyHeaderItemsChanged(previousHeaderItemCount);
    }

    private void notifyHeaderItemsChanged(int previousHeaderItemCount) {
        int newHeaderItemCount = this.getHeaderItemCount();
        if (previousHeaderItemCount > 0) {
            this.notifyItemRangeRemoved(0, previousHeaderItemCount);
        }
        if (newHeaderItemCount > 0) {
            this.notifyItemRangeInserted(0, newHeaderItemCount);
        }
    }

    public void setFooter(@NonNull Group footer) {
        if (footer == null) {
            throw new NullPointerException("Footer can't be null.  Please use removeFooter() instead!");
        }
        if (this.footer != null) {
            this.footer.unregisterGroupDataObserver(this);
        }
        int previousFooterItemCount = this.getFooterItemCount();
        this.footer = footer;
        footer.registerGroupDataObserver(this);
        this.notifyFooterItemsChanged(previousFooterItemCount);
    }

    public void removeFooter() {
        if (this.footer == null) {
            return;
        }
        this.footer.unregisterGroupDataObserver(this);
        int previousFooterItemCount = this.getFooterItemCount();
        this.footer = null;
        this.notifyFooterItemsChanged(previousFooterItemCount);
    }

    private void notifyFooterItemsChanged(int previousFooterItemCount) {
        int newFooterItemCount = this.getFooterItemCount();
        if (previousFooterItemCount > 0) {
            this.notifyItemRangeRemoved(this.getItemCountWithoutFooter(), previousFooterItemCount);
        }
        if (newFooterItemCount > 0) {
            this.notifyItemRangeInserted(this.getItemCountWithoutFooter(), newFooterItemCount);
        }
    }

    public void setHideWhenEmpty(boolean hide) {
        if (this.hideWhenEmpty == hide) {
            return;
        }
        this.hideWhenEmpty = hide;
        this.refreshEmptyState();
    }

    @Override
    public void onItemInserted(@NonNull Group group, int position) {
        super.onItemInserted(group, position);
        this.refreshEmptyState();
    }

    @Override
    public void onItemRemoved(@NonNull Group group, int position) {
        super.onItemRemoved(group, position);
        this.refreshEmptyState();
    }

    @Override
    public void onItemRangeInserted(@NonNull Group group, int positionStart, int itemCount) {
        super.onItemRangeInserted(group, positionStart, itemCount);
        this.refreshEmptyState();
    }

    @Override
    public void onItemRangeRemoved(@NonNull Group group, int positionStart, int itemCount) {
        super.onItemRangeRemoved(group, positionStart, itemCount);
        this.refreshEmptyState();
    }

    private int getPlaceholderItemCount() {
        if (this.isPlaceholderVisible && this.placeholder != null) {
            return this.placeholder.getItemCount();
        }
        return 0;
    }
}

