/*
 * Decompiled with CFR 0.152.
 */
package com.xwray.groupie;

import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.xwray.groupie.Group;
import com.xwray.groupie.GroupDataObserver;
import com.xwray.groupie.Item;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class NestedGroup
implements Group,
GroupDataObserver {
    private final GroupDataObservable observable = new GroupDataObservable();

    @Override
    public int getItemCount() {
        int size = 0;
        for (int i = 0; i < this.getGroupCount(); ++i) {
            Group group = this.getGroup(i);
            size += group.getItemCount();
        }
        return size;
    }

    protected int getItemCountBeforeGroup(@NonNull Group group) {
        int groupIndex = this.getPosition(group);
        return this.getItemCountBeforeGroup(groupIndex);
    }

    protected int getItemCountBeforeGroup(int groupIndex) {
        int size = 0;
        for (int i = 0; i < groupIndex; ++i) {
            Group currentGroup = this.getGroup(i);
            size += currentGroup.getItemCount();
        }
        return size;
    }

    @NonNull
    public abstract Group getGroup(int var1);

    public abstract int getGroupCount();

    @Override
    @NonNull
    public Item getItem(int position) {
        int previousPosition = 0;
        for (int i = 0; i < this.getGroupCount(); ++i) {
            Group group = this.getGroup(i);
            int size = group.getItemCount();
            if (size + previousPosition > position) {
                return group.getItem(position - previousPosition);
            }
            previousPosition += size;
        }
        throw new IndexOutOfBoundsException("Wanted item at " + position + " but there are only " + this.getItemCount() + " items");
    }

    @Override
    public final int getPosition(@NonNull Item item) {
        int previousPosition = 0;
        for (int i = 0; i < this.getGroupCount(); ++i) {
            Group group = this.getGroup(i);
            int position = group.getPosition(item);
            if (position >= 0) {
                return position + previousPosition;
            }
            previousPosition += group.getItemCount();
        }
        return -1;
    }

    public abstract int getPosition(@NonNull Group var1);

    @Override
    public final void registerGroupDataObserver(@NonNull GroupDataObserver groupDataObserver) {
        this.observable.registerObserver(groupDataObserver);
    }

    @Override
    public void unregisterGroupDataObserver(@NonNull GroupDataObserver groupDataObserver) {
        this.observable.unregisterObserver(groupDataObserver);
    }

    @CallSuper
    public void add(@NonNull Group group) {
        group.registerGroupDataObserver(this);
    }

    @CallSuper
    public void addAll(@NonNull Collection<? extends Group> groups) {
        for (Group group : groups) {
            group.registerGroupDataObserver(this);
        }
    }

    @CallSuper
    public void add(int position, @NonNull Group group) {
        group.registerGroupDataObserver(this);
    }

    @CallSuper
    public void addAll(int position, @NonNull Collection<? extends Group> groups) {
        for (Group group : groups) {
            group.registerGroupDataObserver(this);
        }
    }

    @CallSuper
    public void remove(@NonNull Group group) {
        group.unregisterGroupDataObserver(this);
    }

    @CallSuper
    public void removeAll(@NonNull Collection<? extends Group> groups) {
        for (Group group : groups) {
            group.unregisterGroupDataObserver(this);
        }
    }

    @Override
    @CallSuper
    public void onChanged(@NonNull Group group) {
        this.observable.onItemRangeChanged(this, this.getItemCountBeforeGroup(group), group.getItemCount());
    }

    @Override
    @CallSuper
    public void onItemInserted(@NonNull Group group, int position) {
        this.observable.onItemInserted(this, this.getItemCountBeforeGroup(group) + position);
    }

    @Override
    @CallSuper
    public void onItemChanged(@NonNull Group group, int position) {
        this.observable.onItemChanged(this, this.getItemCountBeforeGroup(group) + position);
    }

    @Override
    @CallSuper
    public void onItemChanged(@NonNull Group group, int position, Object payload) {
        this.observable.onItemChanged(this, this.getItemCountBeforeGroup(group) + position, payload);
    }

    @Override
    @CallSuper
    public void onItemRemoved(@NonNull Group group, int position) {
        this.observable.onItemRemoved(this, this.getItemCountBeforeGroup(group) + position);
    }

    @Override
    @CallSuper
    public void onItemRangeChanged(@NonNull Group group, int positionStart, int itemCount) {
        this.observable.onItemRangeChanged(this, this.getItemCountBeforeGroup(group) + positionStart, itemCount);
    }

    @Override
    @CallSuper
    public void onItemRangeChanged(@NonNull Group group, int positionStart, int itemCount, Object payload) {
        this.observable.onItemRangeChanged(this, this.getItemCountBeforeGroup(group) + positionStart, itemCount, payload);
    }

    @Override
    @CallSuper
    public void onItemRangeInserted(@NonNull Group group, int positionStart, int itemCount) {
        this.observable.onItemRangeInserted(this, this.getItemCountBeforeGroup(group) + positionStart, itemCount);
    }

    @Override
    @CallSuper
    public void onItemRangeRemoved(@NonNull Group group, int positionStart, int itemCount) {
        this.observable.onItemRangeRemoved(this, this.getItemCountBeforeGroup(group) + positionStart, itemCount);
    }

    @Override
    @CallSuper
    public void onItemMoved(@NonNull Group group, int fromPosition, int toPosition) {
        int groupPosition = this.getItemCountBeforeGroup(group);
        this.observable.onItemMoved(this, groupPosition + fromPosition, groupPosition + toPosition);
    }

    @CallSuper
    public void notifyItemRangeInserted(int positionStart, int itemCount) {
        this.observable.onItemRangeInserted(this, positionStart, itemCount);
    }

    @CallSuper
    public void notifyItemRangeRemoved(int positionStart, int itemCount) {
        this.observable.onItemRangeRemoved(this, positionStart, itemCount);
    }

    @CallSuper
    public void notifyItemMoved(int fromPosition, int toPosition) {
        this.observable.onItemMoved(this, fromPosition, toPosition);
    }

    @CallSuper
    public void notifyChanged() {
        this.observable.onChanged(this);
    }

    @CallSuper
    public void notifyItemInserted(int position) {
        this.observable.onItemInserted(this, position);
    }

    @CallSuper
    public void notifyItemChanged(int position) {
        this.observable.onItemChanged(this, position);
    }

    @CallSuper
    public void notifyItemChanged(int position, @Nullable Object payload) {
        this.observable.onItemChanged(this, position, payload);
    }

    @CallSuper
    public void notifyItemRemoved(int position) {
        this.observable.onItemRemoved(this, position);
    }

    @CallSuper
    public void notifyItemRangeChanged(int positionStart, int itemCount) {
        this.observable.onItemRangeChanged(this, positionStart, itemCount);
    }

    @CallSuper
    public void notifyItemRangeChanged(int positionStart, int itemCount, Object payload) {
        this.observable.onItemRangeChanged(this, positionStart, itemCount, payload);
    }

    private static class GroupDataObservable {
        final List<GroupDataObserver> observers = new ArrayList<GroupDataObserver>();

        private GroupDataObservable() {
        }

        void onItemRangeChanged(Group group, int positionStart, int itemCount) {
            for (int i = this.observers.size() - 1; i >= 0; --i) {
                this.observers.get(i).onItemRangeChanged(group, positionStart, itemCount);
            }
        }

        void onItemRangeChanged(Group group, int positionStart, int itemCount, Object payload) {
            for (int i = this.observers.size() - 1; i >= 0; --i) {
                this.observers.get(i).onItemRangeChanged(group, positionStart, itemCount, payload);
            }
        }

        void onItemInserted(Group group, int position) {
            for (int i = this.observers.size() - 1; i >= 0; --i) {
                this.observers.get(i).onItemInserted(group, position);
            }
        }

        void onItemChanged(Group group, int position) {
            for (int i = this.observers.size() - 1; i >= 0; --i) {
                this.observers.get(i).onItemChanged(group, position);
            }
        }

        void onItemChanged(Group group, int position, Object payload) {
            for (int i = this.observers.size() - 1; i >= 0; --i) {
                this.observers.get(i).onItemChanged(group, position, payload);
            }
        }

        void onItemRemoved(Group group, int position) {
            for (int i = this.observers.size() - 1; i >= 0; --i) {
                this.observers.get(i).onItemRemoved(group, position);
            }
        }

        void onItemRangeInserted(Group group, int positionStart, int itemCount) {
            for (int i = this.observers.size() - 1; i >= 0; --i) {
                this.observers.get(i).onItemRangeInserted(group, positionStart, itemCount);
            }
        }

        void onItemRangeRemoved(Group group, int positionStart, int itemCount) {
            for (int i = this.observers.size() - 1; i >= 0; --i) {
                this.observers.get(i).onItemRangeRemoved(group, positionStart, itemCount);
            }
        }

        void onItemMoved(Group group, int fromPosition, int toPosition) {
            for (int i = this.observers.size() - 1; i >= 0; --i) {
                this.observers.get(i).onItemMoved(group, fromPosition, toPosition);
            }
        }

        void onChanged(Group group) {
            for (int i = this.observers.size() - 1; i >= 0; --i) {
                this.observers.get(i).onChanged(group);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerObserver(GroupDataObserver observer) {
            List<GroupDataObserver> list = this.observers;
            synchronized (list) {
                if (this.observers.contains(observer)) {
                    throw new IllegalStateException("Observer " + observer + " is already registered.");
                }
                this.observers.add(observer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unregisterObserver(GroupDataObserver observer) {
            List<GroupDataObserver> list = this.observers;
            synchronized (list) {
                int index = this.observers.indexOf(observer);
                this.observers.remove(index);
            }
        }
    }
}

