/*
 * Decompiled with CFR 0.152.
 */
package com.xwray.groupie;

import android.view.View;
import androidx.annotation.CallSuper;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.xwray.groupie.Group;
import com.xwray.groupie.GroupDataObserver;
import com.xwray.groupie.GroupieViewHolder;
import com.xwray.groupie.OnItemClickListener;
import com.xwray.groupie.OnItemLongClickListener;
import com.xwray.groupie.SpanSizeProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Item<VH extends GroupieViewHolder>
implements Group,
SpanSizeProvider {
    private static AtomicLong ID_COUNTER = new AtomicLong(0L);
    protected GroupDataObserver parentDataObserver;
    private final long id;
    private Map<String, Object> extras = new HashMap<String, Object>();

    public Item() {
        this(ID_COUNTER.decrementAndGet());
    }

    protected Item(long id) {
        this.id = id;
    }

    @NonNull
    public VH createViewHolder(@NonNull View itemView) {
        return (VH)((Object)new GroupieViewHolder(itemView));
    }

    @CallSuper
    public void bind(@NonNull VH viewHolder, int position, @NonNull List<Object> payloads, @Nullable OnItemClickListener onItemClickListener, @Nullable OnItemLongClickListener onItemLongClickListener) {
        ((GroupieViewHolder)((Object)viewHolder)).bind(this, onItemClickListener, onItemLongClickListener);
        this.bind(viewHolder, position, payloads);
    }

    public abstract void bind(@NonNull VH var1, int var2);

    public void bind(@NonNull VH viewHolder, int position, @NonNull List<Object> payloads) {
        this.bind(viewHolder, position);
    }

    @CallSuper
    public void unbind(@NonNull VH viewHolder) {
        ((GroupieViewHolder)((Object)viewHolder)).unbind();
    }

    public boolean isRecyclable() {
        return true;
    }

    @Override
    public int getSpanSize(int spanCount, int position) {
        return spanCount;
    }

    public int getSwipeDirs() {
        return 0;
    }

    public int getDragDirs() {
        return 0;
    }

    @LayoutRes
    public abstract int getLayout();

    public void onViewAttachedToWindow(@NonNull VH viewHolder) {
    }

    public void onViewDetachedFromWindow(@NonNull VH viewHolder) {
    }

    public int getViewType() {
        return this.getLayout();
    }

    @Override
    public int getItemCount() {
        return 1;
    }

    @Override
    @NonNull
    public Item getItem(int position) {
        if (position == 0) {
            return this;
        }
        throw new IndexOutOfBoundsException("Wanted item at position " + position + " but an Item is a Group of size 1");
    }

    @Override
    public void registerGroupDataObserver(@NonNull GroupDataObserver groupDataObserver) {
        this.parentDataObserver = groupDataObserver;
    }

    @Override
    public void unregisterGroupDataObserver(@NonNull GroupDataObserver groupDataObserver) {
        this.parentDataObserver = null;
    }

    @Override
    public int getPosition(@NonNull Item item) {
        return this == item ? 0 : -1;
    }

    public boolean isClickable() {
        return true;
    }

    public boolean isLongClickable() {
        return true;
    }

    public void notifyChanged() {
        if (this.parentDataObserver != null) {
            this.parentDataObserver.onItemChanged(this, 0);
        }
    }

    public void notifyChanged(@Nullable Object payload) {
        if (this.parentDataObserver != null) {
            this.parentDataObserver.onItemChanged(this, 0, payload);
        }
    }

    public Map<String, Object> getExtras() {
        return this.extras;
    }

    public long getId() {
        return this.id;
    }

    public boolean isSameAs(@NonNull Item other) {
        if (this.getViewType() != other.getViewType()) {
            return false;
        }
        return this.getId() == other.getId();
    }

    public boolean hasSameContentAs(@NonNull Item other) {
        return this.equals(other);
    }

    @Nullable
    public Object getChangePayload(@NonNull Item newItem) {
        return null;
    }
}

