/*
 * Decompiled with CFR 0.152.
 */
package com.xwray.groupie;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.xwray.groupie.Item;
import com.xwray.groupie.OnItemClickListener;
import com.xwray.groupie.OnItemLongClickListener;
import java.util.Map;

public class GroupieViewHolder
extends RecyclerView.ViewHolder {
    private Item item;
    private OnItemClickListener onItemClickListener;
    private OnItemLongClickListener onItemLongClickListener;
    private View.OnClickListener onClickListener = new View.OnClickListener(){

        public void onClick(@NonNull View v) {
            if (GroupieViewHolder.this.onItemClickListener != null && GroupieViewHolder.this.getAdapterPosition() != -1) {
                GroupieViewHolder.this.onItemClickListener.onItemClick(GroupieViewHolder.this.getItem(), v);
            }
        }
    };
    private View.OnLongClickListener onLongClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(@NonNull View v) {
            if (GroupieViewHolder.this.onItemLongClickListener != null && GroupieViewHolder.this.getAdapterPosition() != -1) {
                return GroupieViewHolder.this.onItemLongClickListener.onItemLongClick(GroupieViewHolder.this.getItem(), v);
            }
            return false;
        }
    };

    public GroupieViewHolder(@NonNull View rootView) {
        super(rootView);
    }

    public void bind(@NonNull Item item, @Nullable OnItemClickListener onItemClickListener, @Nullable OnItemLongClickListener onItemLongClickListener) {
        this.item = item;
        if (onItemClickListener != null && item.isClickable()) {
            this.itemView.setOnClickListener(this.onClickListener);
            this.onItemClickListener = onItemClickListener;
        }
        if (onItemLongClickListener != null && item.isLongClickable()) {
            this.itemView.setOnLongClickListener(this.onLongClickListener);
            this.onItemLongClickListener = onItemLongClickListener;
        }
    }

    public void unbind() {
        if (this.onItemClickListener != null && this.item.isClickable()) {
            this.itemView.setOnClickListener(null);
        }
        if (this.onItemLongClickListener != null && this.item.isLongClickable()) {
            this.itemView.setOnLongClickListener(null);
        }
        this.item = null;
        this.onItemClickListener = null;
        this.onItemLongClickListener = null;
    }

    @NonNull
    public Map<String, Object> getExtras() {
        return this.item.getExtras();
    }

    public int getSwipeDirs() {
        return this.item.getSwipeDirs();
    }

    public int getDragDirs() {
        return this.item.getDragDirs();
    }

    public Item getItem() {
        return this.item;
    }

    public View getRoot() {
        return this.itemView;
    }
}

