/*
 * Decompiled with CFR 0.152.
 */
package com.xwray.groupie;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.ListUpdateCallback;
import androidx.recyclerview.widget.RecyclerView;
import com.xwray.groupie.AsyncDiffUtil;
import com.xwray.groupie.DiffCallback;
import com.xwray.groupie.Group;
import com.xwray.groupie.GroupDataObserver;
import com.xwray.groupie.GroupUtils;
import com.xwray.groupie.GroupieViewHolder;
import com.xwray.groupie.Item;
import com.xwray.groupie.OnAsyncUpdateListener;
import com.xwray.groupie.OnItemClickListener;
import com.xwray.groupie.OnItemLongClickListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GroupAdapter<VH extends GroupieViewHolder>
extends RecyclerView.Adapter<VH>
implements GroupDataObserver {
    private final List<Group> groups = new ArrayList<Group>();
    private OnItemClickListener onItemClickListener;
    private OnItemLongClickListener onItemLongClickListener;
    private int spanCount = 1;
    private Item lastItemForViewTypeLookup;
    private AsyncDiffUtil.Callback diffUtilCallbacks = new AsyncDiffUtil.Callback(){

        @Override
        public void onDispatchAsyncResult(@NonNull Collection<? extends Group> newGroups) {
            GroupAdapter.this.setNewGroups(newGroups);
        }

        public void onInserted(int position, int count) {
            GroupAdapter.this.notifyItemRangeInserted(position, count);
        }

        public void onRemoved(int position, int count) {
            GroupAdapter.this.notifyItemRangeRemoved(position, count);
        }

        public void onMoved(int fromPosition, int toPosition) {
            GroupAdapter.this.notifyItemMoved(fromPosition, toPosition);
        }

        public void onChanged(int position, int count, Object payload) {
            GroupAdapter.this.notifyItemRangeChanged(position, count, payload);
        }
    };
    private AsyncDiffUtil asyncDiffUtil = new AsyncDiffUtil(this.diffUtilCallbacks);
    private final GridLayoutManager.SpanSizeLookup spanSizeLookup = new GridLayoutManager.SpanSizeLookup(){

        public int getSpanSize(int position) {
            try {
                return GroupAdapter.this.getItem(position).getSpanSize(GroupAdapter.this.spanCount, position);
            }
            catch (IndexOutOfBoundsException e) {
                return GroupAdapter.this.spanCount;
            }
        }
    };

    @NonNull
    public GridLayoutManager.SpanSizeLookup getSpanSizeLookup() {
        return this.spanSizeLookup;
    }

    public void setSpanCount(int spanCount) {
        this.spanCount = spanCount;
    }

    public int getSpanCount() {
        return this.spanCount;
    }

    public void updateAsync(@NonNull List<? extends Group> newGroups) {
        this.updateAsync(newGroups, true, null);
    }

    public void updateAsync(@NonNull List<? extends Group> newGroups, @Nullable OnAsyncUpdateListener onAsyncUpdateListener) {
        this.updateAsync(newGroups, true, onAsyncUpdateListener);
    }

    public void updateAsync(@NonNull List<? extends Group> newGroups, boolean detectMoves, @Nullable OnAsyncUpdateListener onAsyncUpdateListener) {
        if (this.groups.isEmpty()) {
            this.update(newGroups, detectMoves);
            if (onAsyncUpdateListener != null) {
                onAsyncUpdateListener.onUpdateComplete();
            }
            return;
        }
        ArrayList<Group> oldGroups = new ArrayList<Group>(this.groups);
        DiffCallback diffUtilCallback = new DiffCallback(oldGroups, newGroups);
        this.asyncDiffUtil.calculateDiff(newGroups, diffUtilCallback, onAsyncUpdateListener, detectMoves);
    }

    public void update(@NonNull Collection<? extends Group> newGroups) {
        this.update(newGroups, true);
    }

    public void update(@NonNull Collection<? extends Group> newGroups, boolean detectMoves) {
        ArrayList<Group> oldGroups = new ArrayList<Group>(this.groups);
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new DiffCallback(oldGroups, newGroups), (boolean)detectMoves);
        this.setNewGroups(newGroups);
        diffResult.dispatchUpdatesTo((ListUpdateCallback)this.diffUtilCallbacks);
    }

    public void setOnItemClickListener(@Nullable OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public void setOnItemLongClickListener(@Nullable OnItemLongClickListener onItemLongClickListener) {
        this.onItemLongClickListener = onItemLongClickListener;
    }

    @NonNull
    public VH onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        Item<VH> item = this.getItemForViewType(viewType);
        View itemView = inflater.inflate(item.getLayout(), parent, false);
        return item.createViewHolder(itemView);
    }

    public void onBindViewHolder(@NonNull VH holder, int position) {
    }

    public void onBindViewHolder(@NonNull VH holder, int position, @NonNull List<Object> payloads) {
        Item contentItem = this.getItem(position);
        contentItem.bind(holder, position, payloads, this.onItemClickListener, this.onItemLongClickListener);
    }

    public void onViewRecycled(@NonNull VH holder) {
        Item contentItem = ((GroupieViewHolder)((Object)holder)).getItem();
        contentItem.unbind(holder);
    }

    public boolean onFailedToRecycleView(@NonNull VH holder) {
        Item contentItem = ((GroupieViewHolder)((Object)holder)).getItem();
        return contentItem.isRecyclable();
    }

    public void onViewAttachedToWindow(@NonNull VH holder) {
        super.onViewAttachedToWindow(holder);
        Item item = this.getItem(holder);
        item.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(@NonNull VH holder) {
        super.onViewDetachedFromWindow(holder);
        Item item = this.getItem(holder);
        item.onViewDetachedFromWindow(holder);
    }

    public int getItemViewType(int position) {
        this.lastItemForViewTypeLookup = this.getItem(position);
        if (this.lastItemForViewTypeLookup == null) {
            throw new RuntimeException("Invalid position " + position);
        }
        return this.lastItemForViewTypeLookup.getViewType();
    }

    public long getItemId(int position) {
        return this.getItem(position).getId();
    }

    @NonNull
    public Item getItem(@NonNull VH holder) {
        return ((GroupieViewHolder)((Object)holder)).getItem();
    }

    @NonNull
    public Item getItem(int position) {
        return GroupUtils.getItem(this.groups, position);
    }

    public int getAdapterPosition(@NonNull Item contentItem) {
        int count = 0;
        for (Group group : this.groups) {
            int index = group.getPosition(contentItem);
            if (index >= 0) {
                return index + count;
            }
            count += group.getItemCount();
        }
        return -1;
    }

    public int getAdapterPosition(@NonNull Group group) {
        int index = this.groups.indexOf(group);
        if (index == -1) {
            return -1;
        }
        int position = 0;
        for (int i = 0; i < index; ++i) {
            position += this.groups.get(i).getItemCount();
        }
        return position;
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public int getItemCount() {
        return GroupUtils.getItemCount(this.groups);
    }

    public int getItemCountForGroup(int groupIndex) {
        if (groupIndex >= this.groups.size()) {
            throw new IndexOutOfBoundsException("Requested group index " + groupIndex + " but there are " + this.groups.size() + " groups");
        }
        return this.groups.get(groupIndex).getItemCount();
    }

    @Deprecated
    public int getItemCount(int groupIndex) {
        return this.getItemCountForGroup(groupIndex);
    }

    public void clear() {
        for (Group group : this.groups) {
            group.unregisterGroupDataObserver(this);
        }
        this.groups.clear();
        this.notifyDataSetChanged();
    }

    public void add(@NonNull Group group) {
        if (group == null) {
            throw new RuntimeException("Group cannot be null");
        }
        int itemCountBeforeGroup = this.getItemCount();
        group.registerGroupDataObserver(this);
        this.groups.add(group);
        this.notifyItemRangeInserted(itemCountBeforeGroup, group.getItemCount());
    }

    public void addAll(@NonNull Collection<? extends Group> groups) {
        if (groups.contains(null)) {
            throw new RuntimeException("List of groups can't contain null!");
        }
        int itemCountBeforeGroup = this.getItemCount();
        int additionalSize = 0;
        for (Group group : groups) {
            additionalSize += group.getItemCount();
            group.registerGroupDataObserver(this);
        }
        this.groups.addAll(groups);
        this.notifyItemRangeInserted(itemCountBeforeGroup, additionalSize);
    }

    public void remove(@NonNull Group group) {
        if (group == null) {
            throw new RuntimeException("Group cannot be null");
        }
        int position = this.groups.indexOf(group);
        this.remove(position, group);
    }

    public void removeAll(@NonNull Collection<? extends Group> groups) {
        for (Group group : groups) {
            this.remove(group);
        }
    }

    public void removeGroupAtAdapterPosition(int position) {
        Group group = this.getGroupAtAdapterPosition(position);
        this.remove(position, group);
    }

    @Deprecated
    public void removeGroup(int adapterPosition) {
        this.removeGroupAtAdapterPosition(adapterPosition);
    }

    private void remove(int position, @NonNull Group group) {
        int itemCountBeforeGroup = this.getItemCountBeforeGroup(position);
        group.unregisterGroupDataObserver(this);
        this.groups.remove(position);
        this.notifyItemRangeRemoved(itemCountBeforeGroup, group.getItemCount());
    }

    public void add(int index, @NonNull Group group) {
        if (group == null) {
            throw new RuntimeException("Group cannot be null");
        }
        group.registerGroupDataObserver(this);
        this.groups.add(index, group);
        int itemCountBeforeGroup = this.getItemCountBeforeGroup(index);
        this.notifyItemRangeInserted(itemCountBeforeGroup, group.getItemCount());
    }

    @NonNull
    public Group getTopLevelGroup(int position) {
        return this.groups.get(position);
    }

    @NonNull
    public Group getGroupAtAdapterPosition(int position) {
        int previous = 0;
        for (Group group : this.groups) {
            int size = group.getItemCount();
            if (position - previous < size) {
                return group;
            }
            previous += group.getItemCount();
        }
        throw new IndexOutOfBoundsException("Requested position " + position + " in group adapter but there are only " + previous + " items");
    }

    @Deprecated
    @NonNull
    public Group getGroup(int adapterPosition) {
        return this.getGroupAtAdapterPosition(adapterPosition);
    }

    @NonNull
    public Group getGroup(Item contentItem) {
        for (Group group : this.groups) {
            if (group.getPosition(contentItem) < 0) continue;
            return group;
        }
        throw new IndexOutOfBoundsException("Item is not present in adapter or in any group");
    }

    @Override
    public void onChanged(@NonNull Group group) {
        this.notifyItemRangeChanged(this.getAdapterPosition(group), group.getItemCount());
    }

    @Override
    public void onItemInserted(@NonNull Group group, int position) {
        this.notifyItemInserted(this.getAdapterPosition(group) + position);
    }

    @Override
    public void onItemChanged(@NonNull Group group, int position) {
        this.notifyItemChanged(this.getAdapterPosition(group) + position);
    }

    @Override
    public void onItemChanged(@NonNull Group group, int position, Object payload) {
        this.notifyItemChanged(this.getAdapterPosition(group) + position, payload);
    }

    @Override
    public void onItemRemoved(@NonNull Group group, int position) {
        this.notifyItemRemoved(this.getAdapterPosition(group) + position);
    }

    @Override
    public void onItemRangeChanged(@NonNull Group group, int positionStart, int itemCount) {
        this.notifyItemRangeChanged(this.getAdapterPosition(group) + positionStart, itemCount);
    }

    @Override
    public void onItemRangeChanged(@NonNull Group group, int positionStart, int itemCount, Object payload) {
        this.notifyItemRangeChanged(this.getAdapterPosition(group) + positionStart, itemCount, payload);
    }

    @Override
    public void onItemRangeInserted(@NonNull Group group, int positionStart, int itemCount) {
        this.notifyItemRangeInserted(this.getAdapterPosition(group) + positionStart, itemCount);
    }

    @Override
    public void onItemRangeRemoved(@NonNull Group group, int positionStart, int itemCount) {
        this.notifyItemRangeRemoved(this.getAdapterPosition(group) + positionStart, itemCount);
    }

    @Override
    public void onItemMoved(@NonNull Group group, int fromPosition, int toPosition) {
        int groupAdapterPosition = this.getAdapterPosition(group);
        this.notifyItemMoved(groupAdapterPosition + fromPosition, groupAdapterPosition + toPosition);
    }

    private Item<VH> getItemForViewType(int viewType) {
        if (this.lastItemForViewTypeLookup != null && this.lastItemForViewTypeLookup.getViewType() == viewType) {
            return this.lastItemForViewTypeLookup;
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            Item item = this.getItem(i);
            if (item.getViewType() != viewType) continue;
            return item;
        }
        throw new IllegalStateException("Could not find model for view type: " + viewType);
    }

    private int getItemCountBeforeGroup(int groupIndex) {
        int count = 0;
        for (Group group : this.groups.subList(0, groupIndex)) {
            count += group.getItemCount();
        }
        return count;
    }

    private void setNewGroups(@NonNull Collection<? extends Group> newGroups) {
        for (Group group : this.groups) {
            group.unregisterGroupDataObserver(this);
        }
        this.groups.clear();
        this.groups.addAll(newGroups);
        for (Group group : newGroups) {
            group.registerGroupDataObserver(this);
        }
    }
}

