/*
 * Decompiled with CFR 0.152.
 */
package com.xwray.groupie;

import androidx.annotation.NonNull;
import com.xwray.groupie.ExpandableItem;
import com.xwray.groupie.Group;
import com.xwray.groupie.GroupUtils;
import com.xwray.groupie.NestedGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExpandableGroup
extends NestedGroup {
    private boolean isExpanded = false;
    private final Group parent;
    private final List<Group> children = new ArrayList<Group>();

    public ExpandableGroup(Group expandableItem) {
        this.parent = expandableItem;
        ((ExpandableItem)((Object)expandableItem)).setExpandableGroup(this);
    }

    public ExpandableGroup(Group expandableItem, boolean isExpanded) {
        this.parent = expandableItem;
        ((ExpandableItem)((Object)expandableItem)).setExpandableGroup(this);
        this.isExpanded = isExpanded;
    }

    @Override
    public void add(int position, @NonNull Group group) {
        super.add(position, group);
        this.children.add(position, group);
        if (this.isExpanded) {
            int notifyPosition = 1 + GroupUtils.getItemCount(this.children.subList(0, position));
            this.notifyItemRangeInserted(notifyPosition, group.getItemCount());
        }
    }

    @Override
    public void add(@NonNull Group group) {
        super.add(group);
        if (this.isExpanded) {
            int itemCount = this.getItemCount();
            this.children.add(group);
            this.notifyItemRangeInserted(itemCount, group.getItemCount());
        } else {
            this.children.add(group);
        }
    }

    @Override
    public void addAll(@NonNull Collection<? extends Group> groups) {
        if (groups.isEmpty()) {
            return;
        }
        super.addAll(groups);
        if (this.isExpanded) {
            int itemCount = this.getItemCount();
            this.children.addAll(groups);
            this.notifyItemRangeInserted(itemCount, GroupUtils.getItemCount(groups));
        } else {
            this.children.addAll(groups);
        }
    }

    @Override
    public void addAll(int position, @NonNull Collection<? extends Group> groups) {
        if (groups.isEmpty()) {
            return;
        }
        super.addAll(position, groups);
        this.children.addAll(position, groups);
        if (this.isExpanded) {
            int notifyPosition = 1 + GroupUtils.getItemCount(this.children.subList(0, position));
            this.notifyItemRangeInserted(notifyPosition, GroupUtils.getItemCount(groups));
        }
    }

    @Override
    public void remove(@NonNull Group group) {
        if (!this.children.contains(group)) {
            return;
        }
        super.remove(group);
        if (this.isExpanded) {
            int position = this.getItemCountBeforeGroup(group);
            this.children.remove(group);
            this.notifyItemRangeRemoved(position, group.getItemCount());
        } else {
            this.children.remove(group);
        }
    }

    @Override
    public void removeAll(@NonNull Collection<? extends Group> groups) {
        if (groups.isEmpty() || !this.children.containsAll(groups)) {
            return;
        }
        super.removeAll(groups);
        if (this.isExpanded) {
            this.children.removeAll(groups);
            for (Group group : groups) {
                int position = this.getItemCountBeforeGroup(group);
                this.children.remove(group);
                this.notifyItemRangeRemoved(position, group.getItemCount());
            }
        } else {
            this.children.removeAll(groups);
        }
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Override
    @NonNull
    public Group getGroup(int position) {
        if (position == 0) {
            return this.parent;
        }
        return this.children.get(position - 1);
    }

    @Override
    public int getPosition(@NonNull Group group) {
        if (group == this.parent) {
            return 0;
        }
        int index = this.children.indexOf(group);
        if (index >= 0) {
            return index + 1;
        }
        return -1;
    }

    @Override
    public int getGroupCount() {
        return 1 + (this.isExpanded ? this.children.size() : 0);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public void onToggleExpanded() {
        int oldSize = this.getItemCount();
        this.isExpanded = !this.isExpanded;
        int newSize = this.getItemCount();
        if (oldSize > newSize) {
            this.notifyItemRangeRemoved(newSize, oldSize - newSize);
        } else {
            this.notifyItemRangeInserted(oldSize, newSize - oldSize);
        }
    }

    public void setExpanded(boolean isExpanded) {
        if (this.isExpanded != isExpanded) {
            this.onToggleExpanded();
        }
    }

    private boolean dispatchChildChanges(Group group) {
        return this.isExpanded || group == this.parent;
    }

    @Override
    public void onChanged(@NonNull Group group) {
        if (this.dispatchChildChanges(group)) {
            super.onChanged(group);
        }
    }

    @Override
    public void onItemInserted(@NonNull Group group, int position) {
        if (this.dispatchChildChanges(group)) {
            super.onItemInserted(group, position);
        }
    }

    @Override
    public void onItemChanged(@NonNull Group group, int position) {
        if (this.dispatchChildChanges(group)) {
            super.onItemChanged(group, position);
        }
    }

    @Override
    public void onItemChanged(@NonNull Group group, int position, Object payload) {
        if (this.dispatchChildChanges(group)) {
            super.onItemChanged(group, position, payload);
        }
    }

    @Override
    public void onItemRemoved(@NonNull Group group, int position) {
        if (this.dispatchChildChanges(group)) {
            super.onItemRemoved(group, position);
        }
    }

    @Override
    public void onItemRangeChanged(@NonNull Group group, int positionStart, int itemCount) {
        if (this.dispatchChildChanges(group)) {
            super.onItemRangeChanged(group, positionStart, itemCount);
        }
    }

    @Override
    public void onItemRangeChanged(@NonNull Group group, int positionStart, int itemCount, Object payload) {
        if (this.dispatchChildChanges(group)) {
            super.onItemRangeChanged(group, positionStart, itemCount, payload);
        }
    }

    @Override
    public void onItemRangeInserted(@NonNull Group group, int positionStart, int itemCount) {
        if (this.dispatchChildChanges(group)) {
            super.onItemRangeInserted(group, positionStart, itemCount);
        }
    }

    @Override
    public void onItemRangeRemoved(@NonNull Group group, int positionStart, int itemCount) {
        if (this.dispatchChildChanges(group)) {
            super.onItemRangeRemoved(group, positionStart, itemCount);
        }
    }

    @Override
    public void onItemMoved(@NonNull Group group, int fromPosition, int toPosition) {
        if (this.dispatchChildChanges(group)) {
            super.onItemMoved(group, fromPosition, toPosition);
        }
    }
}

