/*
 * Decompiled with CFR 0.152.
 */
package com.xwray.groupie;

import android.os.AsyncTask;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListUpdateCallback;
import com.xwray.groupie.AsyncDiffUtil;
import com.xwray.groupie.OnAsyncUpdateListener;
import java.lang.ref.WeakReference;

class DiffTask
extends AsyncTask<Void, Void, DiffUtil.DiffResult> {
    @NonNull
    private final DiffUtil.Callback diffCallback;
    private final WeakReference<AsyncDiffUtil> asyncListDiffer;
    private final int runGeneration;
    private final boolean detectMoves;
    @Nullable
    private WeakReference<OnAsyncUpdateListener> onAsyncUpdateListener;
    private Exception backgroundException = null;

    DiffTask(@NonNull AsyncDiffUtil asyncDiffUtil, @NonNull DiffUtil.Callback callback, int runGeneration, boolean detectMoves, @Nullable OnAsyncUpdateListener onAsyncUpdateListener) {
        this.diffCallback = callback;
        this.asyncListDiffer = new WeakReference<AsyncDiffUtil>(asyncDiffUtil);
        this.runGeneration = runGeneration;
        this.detectMoves = detectMoves;
        if (onAsyncUpdateListener != null) {
            this.onAsyncUpdateListener = new WeakReference<OnAsyncUpdateListener>(onAsyncUpdateListener);
        }
    }

    @Nullable
    protected DiffUtil.DiffResult doInBackground(Void ... voids) {
        try {
            return DiffUtil.calculateDiff((DiffUtil.Callback)this.diffCallback, (boolean)this.detectMoves);
        }
        catch (Exception e) {
            this.backgroundException = e;
            return null;
        }
    }

    protected void onPostExecute(@Nullable DiffUtil.DiffResult diffResult) {
        if (this.backgroundException != null) {
            throw new RuntimeException(this.backgroundException);
        }
        AsyncDiffUtil async = (AsyncDiffUtil)this.asyncListDiffer.get();
        if (this.shouldDispatchResult(diffResult, async)) {
            async.getAsyncDiffUtilCallback().onDispatchAsyncResult(async.getGroups());
            diffResult.dispatchUpdatesTo((ListUpdateCallback)async.getAsyncDiffUtilCallback());
            if (this.onAsyncUpdateListener != null && this.onAsyncUpdateListener.get() != null) {
                ((OnAsyncUpdateListener)this.onAsyncUpdateListener.get()).onUpdateComplete();
            }
        }
    }

    private boolean shouldDispatchResult(@Nullable DiffUtil.DiffResult diffResult, AsyncDiffUtil async) {
        return diffResult != null && async != null && this.runGeneration == async.getMaxScheduledGeneration();
    }
}

