/*
 * Decompiled with CFR 0.152.
 */
package com.xwray.groupie;

import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import com.xwray.groupie.Group;
import com.xwray.groupie.GroupUtils;
import com.xwray.groupie.Item;
import java.util.Collection;

class DiffCallback
extends DiffUtil.Callback {
    private final int oldBodyItemCount;
    private final int newBodyItemCount;
    private final Collection<? extends Group> oldGroups;
    private final Collection<? extends Group> newGroups;

    DiffCallback(Collection<? extends Group> oldGroups, Collection<? extends Group> newGroups) {
        this.oldBodyItemCount = GroupUtils.getItemCount(oldGroups);
        this.newBodyItemCount = GroupUtils.getItemCount(newGroups);
        this.oldGroups = oldGroups;
        this.newGroups = newGroups;
    }

    public int getOldListSize() {
        return this.oldBodyItemCount;
    }

    public int getNewListSize() {
        return this.newBodyItemCount;
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        Item oldItem = GroupUtils.getItem(this.oldGroups, oldItemPosition);
        Item newItem = GroupUtils.getItem(this.newGroups, newItemPosition);
        return newItem.isSameAs(oldItem);
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        Item oldItem = GroupUtils.getItem(this.oldGroups, oldItemPosition);
        Item newItem = GroupUtils.getItem(this.newGroups, newItemPosition);
        return newItem.hasSameContentAs(oldItem);
    }

    @Nullable
    public Object getChangePayload(int oldItemPosition, int newItemPosition) {
        Item oldItem = GroupUtils.getItem(this.oldGroups, oldItemPosition);
        Item newItem = GroupUtils.getItem(this.newGroups, newItemPosition);
        return oldItem.getChangePayload(newItem);
    }
}

