/*
 * Decompiled with CFR 0.152.
 */
package com.xwray.groupie;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListUpdateCallback;
import com.xwray.groupie.DiffTask;
import com.xwray.groupie.Group;
import com.xwray.groupie.OnAsyncUpdateListener;
import java.util.Collection;

class AsyncDiffUtil {
    private final Callback asyncDiffUtilCallback;
    private int maxScheduledGeneration;
    private Collection<? extends Group> groups;

    AsyncDiffUtil(@NonNull Callback callback) {
        this.asyncDiffUtilCallback = callback;
    }

    @NonNull
    Callback getAsyncDiffUtilCallback() {
        return this.asyncDiffUtilCallback;
    }

    @NonNull
    Collection<? extends Group> getGroups() {
        return this.groups;
    }

    int getMaxScheduledGeneration() {
        return this.maxScheduledGeneration;
    }

    void calculateDiff(@NonNull Collection<? extends Group> newGroups, @NonNull DiffUtil.Callback diffUtilCallback, @Nullable OnAsyncUpdateListener onAsyncUpdateListener, boolean detectMoves) {
        this.groups = newGroups;
        int runGeneration = ++this.maxScheduledGeneration;
        new DiffTask(this, diffUtilCallback, runGeneration, detectMoves, onAsyncUpdateListener).execute(new Void[0]);
    }

    static interface Callback
    extends ListUpdateCallback {
        @MainThread
        public void onDispatchAsyncResult(@NonNull Collection<? extends Group> var1);
    }
}

