/*
 * Decompiled with CFR 0.152.
 */
package com.xw.repo;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.Property;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.LinearInterpolator;
import com.xw.repo.BubbleConfigBuilder;
import com.xw.repo.BubbleUtils;
import com.xw.repo.bubbleseekbar.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.math.BigDecimal;

public class BubbleSeekBar
extends View {
    static final int NONE = -1;
    private float mMin;
    private float mMax;
    private float mProgress;
    private boolean isFloatType;
    private int mTrackSize;
    private int mSecondTrackSize;
    private int mThumbRadius;
    private int mThumbRadiusOnDragging;
    private int mTrackColor;
    private int mSecondTrackColor;
    private int mThumbColor;
    private int mSectionCount;
    private boolean isShowSectionMark;
    private boolean isAutoAdjustSectionMark;
    private boolean isShowSectionText;
    private int mSectionTextSize;
    private int mSectionTextColor;
    private int mSectionTextPosition = -1;
    private int mSectionTextInterval;
    private boolean isShowThumbText;
    private int mThumbTextSize;
    private int mThumbTextColor;
    private boolean isShowProgressInFloat;
    private boolean isTouchToSeek;
    private boolean isSeekBySection;
    private long mAnimDuration;
    private boolean isAlwaysShowBubble;
    private int mBubbleColor;
    private int mBubbleTextSize;
    private int mBubbleTextColor;
    private float mDelta;
    private float mSectionValue;
    private float mThumbCenterX;
    private float mTrackLength;
    private float mSectionOffset;
    private boolean isThumbOnDragging;
    private int mTextSpace;
    private boolean triggerBubbleShowing;
    private boolean triggerSeekBySection;
    private OnProgressChangedListener mProgressListener;
    private float mLeft;
    private float mRight;
    private Paint mPaint;
    private Rect mRectText;
    private WindowManager mWindowManager;
    private BubbleView mBubbleView;
    private int mBubbleRadius;
    private float mBubbleCenterRawSolidX;
    private float mBubbleCenterRawSolidY;
    private float mBubbleCenterRawX;
    private WindowManager.LayoutParams mLayoutParams;
    private int[] mPoint = new int[2];
    private boolean isTouchToSeekAnimEnd = true;
    private float mPreSecValue;
    private BubbleConfigBuilder mConfigBuilder;
    float dx;

    public BubbleSeekBar(Context context) {
        this(context, null);
    }

    public BubbleSeekBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BubbleSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BubbleSeekBar, defStyleAttr, 0);
        this.mMin = a.getFloat(R.styleable.BubbleSeekBar_bsb_min, 0.0f);
        this.mMax = a.getFloat(R.styleable.BubbleSeekBar_bsb_max, 100.0f);
        this.mProgress = a.getFloat(R.styleable.BubbleSeekBar_bsb_progress, this.mMin);
        this.isFloatType = a.getBoolean(R.styleable.BubbleSeekBar_bsb_is_float_type, false);
        this.mTrackSize = a.getDimensionPixelSize(R.styleable.BubbleSeekBar_bsb_track_size, BubbleUtils.dp2px(2));
        this.mSecondTrackSize = a.getDimensionPixelSize(R.styleable.BubbleSeekBar_bsb_second_track_size, this.mTrackSize + BubbleUtils.dp2px(2));
        this.mThumbRadius = a.getDimensionPixelSize(R.styleable.BubbleSeekBar_bsb_thumb_radius, this.mSecondTrackSize + BubbleUtils.dp2px(2));
        this.mThumbRadiusOnDragging = a.getDimensionPixelSize(R.styleable.BubbleSeekBar_bsb_thumb_radius, this.mSecondTrackSize * 2);
        this.mSectionCount = a.getInteger(R.styleable.BubbleSeekBar_bsb_section_count, 10);
        this.mTrackColor = a.getColor(R.styleable.BubbleSeekBar_bsb_track_color, ContextCompat.getColor((Context)context, (int)R.color.colorPrimary));
        this.mSecondTrackColor = a.getColor(R.styleable.BubbleSeekBar_bsb_second_track_color, ContextCompat.getColor((Context)context, (int)R.color.colorAccent));
        this.mThumbColor = a.getColor(R.styleable.BubbleSeekBar_bsb_thumb_color, this.mSecondTrackColor);
        this.isShowSectionText = a.getBoolean(R.styleable.BubbleSeekBar_bsb_show_section_text, false);
        this.mSectionTextSize = a.getDimensionPixelSize(R.styleable.BubbleSeekBar_bsb_section_text_size, BubbleUtils.sp2px(14));
        this.mSectionTextColor = a.getColor(R.styleable.BubbleSeekBar_bsb_section_text_color, this.mTrackColor);
        this.isSeekBySection = a.getBoolean(R.styleable.BubbleSeekBar_bsb_seek_by_section, false);
        int pos = a.getInteger(R.styleable.BubbleSeekBar_bsb_section_text_position, -1);
        this.mSectionTextPosition = pos == 0 ? 0 : (pos == 1 ? 1 : (pos == 2 ? 2 : -1));
        this.mSectionTextInterval = a.getInteger(R.styleable.BubbleSeekBar_bsb_section_text_interval, 1);
        this.isShowThumbText = a.getBoolean(R.styleable.BubbleSeekBar_bsb_show_thumb_text, false);
        this.mThumbTextSize = a.getDimensionPixelSize(R.styleable.BubbleSeekBar_bsb_thumb_text_size, BubbleUtils.sp2px(14));
        this.mThumbTextColor = a.getColor(R.styleable.BubbleSeekBar_bsb_thumb_text_color, this.mSecondTrackColor);
        this.mBubbleColor = a.getColor(R.styleable.BubbleSeekBar_bsb_bubble_color, this.mSecondTrackColor);
        this.mBubbleTextSize = a.getDimensionPixelSize(R.styleable.BubbleSeekBar_bsb_bubble_text_size, BubbleUtils.sp2px(14));
        this.mBubbleTextColor = a.getColor(R.styleable.BubbleSeekBar_bsb_bubble_text_color, -1);
        this.isShowSectionMark = a.getBoolean(R.styleable.BubbleSeekBar_bsb_show_section_mark, false);
        this.isAutoAdjustSectionMark = a.getBoolean(R.styleable.BubbleSeekBar_bsb_auto_adjust_section_mark, false);
        this.isShowProgressInFloat = a.getBoolean(R.styleable.BubbleSeekBar_bsb_show_progress_in_float, false);
        int duration = a.getInteger(R.styleable.BubbleSeekBar_bsb_anim_duration, -1);
        this.mAnimDuration = duration < 0 ? 200L : (long)duration;
        this.isTouchToSeek = a.getBoolean(R.styleable.BubbleSeekBar_bsb_touch_to_seek, false);
        this.isAlwaysShowBubble = a.getBoolean(R.styleable.BubbleSeekBar_bsb_always_show_bubble, false);
        a.recycle();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mRectText = new Rect();
        this.mTextSpace = BubbleUtils.dp2px(2);
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        this.mBubbleView = new BubbleView(context);
        this.mBubbleView.setProgressText(this.isShowProgressInFloat ? String.valueOf(this.getProgressFloat()) : String.valueOf(this.getProgress()));
        this.initConfigByPriority();
        this.calculateRadiusOfBubble();
    }

    private void initConfigByPriority() {
        if (this.mMin == this.mMax) {
            this.mMin = 0.0f;
            this.mMax = 100.0f;
        }
        if (this.mMin > this.mMax) {
            float tmp = this.mMax;
            this.mMax = this.mMin;
            this.mMin = tmp;
        }
        if (this.mProgress < this.mMin) {
            this.mProgress = this.mMin;
        }
        if (this.mProgress > this.mMax) {
            this.mProgress = this.mMax;
        }
        if (this.mSecondTrackSize < this.mTrackSize) {
            this.mSecondTrackSize = this.mTrackSize + BubbleUtils.dp2px(2);
        }
        if (this.mThumbRadius <= this.mSecondTrackSize) {
            this.mThumbRadius = this.mSecondTrackSize + BubbleUtils.dp2px(2);
        }
        if (this.mThumbRadiusOnDragging <= this.mSecondTrackSize) {
            this.mThumbRadiusOnDragging = this.mSecondTrackSize * 2;
        }
        if (this.mSectionCount <= 0) {
            this.mSectionCount = 10;
        }
        this.mDelta = this.mMax - this.mMin;
        this.mSectionValue = this.mDelta / (float)this.mSectionCount;
        if (this.mSectionValue < 1.0f) {
            this.isFloatType = true;
        }
        if (this.isFloatType) {
            this.isShowProgressInFloat = true;
        }
        if (this.mSectionTextPosition != -1) {
            this.isShowSectionText = true;
        }
        if (this.isShowSectionText) {
            if (this.mSectionTextPosition == -1) {
                this.mSectionTextPosition = 0;
            }
            if (this.mSectionTextPosition == 2) {
                this.isShowSectionMark = true;
            }
        }
        if (this.mSectionTextInterval < 1) {
            this.mSectionTextInterval = 1;
        }
        if (this.isAutoAdjustSectionMark && !this.isShowSectionMark) {
            this.isAutoAdjustSectionMark = false;
        }
        if (this.isSeekBySection) {
            this.mPreSecValue = this.mMin;
            if (this.mProgress != this.mMin) {
                this.mPreSecValue = this.mSectionValue;
            }
            this.isShowSectionMark = true;
            this.isAutoAdjustSectionMark = true;
            this.isTouchToSeek = false;
        }
        if (this.isAlwaysShowBubble) {
            this.setProgress(this.mProgress);
        }
        this.mThumbTextSize = this.isFloatType || this.isSeekBySection || this.isShowSectionText && this.mSectionTextPosition == 2 ? this.mSectionTextSize : this.mThumbTextSize;
    }

    private void calculateRadiusOfBubble() {
        this.mPaint.setTextSize((float)this.mBubbleTextSize);
        String text = this.isShowProgressInFloat ? this.float2String(this.mMin) : this.getMinText();
        this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
        int w1 = this.mRectText.width() + this.mTextSpace * 2 >> 1;
        text = this.isShowProgressInFloat ? this.float2String(this.mMax) : this.getMaxText();
        this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
        int w2 = this.mRectText.width() + this.mTextSpace * 2 >> 1;
        this.mBubbleRadius = BubbleUtils.dp2px(14);
        int max = Math.max(this.mBubbleRadius, Math.max(w1, w2));
        this.mBubbleRadius = max + this.mTextSpace;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int height = this.mThumbRadiusOnDragging * 2;
        if (this.isShowThumbText) {
            this.mPaint.setTextSize((float)this.mThumbTextSize);
            this.mPaint.getTextBounds("j", 0, 1, this.mRectText);
            height += this.mRectText.height() + this.mTextSpace;
        }
        if (this.isShowSectionText && this.mSectionTextPosition >= 1) {
            this.mPaint.setTextSize((float)this.mSectionTextSize);
            this.mPaint.getTextBounds("j", 0, 1, this.mRectText);
            height = Math.max(height, this.mThumbRadiusOnDragging * 2 + this.mRectText.height() + this.mTextSpace);
        }
        this.setMeasuredDimension(BubbleSeekBar.resolveSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec), height);
        this.mLeft = this.getPaddingLeft() + this.mThumbRadiusOnDragging;
        this.mRight = this.getMeasuredWidth() - this.getPaddingRight() - this.mThumbRadiusOnDragging;
        if (this.isShowSectionText) {
            this.mPaint.setTextSize((float)this.mSectionTextSize);
            if (this.mSectionTextPosition == 0) {
                String text = this.getMinText();
                this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
                this.mLeft += (float)(this.mRectText.width() + this.mTextSpace);
                text = this.getMaxText();
                this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
                this.mRight -= (float)(this.mRectText.width() + this.mTextSpace);
            } else if (this.mSectionTextPosition >= 1) {
                String text = this.getMinText();
                this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
                float max = Math.max((float)this.mThumbRadiusOnDragging, (float)this.mRectText.width() / 2.0f);
                this.mLeft = (float)this.getPaddingLeft() + max + (float)this.mTextSpace;
                text = this.getMaxText();
                this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
                max = Math.max((float)this.mThumbRadiusOnDragging, (float)this.mRectText.width() / 2.0f);
                this.mRight = (float)(this.getMeasuredWidth() - this.getPaddingRight()) - max - (float)this.mTextSpace;
            }
        } else if (this.isShowThumbText && this.mSectionTextPosition == -1) {
            this.mPaint.setTextSize((float)this.mThumbTextSize);
            String text = this.getMinText();
            this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
            float max = Math.max((float)this.mThumbRadiusOnDragging, (float)this.mRectText.width() / 2.0f);
            this.mLeft = (float)this.getPaddingLeft() + max + (float)this.mTextSpace;
            text = this.getMaxText();
            this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
            max = Math.max((float)this.mThumbRadiusOnDragging, (float)this.mRectText.width() / 2.0f);
            this.mRight = (float)(this.getMeasuredWidth() - this.getPaddingRight()) - max - (float)this.mTextSpace;
        }
        this.mTrackLength = this.mRight - this.mLeft;
        this.mSectionOffset = this.mTrackLength * 1.0f / (float)this.mSectionCount;
        this.mBubbleView.measure(widthMeasureSpec, heightMeasureSpec);
        this.locatePositionOnScreen();
    }

    private void locatePositionOnScreen() {
        this.getLocationOnScreen(this.mPoint);
        this.mBubbleCenterRawSolidX = (float)this.mPoint[0] + this.mLeft - (float)this.mBubbleView.getMeasuredWidth() / 2.0f;
        this.mBubbleCenterRawX = this.mBubbleCenterRawSolidX + this.mTrackLength * (this.mProgress - this.mMin) / this.mDelta;
        this.mBubbleCenterRawSolidY = this.mPoint[1] - this.mBubbleView.getMeasuredHeight();
        this.mBubbleCenterRawSolidY -= (float)BubbleUtils.dp2px(24);
        if (BubbleUtils.isMIUI()) {
            this.mBubbleCenterRawSolidY += (float)BubbleUtils.dp2px(4);
        }
    }

    protected void onDraw(Canvas canvas) {
        boolean conditionInterval;
        super.onDraw(canvas);
        float xLeft = this.getPaddingLeft();
        float xRight = this.getMeasuredWidth() - this.getPaddingRight();
        float yTop = this.getPaddingTop() + this.mThumbRadiusOnDragging;
        if (this.isShowSectionText) {
            String text;
            float y_;
            this.mPaint.setTextSize((float)this.mSectionTextSize);
            this.mPaint.setColor(this.mSectionTextColor);
            if (this.mSectionTextPosition == 0) {
                y_ = yTop + (float)this.mRectText.height() / 2.0f;
                text = this.getMinText();
                this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
                canvas.drawText(text, xLeft + (float)this.mRectText.width() / 2.0f, y_, this.mPaint);
                xLeft += (float)(this.mRectText.width() + this.mTextSpace);
                text = this.getMaxText();
                this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
                canvas.drawText(text, xRight - (float)this.mRectText.width() / 2.0f, y_, this.mPaint);
                xRight -= (float)(this.mRectText.width() + this.mTextSpace);
            } else if (this.mSectionTextPosition >= 1) {
                y_ = yTop + (float)this.mThumbRadiusOnDragging + (float)this.mTextSpace;
                text = this.getMinText();
                this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
                y_ += (float)this.mRectText.height();
                xLeft = this.mLeft;
                if (this.mSectionTextPosition == 1) {
                    canvas.drawText(text, xLeft, y_, this.mPaint);
                }
                text = this.getMaxText();
                this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
                xRight = this.mRight;
                if (this.mSectionTextPosition == 1) {
                    canvas.drawText(text, xRight, y_, this.mPaint);
                }
            }
        } else if (this.isShowThumbText && this.mSectionTextPosition == -1) {
            xLeft = this.mLeft;
            xRight = this.mRight;
        }
        if (!this.isShowSectionText && !this.isShowThumbText || this.mSectionTextPosition == 0) {
            xLeft += (float)this.mThumbRadiusOnDragging;
            xRight -= (float)this.mThumbRadiusOnDragging;
        }
        boolean isShowTextBelowSectionMark = this.isShowSectionText && this.mSectionTextPosition == 2;
        boolean bl = conditionInterval = this.mSectionCount % 2 == 0;
        if (isShowTextBelowSectionMark || this.isShowSectionMark) {
            float r = (float)(this.mThumbRadiusOnDragging - BubbleUtils.dp2px(2)) / 2.0f;
            float junction = this.mTrackLength / this.mDelta * Math.abs(this.mProgress - this.mMin) + this.mLeft;
            this.mPaint.setTextSize((float)this.mSectionTextSize);
            this.mPaint.getTextBounds("0123456789", 0, "0123456789".length(), this.mRectText);
            float y_ = yTop + (float)this.mRectText.height() + (float)this.mThumbRadiusOnDragging + (float)this.mTextSpace;
            for (int i = 0; i <= this.mSectionCount; ++i) {
                float m;
                float x_ = xLeft + (float)i * this.mSectionOffset;
                this.mPaint.setColor(x_ <= junction ? this.mSecondTrackColor : this.mTrackColor);
                canvas.drawCircle(x_, yTop, r, this.mPaint);
                if (!isShowTextBelowSectionMark) continue;
                this.mPaint.setColor(this.mSectionTextColor);
                if (this.mSectionTextInterval > 1) {
                    if (!conditionInterval || i % this.mSectionTextInterval != 0) continue;
                    m = this.mMin + this.mSectionValue * (float)i;
                    canvas.drawText(this.isFloatType ? this.float2String(m) : (int)m + "", x_, y_, this.mPaint);
                    continue;
                }
                m = this.mMin + this.mSectionValue * (float)i;
                canvas.drawText(this.isFloatType ? this.float2String(m) : (int)m + "", x_, y_, this.mPaint);
            }
        }
        if (!this.isThumbOnDragging || this.isAlwaysShowBubble) {
            this.mThumbCenterX = this.mTrackLength / this.mDelta * (this.mProgress - this.mMin) + xLeft;
        }
        if (this.isShowThumbText && !this.isThumbOnDragging && this.isTouchToSeekAnimEnd) {
            this.mPaint.setColor(this.mThumbTextColor);
            this.mPaint.setTextSize((float)this.mThumbTextSize);
            this.mPaint.getTextBounds("0123456789", 0, "0123456789".length(), this.mRectText);
            float y_ = yTop + (float)this.mRectText.height() + (float)this.mThumbRadiusOnDragging + (float)this.mTextSpace;
            if (this.isFloatType || this.isShowProgressInFloat && this.mSectionTextPosition == 1 && this.mProgress != this.mMin && this.mProgress != this.mMax) {
                canvas.drawText(String.valueOf(this.getProgressFloat()), this.mThumbCenterX, y_, this.mPaint);
            } else {
                canvas.drawText(String.valueOf(this.getProgress()), this.mThumbCenterX, y_, this.mPaint);
            }
        }
        this.mPaint.setColor(this.mSecondTrackColor);
        this.mPaint.setStrokeWidth((float)this.mSecondTrackSize);
        canvas.drawLine(xLeft, yTop, this.mThumbCenterX, yTop, this.mPaint);
        this.mPaint.setColor(this.mTrackColor);
        this.mPaint.setStrokeWidth((float)this.mTrackSize);
        canvas.drawLine(this.mThumbCenterX, yTop, xRight, yTop, this.mPaint);
        this.mPaint.setColor(this.mThumbColor);
        canvas.drawCircle(this.mThumbCenterX, yTop, this.isThumbOnDragging ? (float)this.mThumbRadiusOnDragging : (float)this.mThumbRadius, this.mPaint);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.post(new Runnable(){

            @Override
            public void run() {
                BubbleSeekBar.this.requestLayout();
            }
        });
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        if (!this.isAlwaysShowBubble) {
            return;
        }
        if (visibility != 0) {
            this.hideBubble();
        } else if (this.triggerBubbleShowing) {
            this.showBubble();
        }
        super.onVisibilityChanged(changedView, visibility);
    }

    protected void onDetachedFromWindow() {
        this.hideBubble();
        this.mBubbleView = null;
        super.onDetachedFromWindow();
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.isThumbOnDragging = this.isThumbTouched(event);
                if (this.isThumbOnDragging) {
                    if (this.isSeekBySection && !this.triggerSeekBySection) {
                        this.triggerSeekBySection = true;
                    }
                    if (this.isAlwaysShowBubble && !this.triggerBubbleShowing) {
                        this.triggerBubbleShowing = true;
                    }
                    this.showBubble();
                    this.invalidate();
                } else if (this.isTouchToSeek && this.isTrackTouched(event)) {
                    if (this.isAlwaysShowBubble) {
                        this.hideBubble();
                        this.triggerBubbleShowing = true;
                    }
                    this.mThumbCenterX = event.getX();
                    if (this.mThumbCenterX < this.mLeft) {
                        this.mThumbCenterX = this.mLeft;
                    }
                    if (this.mThumbCenterX > this.mRight) {
                        this.mThumbCenterX = this.mRight;
                    }
                    this.mProgress = (this.mThumbCenterX - this.mLeft) * this.mDelta / this.mTrackLength + this.mMin;
                    this.mBubbleCenterRawX = this.mBubbleCenterRawSolidX + this.mTrackLength * (this.mProgress - this.mMin) / this.mDelta;
                    this.showBubble();
                    this.invalidate();
                }
                this.dx = this.mThumbCenterX - event.getX();
                break;
            }
            case 2: {
                if (!this.isThumbOnDragging) break;
                this.mThumbCenterX = event.getX() + this.dx;
                if (this.mThumbCenterX < this.mLeft) {
                    this.mThumbCenterX = this.mLeft;
                }
                if (this.mThumbCenterX > this.mRight) {
                    this.mThumbCenterX = this.mRight;
                }
                this.mProgress = (this.mThumbCenterX - this.mLeft) * this.mDelta / this.mTrackLength + this.mMin;
                this.mBubbleCenterRawX = this.mBubbleCenterRawSolidX + this.mTrackLength * (this.mProgress - this.mMin) / this.mDelta;
                this.mLayoutParams.x = (int)(this.mBubbleCenterRawX + 0.5f);
                this.mWindowManager.updateViewLayout((View)this.mBubbleView, (ViewGroup.LayoutParams)this.mLayoutParams);
                this.mBubbleView.setProgressText(this.isShowProgressInFloat ? String.valueOf(this.getProgressFloat()) : String.valueOf(this.getProgress()));
                this.invalidate();
                if (this.mProgressListener == null) break;
                this.mProgressListener.onProgressChanged(this.getProgress(), this.getProgressFloat());
                break;
            }
            case 1: 
            case 3: {
                if (this.isAutoAdjustSectionMark) {
                    if (this.isTouchToSeek) {
                        this.mBubbleView.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                BubbleSeekBar.this.isTouchToSeekAnimEnd = false;
                                BubbleSeekBar.this.autoAdjustSection();
                            }
                        }, this.isThumbOnDragging ? 0L : 300L);
                    } else {
                        this.autoAdjustSection();
                    }
                } else if (this.isThumbOnDragging || this.isTouchToSeek) {
                    this.mBubbleView.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            BubbleSeekBar.this.mBubbleView.animate().alpha(BubbleSeekBar.this.isAlwaysShowBubble ? 1.0f : 0.0f).setDuration(BubbleSeekBar.this.mAnimDuration).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                                public void onAnimationEnd(Animator animation) {
                                    if (!BubbleSeekBar.this.isAlwaysShowBubble) {
                                        BubbleSeekBar.this.hideBubble();
                                    }
                                    BubbleSeekBar.this.isThumbOnDragging = false;
                                    BubbleSeekBar.this.invalidate();
                                    if (BubbleSeekBar.this.mProgressListener != null) {
                                        BubbleSeekBar.this.mProgressListener.onProgressChanged(BubbleSeekBar.this.getProgress(), BubbleSeekBar.this.getProgressFloat());
                                    }
                                }

                                public void onAnimationCancel(Animator animation) {
                                    if (!BubbleSeekBar.this.isAlwaysShowBubble) {
                                        BubbleSeekBar.this.hideBubble();
                                    }
                                    BubbleSeekBar.this.isThumbOnDragging = false;
                                    BubbleSeekBar.this.invalidate();
                                }
                            }).start();
                        }
                    }, !this.isThumbOnDragging && this.isTouchToSeek ? 300L : 0L);
                }
                if (this.mProgressListener == null) break;
                this.mProgressListener.getProgressOnActionUp(this.getProgress(), this.getProgressFloat());
            }
        }
        return this.isThumbOnDragging || this.isTouchToSeek || super.onTouchEvent(event);
    }

    private boolean isThumbTouched(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        float x = this.mTrackLength / this.mDelta * (this.mProgress - this.mMin) + this.mLeft;
        float y = (float)this.getMeasuredHeight() / 2.0f;
        return (event.getX() - x) * (event.getX() - x) + (event.getY() - y) * (event.getY() - y) <= (this.mLeft + (float)BubbleUtils.dp2px(8)) * (this.mLeft + (float)BubbleUtils.dp2px(8));
    }

    private boolean isTrackTouched(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        return event.getX() >= (float)this.getPaddingLeft() && event.getX() <= (float)(this.getMeasuredWidth() - this.getPaddingRight()) && event.getY() >= (float)this.getPaddingTop() && event.getY() <= (float)(this.getPaddingTop() + this.mThumbRadiusOnDragging * 2);
    }

    private void showBubble() {
        if (this.mBubbleView == null || this.mBubbleView.getParent() != null) {
            return;
        }
        if (this.mLayoutParams == null) {
            this.mLayoutParams = new WindowManager.LayoutParams();
            this.mLayoutParams.gravity = 0x800033;
            this.mLayoutParams.width = -2;
            this.mLayoutParams.height = -2;
            this.mLayoutParams.format = -3;
            this.mLayoutParams.flags = 524328;
            this.mLayoutParams.type = BubbleUtils.isMIUI() || Build.VERSION.SDK_INT >= 25 ? 2 : 2005;
        }
        this.mLayoutParams.x = (int)(this.mBubbleCenterRawX + 0.5f);
        this.mLayoutParams.y = (int)(this.mBubbleCenterRawSolidY + 0.5f);
        this.mBubbleView.setAlpha(0.0f);
        this.mBubbleView.setVisibility(0);
        this.mBubbleView.animate().alpha(1.0f).setDuration(this.mAnimDuration).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                BubbleSeekBar.this.mWindowManager.addView((View)BubbleSeekBar.this.mBubbleView, (ViewGroup.LayoutParams)BubbleSeekBar.this.mLayoutParams);
            }
        }).start();
        this.mBubbleView.setProgressText(this.isShowProgressInFloat ? String.valueOf(this.getProgressFloat()) : String.valueOf(this.getProgress()));
    }

    private void autoAdjustSection() {
        int i;
        float x = 0.0f;
        for (i = 0; !(i > this.mSectionCount || (x = (float)i * this.mSectionOffset + this.mLeft) <= this.mThumbCenterX && this.mThumbCenterX - x <= this.mSectionOffset); ++i) {
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(this.mThumbCenterX);
        float x_ = bigDecimal.setScale(1, 4).floatValue();
        boolean onSection = x_ == x;
        AnimatorSet animatorSet = new AnimatorSet();
        ValueAnimator valueAnim = null;
        if (!onSection) {
            valueAnim = this.mThumbCenterX - x <= this.mSectionOffset / 2.0f ? ValueAnimator.ofFloat((float[])new float[]{this.mThumbCenterX, x}) : ValueAnimator.ofFloat((float[])new float[]{this.mThumbCenterX, (float)(i + 1) * this.mSectionOffset + this.mLeft});
            valueAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
            valueAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BubbleSeekBar.this.mThumbCenterX = ((Float)animation.getAnimatedValue()).floatValue();
                    BubbleSeekBar.this.mProgress = (BubbleSeekBar.this.mThumbCenterX - BubbleSeekBar.this.mLeft) * BubbleSeekBar.this.mDelta / BubbleSeekBar.this.mTrackLength + BubbleSeekBar.this.mMin;
                    BubbleSeekBar.this.mBubbleCenterRawX = BubbleSeekBar.this.mBubbleCenterRawSolidX + BubbleSeekBar.this.mThumbCenterX - BubbleSeekBar.this.mLeft;
                    ((BubbleSeekBar)BubbleSeekBar.this).mLayoutParams.x = (int)(BubbleSeekBar.this.mBubbleCenterRawX + 0.5f);
                    if (BubbleSeekBar.this.mBubbleView.getParent() != null) {
                        BubbleSeekBar.this.mWindowManager.updateViewLayout((View)BubbleSeekBar.this.mBubbleView, (ViewGroup.LayoutParams)BubbleSeekBar.this.mLayoutParams);
                    }
                    BubbleSeekBar.this.mBubbleView.setProgressText(BubbleSeekBar.this.isShowProgressInFloat ? String.valueOf(BubbleSeekBar.this.getProgressFloat()) : String.valueOf(BubbleSeekBar.this.getProgress()));
                    BubbleSeekBar.this.invalidate();
                    if (BubbleSeekBar.this.mProgressListener != null) {
                        BubbleSeekBar.this.mProgressListener.onProgressChanged(BubbleSeekBar.this.getProgress(), BubbleSeekBar.this.getProgressFloat());
                    }
                }
            });
        }
        ObjectAnimator alphaAnim = ObjectAnimator.ofFloat((Object)((Object)this.mBubbleView), (Property)View.ALPHA, (float[])new float[]{this.isAlwaysShowBubble ? 1.0f : 0.0f});
        if (onSection) {
            animatorSet.setDuration(this.mAnimDuration).play((Animator)alphaAnim);
        } else {
            animatorSet.setDuration(this.mAnimDuration).playTogether(new Animator[]{valueAnim, alphaAnim});
        }
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (!BubbleSeekBar.this.isAlwaysShowBubble) {
                    BubbleSeekBar.this.hideBubble();
                }
                BubbleSeekBar.this.mProgress = (BubbleSeekBar.this.mThumbCenterX - BubbleSeekBar.this.mLeft) * BubbleSeekBar.this.mDelta / BubbleSeekBar.this.mTrackLength + BubbleSeekBar.this.mMin;
                BubbleSeekBar.this.isThumbOnDragging = false;
                BubbleSeekBar.this.isTouchToSeekAnimEnd = true;
                BubbleSeekBar.this.invalidate();
                if (BubbleSeekBar.this.mProgressListener != null) {
                    BubbleSeekBar.this.mProgressListener.getProgressOnFinally(BubbleSeekBar.this.getProgress(), BubbleSeekBar.this.getProgressFloat());
                }
            }

            public void onAnimationCancel(Animator animation) {
                if (!BubbleSeekBar.this.isAlwaysShowBubble) {
                    BubbleSeekBar.this.hideBubble();
                }
                BubbleSeekBar.this.mProgress = (BubbleSeekBar.this.mThumbCenterX - BubbleSeekBar.this.mLeft) * BubbleSeekBar.this.mDelta / BubbleSeekBar.this.mTrackLength + BubbleSeekBar.this.mMin;
                BubbleSeekBar.this.isThumbOnDragging = false;
                BubbleSeekBar.this.isTouchToSeekAnimEnd = true;
                BubbleSeekBar.this.invalidate();
            }
        });
        animatorSet.start();
    }

    private void hideBubble() {
        this.mBubbleView.setVisibility(8);
        if (this.mBubbleView.getParent() != null) {
            this.mWindowManager.removeViewImmediate((View)this.mBubbleView);
        }
    }

    public void correctOffsetWhenContainerOnScrolling() {
        this.locatePositionOnScreen();
        if (this.mBubbleView.getParent() != null) {
            this.postInvalidate();
        }
    }

    private String getMinText() {
        return this.isFloatType ? this.float2String(this.mMin) : String.valueOf((int)this.mMin);
    }

    private String getMaxText() {
        return this.isFloatType ? this.float2String(this.mMax) : String.valueOf((int)this.mMax);
    }

    public float getMin() {
        return this.mMin;
    }

    public float getMax() {
        return this.mMax;
    }

    public void setProgress(float progress) {
        this.mProgress = progress;
        this.mBubbleCenterRawX = this.mBubbleCenterRawSolidX + this.mTrackLength * (this.mProgress - this.mMin) / this.mDelta;
        if (this.mProgressListener != null) {
            this.mProgressListener.onProgressChanged(this.getProgress(), this.getProgressFloat());
            this.mProgressListener.getProgressOnFinally(this.getProgress(), this.getProgressFloat());
        }
        if (this.isAlwaysShowBubble) {
            this.hideBubble();
            int[] location = new int[2];
            this.getLocationOnScreen(location);
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    BubbleSeekBar.this.showBubble();
                    BubbleSeekBar.this.triggerBubbleShowing = true;
                }
            }, location[0] == 0 && location[1] == 0 ? 200L : 0L);
        }
        this.postInvalidate();
    }

    public int getProgress() {
        if (this.isSeekBySection && this.triggerSeekBySection) {
            float half = this.mSectionValue / 2.0f;
            if (this.mProgress >= this.mPreSecValue) {
                if (this.mProgress >= this.mPreSecValue + half) {
                    this.mPreSecValue += this.mSectionValue;
                    return Math.round(this.mPreSecValue);
                }
                return Math.round(this.mPreSecValue);
            }
            if (this.mProgress >= this.mPreSecValue - half) {
                return Math.round(this.mPreSecValue);
            }
            this.mPreSecValue -= this.mSectionValue;
            return Math.round(this.mPreSecValue);
        }
        return Math.round(this.mProgress);
    }

    public float getProgressFloat() {
        return this.formatFloat(this.mProgress);
    }

    public OnProgressChangedListener getOnProgressChangedListener() {
        return this.mProgressListener;
    }

    public void setOnProgressChangedListener(OnProgressChangedListener onProgressChangedListener) {
        this.mProgressListener = onProgressChangedListener;
    }

    void config(BubbleConfigBuilder builder) {
        this.mMin = builder.min;
        this.mMax = builder.max;
        this.mProgress = builder.progress;
        this.isFloatType = builder.floatType;
        this.mTrackSize = builder.trackSize;
        this.mSecondTrackSize = builder.secondTrackSize;
        this.mThumbRadius = builder.thumbRadius;
        this.mThumbRadiusOnDragging = builder.thumbRadiusOnDragging;
        this.mTrackColor = builder.trackColor;
        this.mSecondTrackColor = builder.secondTrackColor;
        this.mThumbColor = builder.thumbColor;
        this.mSectionCount = builder.sectionCount;
        this.isShowSectionMark = builder.showSectionMark;
        this.isAutoAdjustSectionMark = builder.autoAdjustSectionMark;
        this.isShowSectionText = builder.showSectionText;
        this.mSectionTextSize = builder.sectionTextSize;
        this.mSectionTextColor = builder.sectionTextColor;
        this.mSectionTextPosition = builder.sectionTextPosition;
        this.mSectionTextInterval = builder.sectionTextInterval;
        this.isShowThumbText = builder.showThumbText;
        this.mThumbTextSize = builder.thumbTextSize;
        this.mThumbTextColor = builder.thumbTextColor;
        this.isShowProgressInFloat = builder.showProgressInFloat;
        this.isTouchToSeek = builder.touchToSeek;
        this.isSeekBySection = builder.seekBySection;
        this.mBubbleColor = builder.bubbleColor;
        this.mBubbleTextSize = builder.bubbleTextSize;
        this.mBubbleTextColor = builder.bubbleTextColor;
        this.isAlwaysShowBubble = builder.alwaysShowBubble;
        this.initConfigByPriority();
        this.calculateRadiusOfBubble();
        if (this.mProgressListener != null) {
            this.mProgressListener.onProgressChanged(this.getProgress(), this.getProgressFloat());
            this.mProgressListener.getProgressOnFinally(this.getProgress(), this.getProgressFloat());
        }
        this.mConfigBuilder = null;
        this.requestLayout();
    }

    public BubbleConfigBuilder getConfigBuilder() {
        if (this.mConfigBuilder == null) {
            this.mConfigBuilder = new BubbleConfigBuilder(this);
        }
        this.mConfigBuilder.min = this.mMin;
        this.mConfigBuilder.max = this.mMax;
        this.mConfigBuilder.progress = this.mProgress;
        this.mConfigBuilder.floatType = this.isFloatType;
        this.mConfigBuilder.trackSize = this.mTrackSize;
        this.mConfigBuilder.secondTrackSize = this.mSecondTrackSize;
        this.mConfigBuilder.thumbRadius = this.mThumbRadius;
        this.mConfigBuilder.thumbRadiusOnDragging = this.mThumbRadiusOnDragging;
        this.mConfigBuilder.trackColor = this.mTrackColor;
        this.mConfigBuilder.secondTrackColor = this.mSecondTrackColor;
        this.mConfigBuilder.thumbColor = this.mThumbColor;
        this.mConfigBuilder.sectionCount = this.mSectionCount;
        this.mConfigBuilder.showSectionMark = this.isShowSectionMark;
        this.mConfigBuilder.autoAdjustSectionMark = this.isAutoAdjustSectionMark;
        this.mConfigBuilder.showSectionText = this.isShowSectionText;
        this.mConfigBuilder.sectionTextSize = this.mSectionTextSize;
        this.mConfigBuilder.sectionTextColor = this.mSectionTextColor;
        this.mConfigBuilder.sectionTextPosition = this.mSectionTextPosition;
        this.mConfigBuilder.sectionTextInterval = this.mSectionTextInterval;
        this.mConfigBuilder.showThumbText = this.isShowThumbText;
        this.mConfigBuilder.thumbTextSize = this.mThumbTextSize;
        this.mConfigBuilder.thumbTextColor = this.mThumbTextColor;
        this.mConfigBuilder.showProgressInFloat = this.isShowProgressInFloat;
        this.mConfigBuilder.touchToSeek = this.isTouchToSeek;
        this.mConfigBuilder.seekBySection = this.isSeekBySection;
        this.mConfigBuilder.bubbleColor = this.mBubbleColor;
        this.mConfigBuilder.bubbleTextSize = this.mBubbleTextSize;
        this.mConfigBuilder.bubbleTextColor = this.mBubbleTextColor;
        this.mConfigBuilder.alwaysShowBubble = this.isAlwaysShowBubble;
        return this.mConfigBuilder;
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("save_instance", super.onSaveInstanceState());
        bundle.putFloat("progress", this.mProgress);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mProgress = bundle.getFloat("progress");
            super.onRestoreInstanceState(bundle.getParcelable("save_instance"));
            this.mBubbleView.setProgressText(this.isShowProgressInFloat ? String.valueOf(this.getProgressFloat()) : String.valueOf(this.getProgress()));
            if (this.isAlwaysShowBubble) {
                this.setProgress(this.mProgress);
            }
            return;
        }
        super.onRestoreInstanceState(state);
    }

    private String float2String(float value) {
        return String.valueOf(this.formatFloat(value));
    }

    private float formatFloat(float value) {
        BigDecimal bigDecimal = BigDecimal.valueOf(value);
        return bigDecimal.setScale(1, 4).floatValue();
    }

    private class BubbleView
    extends View {
        private Paint mBubblePaint;
        private Path mBubblePath;
        private RectF mBubbleRectF;
        private Rect mRect;
        private String mProgressText;

        BubbleView(Context context) {
            this(context, null);
        }

        BubbleView(Context context, AttributeSet attrs) {
            this(context, attrs, 0);
        }

        BubbleView(Context context, AttributeSet attrs, int defStyleAttr) {
            super(context, attrs, defStyleAttr);
            this.mProgressText = "";
            this.mBubblePaint = new Paint();
            this.mBubblePaint.setAntiAlias(true);
            this.mBubblePaint.setTextAlign(Paint.Align.CENTER);
            this.mBubblePath = new Path();
            this.mBubbleRectF = new RectF();
            this.mRect = new Rect();
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            this.setMeasuredDimension(3 * BubbleSeekBar.this.mBubbleRadius, 3 * BubbleSeekBar.this.mBubbleRadius);
            this.mBubbleRectF.set((float)this.getMeasuredWidth() / 2.0f - (float)BubbleSeekBar.this.mBubbleRadius, 0.0f, (float)this.getMeasuredWidth() / 2.0f + (float)BubbleSeekBar.this.mBubbleRadius, (float)(2 * BubbleSeekBar.this.mBubbleRadius));
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            this.mBubblePath.reset();
            float x0 = (float)this.getMeasuredWidth() / 2.0f;
            float y0 = (float)this.getMeasuredHeight() - (float)BubbleSeekBar.this.mBubbleRadius / 3.0f;
            this.mBubblePath.moveTo(x0, y0);
            float x1 = (float)((double)((float)this.getMeasuredWidth() / 2.0f) - Math.sqrt(3.0) / 2.0 * (double)BubbleSeekBar.this.mBubbleRadius);
            float y1 = 1.5f * (float)BubbleSeekBar.this.mBubbleRadius;
            this.mBubblePath.quadTo(x1 - (float)BubbleUtils.dp2px(2), y1 - (float)BubbleUtils.dp2px(2), x1, y1);
            this.mBubblePath.arcTo(this.mBubbleRectF, 150.0f, 240.0f);
            float x2 = (float)((double)((float)this.getMeasuredWidth() / 2.0f) + Math.sqrt(3.0) / 2.0 * (double)BubbleSeekBar.this.mBubbleRadius);
            this.mBubblePath.quadTo(x2 + (float)BubbleUtils.dp2px(2), y1 - (float)BubbleUtils.dp2px(2), x0, y0);
            this.mBubblePath.close();
            this.mBubblePaint.setColor(BubbleSeekBar.this.mBubbleColor);
            canvas.drawPath(this.mBubblePath, this.mBubblePaint);
            this.mBubblePaint.setTextSize((float)BubbleSeekBar.this.mBubbleTextSize);
            this.mBubblePaint.setColor(BubbleSeekBar.this.mBubbleTextColor);
            this.mBubblePaint.getTextBounds(this.mProgressText, 0, this.mProgressText.length(), this.mRect);
            Paint.FontMetrics fm = this.mBubblePaint.getFontMetrics();
            float baseline = (float)BubbleSeekBar.this.mBubbleRadius + (fm.descent - fm.ascent) / 2.0f - fm.descent;
            canvas.drawText(this.mProgressText, (float)this.getMeasuredWidth() / 2.0f, baseline, this.mBubblePaint);
        }

        void setProgressText(String progressText) {
            if (progressText != null && !this.mProgressText.equals(progressText)) {
                this.mProgressText = progressText;
                this.invalidate();
            }
        }
    }

    public static abstract class OnProgressChangedListenerAdapter
    implements OnProgressChangedListener {
        @Override
        public void onProgressChanged(int progress, float progressFloat) {
        }

        @Override
        public void getProgressOnActionUp(int progress, float progressFloat) {
        }

        @Override
        public void getProgressOnFinally(int progress, float progressFloat) {
        }
    }

    public static interface OnProgressChangedListener {
        public void onProgressChanged(int var1, float var2);

        public void getProgressOnActionUp(int var1, float var2);

        public void getProgressOnFinally(int var1, float var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TextPosition {
        public static final int SIDES = 0;
        public static final int BOTTOM_SIDES = 1;
        public static final int BELOW_SECTION_MARK = 2;
    }
}

