/*
 * Decompiled with CFR 0.152.
 */
package com.xujl.task.group;

import com.xujl.task.Emitter;
import com.xujl.task.Task;
import com.xujl.task.delegate.GroupTaskDelegate;
import com.xujl.task.group.GroupTask;
import com.xujl.task.group.GroupTaskBuilder;
import com.xujl.task.group.TaskConfig;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public abstract class GroupResultTask
extends Task<TaskConfig> {
    public final Object mLock = new Object();
    private Map<TaskConfig, GroupTask> mGroupTasks = new Hashtable<TaskConfig, GroupTask>();
    private Map<TaskConfig, GroupTask> mCompleteGroupTasks = new Hashtable<TaskConfig, GroupTask>();
    private GroupTaskBuilder mBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Emitter<TaskConfig> emitter) throws Exception {
        super.run(emitter);
        while (!this.isDestroy()) {
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.wait();
                Iterator<TaskConfig> iterator = this.mGroupTasks.keySet().iterator();
                while (iterator.hasNext()) {
                    TaskConfig config = iterator.next();
                    GroupTask groupTask = this.mGroupTasks.get(config);
                    if (config.getState() == 1) {
                        config.setState(2);
                        this.mCompleteGroupTasks.put(config, groupTask);
                        iterator.remove();
                        emitter.objNext(this.mCompleteGroupTasks.get(config));
                        continue;
                    }
                    if (config.getState() != 3) continue;
                    if (this.mBuilder.getGroupStrategy() == 0) {
                        if (config.getStrategy() == -1) continue;
                        if (config.getStrategy() == 1) {
                            this.cancelAllTask();
                            return;
                        }
                    }
                    if (this.mBuilder.getGroupStrategy() == 1) {
                        this.cancelAllTask();
                        return;
                    }
                    this.mCompleteGroupTasks.put(config, groupTask);
                    iterator.remove();
                }
                if (this.mGroupTasks.size() == 0) {
                    if (this.mBuilder.getGroupStrategy() == 1 && !this.isAllTaskComplete()) {
                        return;
                    }
                    HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
                    for (TaskConfig config : this.mCompleteGroupTasks.keySet()) {
                        resultMap.put(config.getResultTag(), config.getResultData());
                    }
                    emitter.objNext(resultMap, -1);
                    return;
                }
            }
        }
    }

    private void cancelAllTask() {
        for (TaskConfig config : this.mGroupTasks.keySet()) {
            this.mGroupTasks.get(config).onDestroy();
        }
    }

    private boolean isAllTaskComplete() {
        for (TaskConfig config : this.mCompleteGroupTasks.keySet()) {
            if (config.getState() != 3) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onObjNext(int code, Object obj) {
        super.onObjNext(code, obj);
        if (code == 0) {
            GroupTaskDelegate delegate = (GroupTaskDelegate)((GroupTask)obj).getDelegate();
            this.oneTaskComplete(delegate.getGroupConfig().getResultTag(), delegate.getGroupConfig().getResultData());
        } else {
            this.allTaskComplete((HashMap)obj);
        }
    }

    public abstract void oneTaskComplete(Object var1, Object var2);

    public abstract void allTaskComplete(HashMap<Object, Object> var1);

    public void setGroupTasks(Map<TaskConfig, GroupTask> groupTasks) {
        this.mGroupTasks = groupTasks;
    }

    public void setBuilder(GroupTaskBuilder builder) {
        this.mBuilder = builder;
    }

    public Object getLock() {
        return this.mLock;
    }
}

