/*
 * Decompiled with CFR 0.152.
 */
package com.xujl.task.delegate;

import com.xujl.task.Emitter;
import com.xujl.task.IFinishNotify;
import com.xujl.task.ITaskFinish;
import com.xujl.task.RxExecutor;
import com.xujl.task.RxLife;
import com.xujl.task.RxLog;
import com.xujl.task.Task;
import java.util.Random;
import java.util.concurrent.Future;

public class AbstractTaskDelegate<T>
implements RxLife {
    protected static final String TAG = "Task";
    protected Emitter<T> mEmitter;
    protected Future<T> mFuture;
    protected boolean isDestroy;
    protected ITaskFinish mITaskFinish;
    protected IFinishNotify mFinishNotify;
    protected long taskId;
    protected boolean needCancel;
    protected Task<T> mTask;
    protected int retryMaxCount = -2;
    protected int retryCount;

    public AbstractTaskDelegate(Task<T> task, boolean needCancel) {
        this.mTask = task;
        this.mEmitter = new Emitter<T>(task);
        this.mTask.bindLife(this);
        this.needCancel = needCancel;
        this.taskId = System.currentTimeMillis() + (long)new Random().nextInt(10000);
    }

    @Override
    public void onDestroy() {
        if (this.mFinishNotify != null) {
            this.mFinishNotify.onDestroy(this.mTask);
        }
        if (this.mEmitter == null) {
            return;
        }
        if (this.mFuture != null && this.needCancel) {
            this.mFuture.cancel(true);
        }
        this.recycle();
    }

    private void recycle() {
        this.isDestroy = true;
        this.mEmitter = null;
    }

    @Override
    public boolean isDestroy() {
        return this.isDestroy;
    }

    public void onError(Exception e) {
        if (this.mITaskFinish != null) {
            this.mITaskFinish.onFinish(this);
        }
        this.onDestroy();
        if (this.retryMaxCount != -2) {
            if (this.retryMaxCount != -1 && this.retryCount >= this.retryMaxCount) {
                RxLog.d(TAG, "\u8d85\u8fc7\u6700\u5927\u91cd\u8bd5\u6b21\u6570\uff01\u4efb\u52a1\u5931\u8d25\uff0c\u7ed3\u675f");
                return;
            }
            ++this.retryCount;
            RxLog.d(TAG, "\u4efb\u52a1\u5931\u8d25\uff0c\u91cd\u8bd5\u7b2c" + this.retryCount + "\u6b21\uff01");
            this.reset();
            RxExecutor.getInstance().executeTask(this.mTask);
        }
    }

    public void onFinished() {
        if (this.mITaskFinish != null) {
            this.mITaskFinish.onFinish(this);
        }
        this.onDestroy();
    }

    public boolean cancel(boolean interrupt) {
        this.isDestroy = true;
        if (this.mFuture == null) {
            return false;
        }
        return this.mFuture.cancel(interrupt);
    }

    public void reset() {
        this.mEmitter = new Emitter<T>(this.mTask);
        this.mTask.bindLife(this);
        this.isDestroy = false;
    }

    public Future<T> getFuture() {
        return this.mFuture;
    }

    public void setFuture(Future<T> future) {
        this.mFuture = future;
    }

    public boolean isNeedCancel() {
        return this.needCancel;
    }

    public void setNeedCancel(boolean needCancel) {
        this.needCancel = needCancel;
    }

    @Override
    public final void setITaskFinish(ITaskFinish iTaskFinish) {
        this.mITaskFinish = iTaskFinish;
    }

    public Emitter getEmitter() {
        return this.mEmitter;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setFinishNotify(IFinishNotify finishNotify) {
        this.mFinishNotify = finishNotify;
    }

    public int getRetryMaxCount() {
        return this.retryMaxCount;
    }

    public void setRetryMaxCount(int retryMaxCount) {
        this.retryMaxCount = retryMaxCount;
    }

    public boolean canRetry() {
        if (this.retryMaxCount == -1) {
            return true;
        }
        return this.retryMaxCount != -2 && this.retryCount < this.retryMaxCount;
    }

    public int getRetryCount() {
        return this.retryCount;
    }
}

