/*
 * Decompiled with CFR 0.152.
 */
package com.xujl.task;

import com.xujl.task.Emitter;
import com.xujl.task.IFinishNotify;
import com.xujl.task.ITaskFinish;
import com.xujl.task.RxLife;
import com.xujl.task.TaskBuilder;
import com.xujl.task.delegate.AbstractTaskDelegate;
import com.xujl.task.delegate.GroupTaskDelegate;
import com.xujl.task.delegate.NormalTaskDelegate;
import java.util.concurrent.Future;

public abstract class Task<T>
implements RxLife {
    private AbstractTaskDelegate<T> mDelegate;
    private int mTaskType;

    public Task() {
        this(false, 0);
    }

    public Task(boolean needCancel) {
        this(needCancel, 0);
    }

    public Task(TaskBuilder builder) {
        this(builder.isNeedCancel(), builder.getTaskType(), builder.getRetryMaxCount());
    }

    public Task(boolean needCancel, int type) {
        this(needCancel, type, -2);
    }

    public Task(boolean needCancel, int type, int retryMaxCount) {
        this.mTaskType = type;
        if (type == 0) {
            this.mDelegate = new NormalTaskDelegate(this, needCancel);
            this.mDelegate.setRetryMaxCount(retryMaxCount);
        } else if (type == 1) {
            this.mDelegate = new GroupTaskDelegate(this, needCancel);
            this.mDelegate.setRetryMaxCount(retryMaxCount);
        }
    }

    public void run(Emitter<T> emitter) throws Exception {
    }

    @Override
    public void onDestroy() {
        this.mDelegate.onDestroy();
    }

    @Override
    public boolean isDestroy() {
        return this.mDelegate.isDestroy();
    }

    public void onlyRunUiTask() {
    }

    public void bindLife(RxLife rxLife) {
    }

    public void onNext(T data) {
    }

    public void onObjNext(int code, Object obj) {
    }

    public void onError(Exception e) {
        this.mDelegate.onError(e);
    }

    public void onFinished() {
        this.mDelegate.onFinished();
    }

    public boolean cancel(boolean interrupt) {
        return this.mDelegate.cancel(interrupt);
    }

    public void reset() {
        this.mDelegate.reset();
    }

    public Future<T> getFuture() {
        return this.mDelegate.getFuture();
    }

    public void setFuture(Future<T> future) {
        this.mDelegate.setFuture(future);
    }

    public boolean isNeedCancel() {
        return this.mDelegate.isNeedCancel();
    }

    public void setNeedCancel(boolean needCancel) {
        this.mDelegate.setNeedCancel(needCancel);
    }

    @Override
    public final void setITaskFinish(ITaskFinish iTaskFinish) {
        this.mDelegate.setITaskFinish(iTaskFinish);
    }

    Emitter getEmitter() {
        return this.mDelegate.getEmitter();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public long getTaskId() {
        return this.mDelegate.getTaskId();
    }

    void setFinishNotify(IFinishNotify finishNotify) {
        this.mDelegate.setFinishNotify(finishNotify);
    }

    public int getTaskType() {
        return this.mTaskType;
    }

    public AbstractTaskDelegate<T> getDelegate() {
        return this.mDelegate;
    }

    public int getRetryMaxCount() {
        return this.mDelegate.getRetryMaxCount();
    }

    public void setRetryMaxCount(int retryMaxCount) {
        this.mDelegate.setRetryMaxCount(retryMaxCount);
    }

    public boolean canRetry() {
        return this.mDelegate.canRetry();
    }

    public int getRetryCount() {
        return this.mDelegate.getRetryCount();
    }
}

