/*
 * Decompiled with CFR 0.152.
 */
package com.xujl.task;

import com.xujl.task.Emitter;
import com.xujl.task.Task;

public class RxHelper {

    public static abstract class RecycleTask
    extends Task<Integer> {
        private long space;
        private int maxCount;

        public RecycleTask(boolean needCancel, long space, int maxCount) {
            super(needCancel);
            this.space = space;
            this.maxCount = maxCount;
        }

        public RecycleTask(long space, int maxCount) {
            this.space = space;
            this.maxCount = maxCount;
        }

        @Override
        public void run(Emitter<Integer> emitter) throws Exception {
            for (int count = 1; !(this.maxCount != -1 && count > this.maxCount || this.isDestroy()); ++count) {
                Thread.sleep(this.space);
                emitter.next(count);
            }
        }

        @Override
        public void onNext(Integer data) {
            super.onNext(data);
            this.count(data);
        }

        public abstract void count(int var1);
    }

    public static abstract class CountDownTask
    extends Task<Long> {
        private long mils;
        private long space;

        public CountDownTask(long mils, long space) {
            this.mils = mils;
            this.space = space;
        }

        public CountDownTask(boolean needCancel, long mils, long space) {
            super(needCancel);
            this.mils = mils;
            this.space = space;
        }

        @Override
        public void run(Emitter<Long> emitter) throws Exception {
            long count = this.mils;
            while (count > 0L && !this.isDestroy()) {
                Thread.sleep(this.space);
                emitter.next(count -= this.space);
            }
        }

        @Override
        public void onNext(Long time) {
            super.onNext(time);
            this.count(time);
        }

        public abstract void count(long var1);
    }

    public static abstract class DelayTask
    extends Task<Long> {
        private long time;

        public DelayTask(long time) {
            this.time = time;
        }

        public DelayTask(boolean needCancel, long time) {
            super(needCancel);
            this.time = time;
        }

        @Override
        public void run(Emitter<Long> emitter) throws Exception {
            super.run(emitter);
            Thread.sleep(this.time);
        }

        @Override
        public void onFinished() {
            super.onFinished();
            this.timeOver();
        }

        public abstract void timeOver();
    }
}

