/*
 * Decompiled with CFR 0.152.
 */
package com.xujl.task;

import com.xujl.task.Emitter;
import com.xujl.task.IFinishNotify;
import com.xujl.task.RxLog;
import com.xujl.task.Task;
import com.xujl.task.TaskCallable;
import com.xujl.task.delegate.GroupTaskDelegate;
import com.xujl.task.group.GroupTask;
import com.xujl.task.group.GroupTaskBuilder;
import com.xujl.task.group.TaskConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RxExecutor
implements IFinishNotify {
    private static final String TAG = "RxExecutor";
    private ExecutorService mExecutor;
    private List<Task> mTaskList = new ArrayList<Task>(1024);

    private RxExecutor() {
    }

    public void init() {
        int processors = Runtime.getRuntime().availableProcessors();
        this.init(processors * 4);
    }

    public void init(int corePoolSize) {
        this.mExecutor = new ThreadPoolExecutor(corePoolSize, corePoolSize * 2, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), new ThreadPoolExecutor.AbortPolicy());
    }

    public void init(ExecutorService executor) {
        this.mExecutor = executor;
    }

    public <T> void executeTask(Task<T> task) {
        TaskCallable thread = new TaskCallable();
        this.executeTask(thread, task);
    }

    public <T> void executeTask(TaskCallable<T> thread, Task<T> task) {
        thread.setTask(task);
        if (this.mExecutor == null) {
            this.init();
        }
        if (this.mExecutor.isShutdown()) {
            RxLog.e(TAG, "\u7ebf\u7a0b\u6c60\u5df2shutdown,\u65e0\u6cd5\u6dfb\u52a0\u65b0\u4efb\u52a1\uff01\uff01\uff01");
            return;
        }
        Future<T> submit = this.mExecutor.submit(thread);
        task.setFuture(submit);
        task.setFinishNotify(this);
        if (!this.mTaskList.contains(task)) {
            this.mTaskList.add(task);
        }
    }

    public void executeTaskGroup(GroupTaskBuilder builder) {
        this.executeTask(builder.getResultTask());
        Map<TaskConfig, GroupTask> tasks = builder.getGroupTasks();
        builder.getResultTask().setGroupTasks(builder.getGroupTasks());
        for (TaskConfig config : tasks.keySet()) {
            GroupTask task = tasks.get(config);
            GroupTaskDelegate delegate = (GroupTaskDelegate)task.getDelegate();
            delegate.setGroupConfig(config);
            delegate.setLock(builder.getResultTask().getLock());
            this.executeTask(task);
        }
    }

    public void executeUiTask(Task task) {
        Emitter emitter = task.getEmitter();
        if (emitter != null) {
            emitter.runUi();
        }
    }

    public void executeRunnableTask(Runnable runnable) {
        if (this.mExecutor == null) {
            this.init();
        }
        if (this.mExecutor.isShutdown()) {
            RxLog.e(TAG, "\u7ebf\u7a0b\u6c60\u5df2shutdown,\u65e0\u6cd5\u6dfb\u52a0\u65b0\u4efb\u52a1\uff01\uff01\uff01");
            return;
        }
        if (runnable != null) {
            this.mExecutor.execute(runnable);
        }
    }

    public boolean cancelTaskForId(long taskId, boolean interrupt) {
        for (Task task : this.mTaskList) {
            if (task == null || task.getTaskId() != taskId) continue;
            return task.cancel(interrupt);
        }
        return false;
    }

    public void shutDown(boolean isInterrupt) {
        this.mExecutor.shutdown();
        if (isInterrupt) {
            try {
                if (!this.mExecutor.awaitTermination(2L, TimeUnit.SECONDS)) {
                    this.mExecutor.shutdownNow();
                }
            }
            catch (InterruptedException ie) {
                this.mExecutor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public void shutDown() {
        this.shutDown(false);
    }

    public void setDebug(boolean isDebug) {
        RxLog.sIsDebug = isDebug;
    }

    public void printRunnableMsg() {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)this.mExecutor;
        executor.getActiveCount();
        RxLog.d(TAG, "CorePoolSize:" + executor.getCorePoolSize() + "PoolSize:" + executor.getPoolSize() + "TaskCount:" + executor.getTaskCount() + "ActiveCount:" + executor.getActiveCount());
    }

    public ExecutorService getExecutor() {
        return this.mExecutor;
    }

    public static RxExecutor getInstance() {
        return Holder.RX_EXECUTOR;
    }

    @Override
    public void onDestroy(Task task) {
        if (this.mTaskList.contains(task)) {
            this.mTaskList.remove(task);
        }
    }

    private static class Holder {
        private static final RxExecutor RX_EXECUTOR = new RxExecutor();

        private Holder() {
        }
    }
}

