/*
 * Decompiled with CFR 0.152.
 */
package com.xujl.task;

import android.os.Message;
import com.xujl.task.RxHandler;
import com.xujl.task.RxMessage;
import com.xujl.task.Task;

public class Emitter<T> {
    private static final String TAG = "Emitter";
    public static final int ERROR = -1;
    public static final int NEXT = 0;
    public static final int FINISH = 1;
    public static final int UI = 2;
    private Task<T> task;

    public Emitter(Task<T> task) {
        this.task = task;
    }

    private void sendMessage(int code, T data) {
        Message message = new Message();
        message.what = code;
        message.obj = new RxMessage<T>(this.task, data);
        RxHandler.getInstance().sendMessage(message);
    }

    private void sendObj(int code, Object obj, int objCode) {
        Message message = new Message();
        message.what = code;
        message.obj = new RxMessage(this.task).setObj(obj).setObjCode(objCode);
        RxHandler.getInstance().sendMessage(message);
    }

    private void sendObj(int code, Object obj) {
        this.sendObj(code, obj, 0);
    }

    public void error(Exception e) {
        this.sendObj(-1, e);
    }

    public void next(T data) {
        this.sendMessage(0, data);
    }

    public void objNext(Object obj, int objCode) {
        this.sendObj(0, obj, objCode);
    }

    public void objNext(Object obj) {
        this.sendObj(0, obj);
    }

    public void finish() {
        this.sendObj(1, null);
    }

    void runUi() {
        this.sendObj(2, null);
    }
}

