package com.xujl.task.group;

/**
 * 单个任务配置策略
 */
public class TaskConfig {
    /**
     * 单个任务对组任务的
     * 策略影响，仅当组任务策略
     * 为ALL_COMPLETE时生效
     * 且只可选择
     * {@link com.xujl.task.group.GroupTaskStrategy}
     */
    @GroupTaskStrategy.Enum2
    private int strategy = GroupTaskStrategy.NONE;
    private GroupTaskBuilder mBuilder;
    /**
     * 任务执行结果数据
     */
    private Object mResultData;
    /**
     * 任务执行结果数据标识
     */
    private Object mResultTag;
    /**
     * 任务状态 {@link com.xujl.task.group.GroupTaskState}
     */
    @GroupTaskState.Enum
    private int state = GroupTaskState.STATE_DEFAULT;

    public TaskConfig (GroupTaskBuilder builder) {
        mBuilder = builder;
    }

    public int getStrategy () {
        return strategy;
    }

    public TaskConfig setStrategy (@GroupTaskStrategy.Enum2 int strategy) {
        this.strategy = strategy;
        return this;
    }

    public <T> TaskConfig addGroupTask (GroupTask<T> task) {
        return mBuilder.addGroupTask(task);
    }

    public GroupTaskBuilder build () {
        return mBuilder;
    }

    public Object getResultTag () {
        return mResultTag;
    }

    public TaskConfig setResultTag (Object resultTag) {
        mResultTag = resultTag;
        return this;
    }

    Object getResultData () {
        return mResultData;
    }

    public void setResultData (Object resultData) {
        mResultData = resultData;
    }

    int getState () {
        return state;
    }

    public void setState (int state) {
        this.state = state;
    }


}
